/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class StringEditor
extends PropertyEditorSupport
implements FormAwareEditor,
ExPropertyEditor,
DocumentListener,
Runnable {
    private boolean editable = true;
    private Component customEditor;
    private JTextComponent textComp;
    private boolean htmlText;
    private boolean valueUpdateInvoked;

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (!this.valueUpdateInvoked && this.textComp != null && this.textComp.isShowing()) {
            this.setValueToCustomEditor();
        }
    }

    @Override
    public void setAsText(String text) {
        this.setValue(text);
    }

    @Override
    public String getJavaInitializationString() {
        String s = (String)this.getValue();
        return "\"" + FormUtils.escapeCharactersInString(s) + "\"";
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            JTextArea textArea = new JTextArea();
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setColumns(60);
            textArea.setRows(8);
            textArea.getDocument().addDocumentListener(this);
            textArea.getAccessibleContext().setAccessibleName(NbBundle.getBundle(StringEditor.class).getString("ACSN_StringEditorTextArea"));
            textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(StringEditor.class).getString("ACSD_StringEditorTextArea"));
            JScrollPane scroll = new JScrollPane();
            scroll.setViewportView(textArea);
            JLabel htmlTipLabel = new JLabel(NbBundle.getMessage(StringEditor.class, (String)"StringEditor.htmlTipLabel.text"));
            JPanel panel = new JPanel();
            GroupLayout layout = new GroupLayout((Container)panel);
            layout.setAutocreateGaps(true);
            panel.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup().add((Component)scroll).add((Component)htmlTipLabel)).addContainerGap());
            layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)scroll).add((Component)htmlTipLabel));
            this.customEditor = panel;
            this.textComp = textArea;
            htmlTipLabel.setVisible(this.htmlText);
        }
        this.textComp.setEditable(this.editable);
        this.setValueToCustomEditor();
        return this.customEditor;
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        this.htmlText = FormUtils.isHTMLTextProperty(property);
    }

    @Override
    public void updateFormVersionLevel() {
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.editable = prop.canWrite();
            if (this.textComp != null) {
                this.textComp.setEditable(this.editable);
            }
        }
    }

    private void setValueToCustomEditor() {
        this.valueUpdateInvoked = true;
        this.textComp.setText(this.getAsText());
        this.valueUpdateInvoked = false;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.valueUpdateInvoked) {
            this.valueUpdateInvoked = true;
            EventQueue.invokeLater(this);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.valueUpdateInvoked) {
            this.valueUpdateInvoked = true;
            EventQueue.invokeLater(this);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void run() {
        if (this.textComp != null) {
            this.setValue(this.textComp.getText());
        }
        this.valueUpdateInvoked = false;
    }
}

