/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbCollections;

class ChooseBeansWizardPanel
implements WizardDescriptor.Panel<AddToPaletteWizard> {
    private List<? extends ClassSource.Entry> currentFiles;
    private List<BeanInstaller.ItemInfo> markedBeans;
    private List<BeanInstaller.ItemInfo> allBeans;
    private Class<? extends ClassSource.Entry> sourceType;
    private BeanSelector beanSelector;
    private JLabel noBeansLabel;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    ChooseBeansWizardPanel() {
    }

    public Component getComponent() {
        if (this.markedBeans == null && (this.allBeans == null || this.allBeans.isEmpty())) {
            String string;
            if (this.sourceType == ClassSource.JarEntry.class) {
                string = "MSG_NoBeanInJAR";
            } else if (this.sourceType == ClassSource.LibraryEntry.class) {
                string = "MSG_NoBeanInLibrary";
            } else if (this.sourceType == ClassSource.ProjectEntry.class) {
                string = "MSG_NoBeanInProject";
            } else {
                throw new IllegalArgumentException();
            }
            this.noBeansLabel = new JLabel(PaletteUtils.getBundleString(string));
            this.noBeansLabel.setPreferredSize(new Dimension(400, 300));
            this.noBeansLabel.setVerticalAlignment(1);
            this.noBeansLabel.setName(PaletteUtils.getBundleString("CTL_NoBeans_Caption"));
            this.noBeansLabel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            return this.noBeansLabel;
        }
        if (this.beanSelector == null) {
            this.beanSelector = new BeanSelector();
            this.beanSelector.setName(PaletteUtils.getBundleString("CTL_SelectBeans_Caption"));
            this.beanSelector.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            if (this.markedBeans != null || this.allBeans != null) {
                this.beanSelector.setBeans(this.markedBeans, this.allBeans);
            }
            Listener listener = new Listener();
            this.beanSelector.list.addListSelectionListener(listener);
            this.beanSelector.radio1.addActionListener(listener);
            this.beanSelector.radio2.addActionListener(listener);
        }
        return this.beanSelector;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        return this.beanSelector != null && this.beanSelector.getSelectedBeans().size() > 0;
    }

    public void readSettings(AddToPaletteWizard addToPaletteWizard) {
        this.sourceType = addToPaletteWizard.getSourceType();
        List<? extends ClassSource.Entry> list = addToPaletteWizard.getJARFiles();
        if (((Object)list).equals(this.currentFiles)) {
            return;
        }
        this.currentFiles = list;
        this.allBeans = null;
        this.markedBeans = BeanInstaller.findJavaBeansInJar(list);
        if (this.markedBeans != null) {
            Collections.sort(this.markedBeans);
        } else {
            this.allBeans = BeanInstaller.findJavaBeans(list);
            Collections.sort(this.allBeans);
        }
        if (this.beanSelector != null) {
            this.beanSelector.setBeans(this.markedBeans, this.allBeans);
        }
    }

    public void storeSettings(AddToPaletteWizard addToPaletteWizard) {
        if (this.beanSelector != null) {
            List<BeanInstaller.ItemInfo> list = this.beanSelector.getSelectedBeans();
            BeanInstaller.ItemInfo[] itemInfoArray = new BeanInstaller.ItemInfo[list.size()];
            list.toArray(itemInfoArray);
            addToPaletteWizard.setSelectedBeans(itemInfoArray);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    class Listener
    implements ListSelectionListener,
    ActionListener {
        Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ChooseBeansWizardPanel.this.cs.fireChange();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if ("SHOW MARKED".equals(actionEvent.getActionCommand())) {
                ChooseBeansWizardPanel.this.beanSelector.setDisplayedBeans(ChooseBeansWizardPanel.this.markedBeans);
            } else if ("SHOW ALL".equals(actionEvent.getActionCommand())) {
                if (ChooseBeansWizardPanel.this.allBeans == null) {
                    ChooseBeansWizardPanel.this.allBeans = BeanInstaller.findJavaBeans(ChooseBeansWizardPanel.this.currentFiles);
                    Collections.sort(ChooseBeansWizardPanel.this.allBeans);
                }
                ChooseBeansWizardPanel.this.beanSelector.setDisplayedBeans(ChooseBeansWizardPanel.this.allBeans);
            }
        }
    }

    private static class ItemInfoRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public ItemInfoRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = ((BeanInstaller.ItemInfo)object).classname;
            this.setToolTipText(string);
            int n2 = string.lastIndexOf(46);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            this.setText(string);
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }

    static class BeanSelector
    extends JPanel {
        JList list;
        JRadioButton radio1;
        JRadioButton radio2;

        BeanSelector() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)PaletteUtils.getBundleString("CTL_SelectBeans"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            gridBagConstraints.anchor = 17;
            this.add((Component)jLabel, gridBagConstraints);
            this.list = new JList();
            this.list.setLayoutOrientation(1);
            this.list.setVisibleRowCount(0);
            this.list.setCellRenderer(new ItemInfoRenderer());
            this.list.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_CTL_SelectBeans"));
            jLabel.setLabelFor(this.list);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.list);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)jScrollPane, gridBagConstraints);
            this.radio1 = new JRadioButton();
            this.radio1.setActionCommand("SHOW MARKED");
            Mnemonics.setLocalizedText((AbstractButton)this.radio1, (String)PaletteUtils.getBundleString("CTL_ShowMarked"));
            this.radio1.setToolTipText(PaletteUtils.getBundleString("HINT_ShowMarked"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.radio1, gridBagConstraints);
            this.radio2 = new JRadioButton();
            this.radio2.setActionCommand("SHOW ALL");
            Mnemonics.setLocalizedText((AbstractButton)this.radio2, (String)PaletteUtils.getBundleString("CTL_ShowAllClasses"));
            this.radio2.setToolTipText(PaletteUtils.getBundleString("HINT_ShowAllClasses"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.radio2, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.radio1);
            buttonGroup.add(this.radio2);
            this.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("ACSD_SelectBeansDialog"));
        }

        void setBeans(List<BeanInstaller.ItemInfo> list, List<BeanInstaller.ItemInfo> list2) {
            if (list == null) {
                this.radio1.setEnabled(false);
            } else {
                this.radio1.setEnabled(true);
                this.radio1.setSelected(true);
                this.setDisplayedBeans(list);
            }
            if (list2 != null && list == null) {
                this.radio2.setSelected(true);
                this.setDisplayedBeans(list2);
            }
        }

        void setDisplayedBeans(final List<BeanInstaller.ItemInfo> list) {
            this.list.setModel(new AbstractListModel(){

                @Override
                public int getSize() {
                    return list.size();
                }

                @Override
                public Object getElementAt(int n) {
                    return list.get(n);
                }
            });
        }

        List<BeanInstaller.ItemInfo> getSelectedBeans() {
            return NbCollections.checkedListByCopy(Arrays.asList(this.list.getSelectedValues()), BeanInstaller.ItemInfo.class, (boolean)true);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 300);
        }
    }
}

