/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.common;

import java.util.ArrayList;
import java.util.List;

final class AtomicElementRepairer {
    private final List<String> l;
    private final List<String> nue;
    static final String END_DELIMITER = "}}}";
    static final String START_DELIMITER = "{{{";

    AtomicElementRepairer(List<String> l) {
        this.l = l;
        this.nue = new ArrayList<String>(l == null ? 0 : l.size());
    }

    List<String> restoreAtomicItems() {
        StringBuilder sb = null;
        for (String s : this.l) {
            boolean inQuote = sb != null;
            OneStringHandler h = new OneStringHandler(s, inQuote);
            while (h != null && !"".equals(h.getString().trim())) {
                if (!h.involvesQuoting()) {
                    if (inQuote) {
                        sb.append(s);
                    } else {
                        this.nue.add(h.getString());
                    }
                    h = null;
                    continue;
                }
                if (h.isOpen()) {
                    if (h.hasLeader()) {
                        this.nue.add(h.getLeader());
                    }
                    String content = h.getContents();
                    if (h.isClose()) {
                        if (content != null) {
                            this.nue.add(content);
                        }
                        if (h.hasTrailer()) {
                            h = new OneStringHandler(h.getTrailer(), false);
                            continue;
                        }
                        h = null;
                        continue;
                    }
                    sb = new StringBuilder();
                    inQuote = true;
                    if (content != null) {
                        sb.append(content);
                    }
                    h = null;
                    continue;
                }
                if (!h.isClose()) continue;
                sb.append(h.getToClose());
                this.nue.add(sb.toString());
                sb = null;
                inQuote = false;
                if (h.hasTrailer()) {
                    h = new OneStringHandler(h.getTrailer(), false);
                    continue;
                }
                h = null;
            }
        }
        return this.nue;
    }

    OneStringHandler createHandler(String s, boolean inQuote) {
        return new OneStringHandler(s, inQuote);
    }

    final class OneStringHandler {
        private final String s;
        int startIx;
        int endIx;
        private final boolean inQuote;

        OneStringHandler(String s, boolean inQuote) {
            this.s = s;
            this.startIx = s.indexOf(AtomicElementRepairer.START_DELIMITER);
            this.endIx = s.indexOf(AtomicElementRepairer.END_DELIMITER);
            this.inQuote = inQuote;
        }

        String getString() {
            return this.s;
        }

        boolean involvesQuoting() {
            return this.isOpen() || this.isClose();
        }

        boolean isOpen() {
            return !this.inQuote && this.startIx >= 0;
        }

        boolean isClose() {
            return (this.inQuote || this.isOpen()) && this.endIx >= 0 && this.endIx > this.startIx;
        }

        boolean hasLeader() {
            return !this.inQuote && this.isOpen() && this.startIx > 0 && this.getLeader().trim().length() > 0;
        }

        String getLeader() {
            String result = this.inQuote ? null : (this.startIx > 0 ? this.s.substring(0, this.startIx) : null);
            return result;
        }

        boolean hasTrailer() {
            return this.isClose() && this.endIx < this.s.length() - 3 && this.getTrailer().trim().length() > 0;
        }

        String getTrailer() {
            String result = this.endIx >= 0 && this.endIx < this.s.length() - 3 ? this.s.substring(this.endIx + 3) : null;
            return result;
        }

        String getToClose() {
            String result = this.s.substring(0, this.endIx);
            return result;
        }

        boolean hasContents() {
            boolean result;
            boolean bl = result = this.s.length() > 0;
            if (result) {
                boolean isPureContent = (!this.inQuote || this.endIx < 0) && this.startIx < 0;
                boolean openIsNotAtEnd = this.isOpen() && this.s.length() > this.startIx + 3;
                boolean closeIsNotAtStart = this.isClose() && this.endIx > 0;
                boolean pureQuote = this.inQuote && !this.isClose();
                result = this.s.length() > 0 && (isPureContent || openIsNotAtEnd || closeIsNotAtStart || pureQuote);
            }
            return result;
        }

        String getContents() {
            String result;
            if (!this.hasContents()) {
                return null;
            }
            if (this.isOpen() && !this.isClose()) {
                result = this.s.substring(this.startIx + 3);
            } else if (this.isOpen() && this.isClose()) {
                result = this.s.substring(this.startIx + 3, this.endIx);
            } else if (!this.isOpen() && this.isClose()) {
                result = this.s.substring(0, this.endIx);
            } else {
                return this.s;
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.s);
            sb.append(':');
            sb.append(" open:").append(this.isOpen()).append(" ");
            sb.append(" close:").append(this.isClose()).append(" ");
            sb.append(" hasLeader:").append(this.hasLeader()).append(" ");
            sb.append(" hasTrailer:").append(this.hasTrailer()).append(" ");
            sb.append(" hasContent:").append(this.hasContents()).append(" ");
            sb.append(" involvesQuoting:").append(this.involvesQuoting()).append(" ");
            sb.append(" inQuote:").append(this.inQuote).append(" ");
            return sb.toString();
        }
    }
}

