/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.WeakEventListenerList;
import org.netbeans.modules.editor.deprecated.pre61settings.EditorPreferencesInjector;
import org.netbeans.modules.editor.deprecated.pre61settings.KitchenSink;
import org.netbeans.modules.editor.deprecated.pre61settings.OrgNbEditorAccessor;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class Settings {
    private static final Logger LOG = Logger.getLogger(Settings.class.getName());
    private static final boolean LOG_STACTRACES = Boolean.getBoolean(Settings.class.getName() + ".stacktraces");
    public static final int CORE_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    public static final int EXTENSION_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    public static final int USER_LEVEL = 4;
    private static final ArrayList initializerLists = new ArrayList();
    private static long initializerListsVersion = 0L;
    private static List[] listsOfInitializers = null;
    private static long listsOfInitializersVersion = -1L;
    private static InitializerSorter currentInitializerSorter;
    private static final Filter[] NULL_FILTERS;
    private static final String FILTERS_LOCK;
    private static volatile Filter[] filters;
    private static final Map kit2Maps;
    private static final WeakEventListenerList listenerList;
    private static volatile int firingEnabled;
    private static final ThreadLocal<EditorPreferencesInjector> setValueInterceptor;
    private static final ThreadLocal<Boolean> resetValuesEvent;
    private static final HashMap emptyMaps;
    private static final RequestProcessor PROCESSOR;
    private static final RequestProcessor.Task RESET_TASK;
    private static final Map<MimePath, ChangesTrackingLookupResult<FontColorSettings>> FCS_CACHE;
    private static final Set<String> HIGHLIGHT_COLOR_NAMES;
    private static final Set<String> HIGHLIGHT_COLORING_NAMES;
    private static final Map<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>> KBS_CACHE;
    private static final Map<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>> CTS_CACHE;
    private static final Map<MimePath, PreferenceChangesTracker> PREFS_CACHE;

    private Settings() {
    }

    public static void addInitializer(Initializer i) {
        Settings.addInitializer(i, 1);
        Settings.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitializer(Initializer i, int level) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            int size;
            for (int j = size = initializerLists.size(); j <= level; ++j) {
                initializerLists.add(new ArrayList());
            }
            ((List)initializerLists.get(level)).add(i);
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
        Settings.firePropertyChange("initializers", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInitializer(String name) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            Iterator itit = initializerLists.iterator();
            while (itit.hasNext()) {
                Iterator it = ((List)itit.next()).iterator();
                while (it.hasNext()) {
                    if (!name.equals(((Initializer)it.next()).getName())) continue;
                    it.remove();
                }
            }
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
        Settings.firePropertyChange("initializers", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InitializerSorter getInitializerSorter() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            return currentInitializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitializerSorter(InitializerSorter initializerSorter) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            currentInitializerSorter = initializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List[] getListsOfInitializers() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            if (listsOfInitializersVersion != initializerListsVersion) {
                List[] lists = initializerLists.toArray(new List[initializerLists.size()]);
                for (int i = 0; i < lists.length; ++i) {
                    lists[i] = Collections.unmodifiableList(new ArrayList(lists[i]));
                }
                listsOfInitializers = lists;
                listsOfInitializersVersion = initializerListsVersion;
            }
            return listsOfInitializers;
        }
    }

    private static void firePropertyChange(String name, Object old, Object nue) {
        PropertyChangeListener[] listeners;
        PropertyChangeEvent evt = new PropertyChangeEvent(Settings.class, name, old, nue);
        for (PropertyChangeListener l : listeners = (PropertyChangeListener[])listenerList.getListeners(PropertyChangeListener.class)) {
            l.propertyChange(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilter(Filter f) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                filters = new Filter[]{f};
            } else {
                Filter[] tmp = new Filter[filters.length + 1];
                System.arraycopy(filters, 0, tmp, 0, filters.length);
                tmp[Settings.filters.length] = f;
                filters = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFilter(Filter f) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                return;
            }
            if (filters.length == 1 && filters[0] == f) {
                filters = NULL_FILTERS;
            } else {
                int idx = -1;
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i] != f) continue;
                    idx = i;
                    break;
                }
                if (idx != -1) {
                    Filter[] tmp = new Filter[filters.length - 1];
                    System.arraycopy(filters, 0, tmp, 0, idx);
                    if (idx < tmp.length) {
                        System.arraycopy(filters, idx + 1, tmp, idx, tmp.length - idx);
                    }
                    filters = tmp;
                }
            }
        }
    }

    public static Object getValue(Class kitClass, String settingName) {
        return Settings.getValue(kitClass, settingName, true);
    }

    public static Object getValue(Class kitClass, String settingName, boolean evaluateEvaluators) {
        String mimeType = KitsTracker.getInstance().findMimeType(kitClass);
        MimePath mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        Object value = Settings.getValueEx(mimePath, kitClass, settingName, evaluateEvaluators);
        Filter[] currentFilters = filters;
        for (int i = 0; i < currentFilters.length; ++i) {
            value = currentFilters[i].filterValue(kitClass, settingName, value);
        }
        return value;
    }

    private static Object getValueEx(MimePath mimePath, Class kitClass, String settingName, boolean evaluateEvaluators) {
        if (settingName != null && "abbrev-map".equals(settingName)) {
            return Settings.findCodeTemplates(mimePath);
        }
        if (settingName != null && "key-bindings".equals(settingName)) {
            return Settings.findKeyBindings(mimePath);
        }
        if (settingName != null && "macro-map".equals(settingName)) {
            return Settings.findMacros(mimePath);
        }
        if (settingName != null && HIGHLIGHT_COLOR_NAMES.contains(settingName)) {
            return Settings.findColor(settingName, mimePath);
        }
        if (settingName != null && HIGHLIGHT_COLORING_NAMES.contains(settingName)) {
            return Settings.findColoring(settingName, mimePath, false, true);
        }
        String coloringName = Settings.translateOldTokenColoringName(settingName);
        if (coloringName != null) {
            return Settings.findColoring(coloringName, mimePath, true, true);
        }
        Object value = null;
        Preferences prefs = Settings.findPreferences(mimePath);
        if (prefs != null && null != prefs.get(settingName, null)) {
            value = KitchenSink.getValueFromPrefs(settingName, prefs, mimePath);
        } else {
            List allKitMaps = Settings.getAllKitMaps(kitClass);
            assert (allKitMaps.size() % 2 == 0) : "allKitMaps should contain pairs of [kitClass, settingsMap].";
            for (int i = 0; i < allKitMaps.size() / 2; ++i) {
                Class kc = (Class)allKitMaps.get(2 * i);
                Map map = (Map)allKitMaps.get(2 * i + 1);
                value = map.get(settingName);
                if (evaluateEvaluators && value instanceof Evaluator) {
                    value = ((Evaluator)value).getValue(kc, settingName);
                }
                if (value != null) break;
            }
        }
        return value;
    }

    public static KitAndValue[] getValueHierarchy(Class kitClass, String settingName) {
        return Settings.getValueHierarchy(kitClass, settingName, true);
    }

    public static KitAndValue[] getValueHierarchy(Class kitClass, String settingName, boolean evaluateEvaluators) {
        ArrayList<KitAndValue> kavList = new ArrayList<KitAndValue>();
        for (Class kc = kitClass; kc != null; kc = kc.getSuperclass()) {
            String mimeType = KitsTracker.getInstance().findMimeType(kitClass);
            MimePath mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
            Object value = Settings.getValueEx(mimePath, kc, settingName, evaluateEvaluators);
            if (value != null) {
                kavList.add(new KitAndValue(kc, value));
            }
            if (mimePath == MimePath.EMPTY) break;
        }
        KitAndValue[] kavArray = kavList.toArray(new KitAndValue[kavList.size()]);
        Filter[] currentFilters = filters;
        for (int i = 0; i < currentFilters.length; ++i) {
            kavArray = currentFilters[i].filterValueHierarchy(kitClass, settingName, kavArray);
        }
        return kavArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setValue(Class kitClass, String settingName, Object newValue) {
        EditorPreferencesInjector injector = setValueInterceptor.get();
        if (injector != null) {
            injector.capturedSetValue(kitClass, settingName, newValue);
            return;
        }
        if (settingName != null && "abbrev-map".equals(settingName)) {
            LOG.log(Level.WARNING, "Can't save 'SettingsNames.ABBREV_MAP' setting through org.netbeans.editor.Settings!", new Throwable("Stacktrace"));
            return;
        }
        if (settingName != null && "key-bindings".equals(settingName)) {
            LOG.log(Level.WARNING, "Can't save 'SettingsNames.KEY_BINDING_LIST' setting through org.netbeans.editor.Settings!", new Throwable("Stacktrace"));
            return;
        }
        if (settingName != null && "macro-map".equals(settingName)) {
            LOG.log(Level.WARNING, "Can't save 'SettingsNames.MACRO_MAP' setting through org.netbeans.editor.Settings!", new Throwable("Stacktrace"));
            return;
        }
        boolean coloring = false;
        if (settingName != null && HIGHLIGHT_COLOR_NAMES.contains(settingName)) {
            coloring = true;
        } else if (settingName != null && HIGHLIGHT_COLORING_NAMES.contains(settingName)) {
            coloring = true;
        } else {
            String coloringName = Settings.translateOldTokenColoringName(settingName);
            if (coloringName != null) {
                coloring = true;
            }
        }
        if (coloring) {
            LOG.log(Level.WARNING, "Can't save coloring '" + settingName + "' through org.netbeans.editor.Settings!", new Throwable("Stacktrace"));
            return;
        }
        boolean useKitMaps = false;
        String mimeType = KitsTracker.getInstance().findMimeType(kitClass);
        MimePath mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        Preferences prefs = Settings.findPreferences(mimePath);
        if (prefs != null) {
            if (KitchenSink.setValueToPreferences(settingName, newValue, prefs, mimePath)) return;
            boolean bl = true;
            useKitMaps = bl;
        } else {
            useKitMaps = true;
        }
        if (!useKitMaps) return;
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(kitClass, true);
            Object oldValue = map.get(settingName);
            if (oldValue == null) {
                if (newValue == null) return;
            }
            if (oldValue != null && oldValue.equals(newValue)) {
                // ** MonitorExit[var9_10] (shouldn't be in output)
                return;
            }
            if (newValue != null) {
                map.put(settingName, newValue);
            } else {
                map.remove(settingName);
            }
            // ** MonitorExit[var9_10] (shouldn't be in output)
            Settings.fireSettingsChange(kitClass, settingName, null, newValue);
            return;
        }
    }

    public static void touchValue(Class kitClass, String settingName) {
        Settings.fireSettingsChange(kitClass, settingName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propagateValue(Class kitClass, String settingName, Object newValue) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(kitClass, true);
            if (newValue != null) {
                map.put(settingName, newValue);
            } else {
                map.remove(settingName);
            }
            for (Map.Entry me : kit2Maps.entrySet()) {
                Class kc = (Class)me.getKey();
                if (kitClass == kc || kitClass != null && !kitClass.isAssignableFrom(kc)) continue;
                ((Map)me.getValue()).remove(settingName);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Settings.fireSettingsChange(null, settingName, null, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void update(Runnable r) {
        if (Settings.isAsyncTask(r)) {
            PROCESSOR.post(r, Settings.getTaskDelay(r));
            return;
        }
        boolean fire = false;
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            boolean bl;
            ++firingEnabled;
            try {
                r.run();
                if (--firingEnabled != 0) return;
                bl = true;
            }
            catch (Throwable throwable) {
                fire = --firingEnabled == 0;
                throw throwable;
            }
            fire = bl;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (!fire) return;
            Settings.fireSettingsChange(null, null, null, null);
            return;
        }
    }

    private static boolean isAsyncTask(Runnable r) {
        try {
            Method m = r.getClass().getDeclaredMethod("asynchronous", new Class[0]);
            m.setAccessible(true);
            return (Boolean)m.invoke((Object)r, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int getTaskDelay(Runnable r) {
        try {
            Method m = r.getClass().getDeclaredMethod("delay", new Class[0]);
            m.setAccessible(true);
            return (Integer)m.invoke((Object)r, new Object[0]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void reset() {
        RESET_TASK.schedule(1);
    }

    public static String initializersToString() {
        StringBuffer sb = new StringBuffer();
        List[] lists = Settings.getListsOfInitializers();
        for (int i = 0; i < lists.length; ++i) {
            switch (i) {
                case 0: {
                    sb.append("CORE_LEVEL");
                    break;
                }
                case 1: {
                    sb.append("SYSTEM_LEVEL");
                    break;
                }
                case 2: {
                    sb.append("EXTENSION_LEVEL");
                    break;
                }
                case 3: {
                    sb.append("OPTION_LEVEL");
                    break;
                }
                case 4: {
                    sb.append("USER_LEVEL");
                    break;
                }
                default: {
                    sb.append("level " + i);
                }
            }
            sb.append(":\n");
            sb.append(EditorDebug.debugList((List)lists[i]));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void addSettingsChangeListener(SettingsChangeListener l) {
        listenerList.add(SettingsChangeListener.class, (EventListener)l);
    }

    public static void removeSettingsChangeListener(SettingsChangeListener l) {
        listenerList.remove(SettingsChangeListener.class, (EventListener)l);
    }

    private static void fireSettingsChange(Class kitClass, String settingName, Object oldValue, Object newValue) {
        if (firingEnabled == 0) {
            SettingsChangeListener[] listeners = (SettingsChangeListener[])listenerList.getListeners(SettingsChangeListener.class);
            SettingsChangeEvent evt = new SettingsChangeEvent(Settings.class, kitClass, settingName, oldValue, newValue);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].settingsChange(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getKitMap(Class kitClass, boolean forceCreation) {
        ++firingEnabled;
        try {
            Map map = Settings.getKitMapWithEvent(kitClass, forceCreation);
            return map;
        }
        finally {
            --firingEnabled;
        }
    }

    private static Map getKitMapWithEvent(Class kitClass, boolean forceCreation) {
        Map kitMap = (Map)kit2Maps.get(kitClass);
        if (kitMap == null && forceCreation) {
            LoggingMap emptyMap = (LoggingMap)emptyMaps.get(kitClass);
            if (emptyMap != null) {
                return emptyMap;
            }
            if (emptyMap == null) {
                emptyMap = LOG.isLoggable(Level.FINE) ? new LoggingMap(kitClass, Level.FINE) : new HashMap();
                emptyMaps.put(kitClass, emptyMap);
            }
            List[] lists = Settings.getListsOfInitializers();
            for (int i = 0; i < lists.length; ++i) {
                for (Initializer initializer : lists[i]) {
                    try {
                        initializer.updateSettingsMap(kitClass, emptyMap);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, null, t);
                    }
                }
            }
            kitMap = emptyMap;
            kit2Maps.put(kitClass, kitMap);
            emptyMaps.remove(kitClass);
        }
        return kitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getAllKitMaps(Class kitClass) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            ArrayList classes = new ArrayList();
            for (Class kc = kitClass; kc != null; kc = kc.getSuperclass()) {
                classes.add(kc);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = classes.size() - 1; i >= 0; --i) {
                Class kc = (Class)classes.get(i);
                Map map = Settings.getKitMap(kc, false);
                if (map == null) continue;
                list.add(map);
                list.add(kc);
            }
            Collections.reverse(list);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return list;
        }
    }

    private static Coloring findColoring(String coloringName, MimePath mimePath, boolean token, boolean highlight) {
        AttributeSet attribs = Settings.findAttribs(coloringName, mimePath, token, highlight);
        return attribs == null ? null : Coloring.fromAttributeSet((AttributeSet)attribs);
    }

    private static Color findColor(String coloringName, MimePath mimePath) {
        AttributeSet attribs = Settings.findAttribs(coloringName, mimePath, false, true);
        return attribs == null ? null : (Color)attribs.getAttribute(StyleConstants.Foreground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttributeSet findAttribs(String coloringName, MimePath mimePath, boolean token, boolean highlight) {
        Map<MimePath, ChangesTrackingLookupResult<FontColorSettings>> map = FCS_CACHE;
        synchronized (map) {
            FontColorSettings fcs;
            ChangesTrackingLookupResult<Object> ctlr = FCS_CACHE.get(mimePath);
            if (ctlr == null) {
                Lookup.Result lookupResult = MimeLookup.getLookup((MimePath)mimePath).lookupResult(FontColorSettings.class);
                ctlr = new ChangesTrackingLookupResult(lookupResult, null);
                FCS_CACHE.put(mimePath, ctlr);
            }
            AttributeSet attribs = null;
            Collection allFcs = ctlr.getLookupResult().allInstances();
            FontColorSettings fontColorSettings = fcs = allFcs.isEmpty() ? null : (FontColorSettings)allFcs.iterator().next();
            if (fcs != null) {
                if (token && !highlight) {
                    attribs = fcs.getTokenFontColors(coloringName);
                } else if (!token && highlight) {
                    attribs = fcs.getFontColors(coloringName);
                } else {
                    attribs = fcs.getFontColors(coloringName);
                    if (attribs == null) {
                        attribs = fcs.getTokenFontColors(coloringName);
                    }
                }
            }
            return attribs;
        }
    }

    private static String translateOldTokenColoringName(String name) {
        String translated = null;
        if (name != null && name.endsWith("-coloring")) {
            translated = name.substring(0, name.length() - "-coloring".length());
        }
        if (name != null && name.endsWith("-print-coloring")) {
            translated = name.substring(0, name.length() - "-print-coloring".length());
        }
        return translated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MultiKeyBinding> findKeyBindings(MimePath mimePath) {
        Map<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>> map = KBS_CACHE;
        synchronized (map) {
            ArrayList<MultiKeyBinding> list;
            ChangesTrackingLookupResult<Object> ctlr = KBS_CACHE.get(mimePath);
            if (ctlr == null) {
                Lookup.Result lookupResult = MimeLookup.getLookup((MimePath)mimePath).lookupResult(KeyBindingSettings.class);
                ctlr = new ChangesTrackingLookupResult(lookupResult, "key-bindings");
                KBS_CACHE.put(mimePath, ctlr);
            }
            if ((list = (ArrayList<MultiKeyBinding>)ctlr.getCustomData()) == null) {
                Collection allKbs = ctlr.getLookupResult().allInstances();
                KeyBindingSettings kbs = allKbs.isEmpty() ? null : (KeyBindingSettings)allKbs.iterator().next();
                list = new ArrayList<MultiKeyBinding>();
                if (kbs != null) {
                    for (org.netbeans.api.editor.settings.MultiKeyBinding mkb : kbs.getKeyBindings()) {
                        List keyStrokes = mkb.getKeyStrokeList();
                        list.add(new MultiKeyBinding(keyStrokes.toArray(new KeyStroke[keyStrokes.size()]), mkb.getActionName()));
                    }
                    ctlr.setCustomData(list);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> findCodeTemplates(MimePath mimePath) {
        Map<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>> map = CTS_CACHE;
        synchronized (map) {
            HashMap<String, String> map2;
            ChangesTrackingLookupResult<Object> ctlr = CTS_CACHE.get(mimePath);
            if (ctlr == null) {
                Lookup.Result lookupResult = MimeLookup.getLookup((MimePath)mimePath).lookupResult(CodeTemplateSettings.class);
                ctlr = new ChangesTrackingLookupResult(lookupResult, "abbrev-map");
                CTS_CACHE.put(mimePath, ctlr);
            }
            if ((map2 = (HashMap<String, String>)ctlr.getCustomData()) == null) {
                Collection allCts = ctlr.getLookupResult().allInstances();
                CodeTemplateSettings cts = allCts.isEmpty() ? null : (CodeTemplateSettings)allCts.iterator().next();
                map2 = new HashMap<String, String>();
                if (cts != null) {
                    for (CodeTemplateDescription ctd : cts.getCodeTemplateDescriptions()) {
                        map2.put(ctd.getAbbreviation(), ctd.getParametrizedText());
                    }
                    ctlr.setCustomData(map2);
                }
            }
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Preferences findPreferences(MimePath mimePath) {
        Map<MimePath, PreferenceChangesTracker> map = PREFS_CACHE;
        synchronized (map) {
            Preferences prefs;
            PreferenceChangesTracker tracker = PREFS_CACHE.get(mimePath);
            if (tracker == null && (prefs = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class)) != null) {
                tracker = new PreferenceChangesTracker(prefs);
                PREFS_CACHE.put(mimePath, tracker);
            }
            return tracker == null ? null : tracker.getPreferences();
        }
    }

    private static Map<String, String> findMacros(MimePath mimePath) {
        HashMap<String, String> macros = new HashMap<String, String>();
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> essClass = classLoader.loadClass("org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage");
            Method findMethod = essClass.getDeclaredMethod("find", String.class);
            Object macrosEss = findMethod.invoke(null, "Macros");
            if (macrosEss != null) {
                Class<?> mdClass = classLoader.loadClass("org.netbeans.modules.editor.macros.storage.MacroDescription");
                Method getCodeMethod = mdClass.getDeclaredMethod("getCode", new Class[0]);
                Method loadMethod = essClass.getDeclaredMethod("load", MimePath.class, String.class, Boolean.TYPE);
                Map macroDescriptions = (Map)loadMethod.invoke(macrosEss, mimePath, null, false);
                for (Object key : macroDescriptions.keySet()) {
                    String macroName = (String)key;
                    Object macroDescription = macroDescriptions.get(key);
                    String macroCode = (String)getCodeMethod.invoke(macroDescription, new Object[0]);
                    macros.put(macroName, macroCode);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        macros.put((String)null, (String)((Object)Settings.findKeyBindings(mimePath)));
        return macros;
    }

    static {
        NULL_FILTERS = new Filter[0];
        FILTERS_LOCK = new String("Settings.FILTERS_LOCK");
        filters = NULL_FILTERS;
        kit2Maps = new HashMap();
        listenerList = new WeakEventListenerList();
        firingEnabled = 0;
        setValueInterceptor = new ThreadLocal();
        resetValuesEvent = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        emptyMaps = new HashMap();
        PROCESSOR = new RequestProcessor("org.netbeans.editor.Settings.PROCESSOR");
        RESET_TASK = PROCESSOR.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<Settings> clazz = Settings.class;
                synchronized (Settings.class) {
                    kit2Maps.clear();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    resetValuesEvent.set(true);
                    try {
                        Settings.fireSettingsChange(null, null, null, null);
                    }
                    finally {
                        resetValuesEvent.remove();
                    }
                    return;
                }
            }
        });
        OrgNbEditorAccessor.register(new PackageAccessor());
        FCS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<FontColorSettings>>();
        HIGHLIGHT_COLOR_NAMES = new HashSet<String>();
        HIGHLIGHT_COLORING_NAMES = new HashSet<String>();
        HIGHLIGHT_COLOR_NAMES.add("caret-color-insert-mode");
        HIGHLIGHT_COLOR_NAMES.add("caret-color-overwrite-mode");
        HIGHLIGHT_COLOR_NAMES.add("text-limit-line-color");
        HIGHLIGHT_COLORING_NAMES.add("line-number");
        HIGHLIGHT_COLORING_NAMES.add("guarded");
        HIGHLIGHT_COLORING_NAMES.add("code-folding");
        HIGHLIGHT_COLORING_NAMES.add("code-folding-bar");
        HIGHLIGHT_COLORING_NAMES.add("selection");
        HIGHLIGHT_COLORING_NAMES.add("highlight-search");
        HIGHLIGHT_COLORING_NAMES.add("inc-search");
        HIGHLIGHT_COLORING_NAMES.add("block-search");
        HIGHLIGHT_COLORING_NAMES.add("status-bar");
        HIGHLIGHT_COLORING_NAMES.add("status-bar-bold");
        KBS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<KeyBindingSettings>>();
        CTS_CACHE = new WeakHashMap<MimePath, ChangesTrackingLookupResult<CodeTemplateSettings>>();
        PREFS_CACHE = new WeakHashMap<MimePath, PreferenceChangesTracker>();
    }

    private static final class PackageAccessor
    extends OrgNbEditorAccessor {
        private PackageAccessor() {
        }

        @Override
        public List[] Settings_getListsOfInitializers() {
            return Settings.getListsOfInitializers();
        }

        @Override
        public void Settings_interceptSetValue(EditorPreferencesInjector interceptor) {
            if (interceptor != null) {
                assert (setValueInterceptor.get() == null) : "Can't set more than one setValue interceptor";
                setValueInterceptor.set(interceptor);
            } else {
                setValueInterceptor.remove();
            }
        }

        @Override
        public void Settings_addPropertyChangeListener(PropertyChangeListener l) {
            listenerList.add(PropertyChangeListener.class, (EventListener)l);
        }

        @Override
        public void Settings_removePropertyChangeListener(PropertyChangeListener l) {
            listenerList.remove(PropertyChangeListener.class, (EventListener)l);
        }

        @Override
        public void Settings_addSettingsChangeListener(SettingsChangeListener l) {
            listenerList.add(SettingsChangeListener.class, (EventListener)l);
        }

        @Override
        public void Settings_removeSettingsChangeListener(SettingsChangeListener l) {
            listenerList.remove(SettingsChangeListener.class, (EventListener)l);
        }

        @Override
        public boolean isResetValuesEvent() {
            return (Boolean)resetValuesEvent.get();
        }
    }

    private static final class PreferenceChangesTracker
    implements PreferenceChangeListener {
        private final Preferences prefs;

        public PreferenceChangesTracker(Preferences prefs) {
            this.prefs = prefs;
            this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs));
        }

        public Preferences getPreferences() {
            return this.prefs;
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            Settings.fireSettingsChange(null, evt.getKey(), null, null);
        }
    }

    private static final class ChangesTrackingLookupResult<T>
    implements LookupListener {
        private final Lookup.Result<T> lookupResult;
        private final String settingName;
        private Object customData = null;

        public ChangesTrackingLookupResult(Lookup.Result<T> lookupResult, String settingName) {
            this.lookupResult = lookupResult;
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult));
            this.settingName = settingName;
        }

        public Lookup.Result<T> getLookupResult() {
            return this.lookupResult;
        }

        public Object getCustomData() {
            return this.customData;
        }

        public void setCustomData(Object data) {
            this.customData = data;
        }

        public void resultChanged(LookupEvent ev) {
            this.customData = null;
            Settings.fireSettingsChange(null, this.settingName, null, null);
        }
    }

    private static final class LoggingMap
    extends HashMap {
        private Class kitClass;
        private Level logLevel;
        private static final Set<String> DEPRECATED_SETTINGS = Collections.synchronizedSet(Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("block-search", "caret-color-insert-mode", "caret-color-overwrite-mode", "code-folding", "coloring-name-list", "-print-coloring", "-coloring", "default", "guarded", "highlight-search", "inc-search", "line-number", "selection", "status-bar-bold", "status-bar", "text-limit-line-color", "key-bindings"))));

        public LoggingMap(Class kitClass, Level logLevel) {
            this.kitClass = kitClass;
            this.logLevel = logLevel;
        }

        @Override
        public Object put(Object key, Object value) {
            if (key != null && (key.equals("rendering-hints") || key.equals("textAntialiasing"))) {
                String msg = "Settings map: put('" + key + "' to '" + value + "') for kitClass=" + this.kitClass;
                if (LOG_STACTRACES) {
                    LOG.log(this.logLevel, null, new Throwable(msg));
                } else {
                    LOG.log(this.logLevel, msg);
                }
            }
            this.logDeprecatedKey(key);
            return super.put(key, value);
        }

        @Override
        public Object get(Object key) {
            this.logDeprecatedKey(key);
            return super.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            this.logDeprecatedKey(key);
            return super.containsKey(key);
        }

        @Override
        public Object remove(Object key) {
            this.logDeprecatedKey(key);
            return super.remove(key);
        }

        private void logDeprecatedKey(Object key) {
            if (LOG.isLoggable(this.logLevel) && key != null && DEPRECATED_SETTINGS.contains(key)) {
                String msg = "The editor setting '" + key + "' is deprecated. Please use Editor Settings API instead.";
                if (LOG_STACTRACES) {
                    LOG.log(this.logLevel, null, new Throwable(msg));
                } else {
                    LOG.log(this.logLevel, msg);
                }
            }
        }
    }

    public static interface Filter {
        public Object filterValue(Class var1, String var2, Object var3);

        public KitAndValue[] filterValueHierarchy(Class var1, String var2, KitAndValue[] var3);
    }

    public static interface Evaluator {
        public Object getValue(Class var1, String var2);
    }

    public static abstract class FilterInitializerSorter {
        private InitializerSorter delegate;

        public FilterInitializerSorter(InitializerSorter delegate) {
            this.delegate = delegate;
        }

        public void sort(List initializersList) {
            if (this.delegate != null) {
                this.delegate.sort(initializersList);
            }
        }
    }

    public static interface InitializerSorter {
        public void sort(List var1);
    }

    public static abstract class AbstractInitializer
    implements Initializer {
        private String name;

        public AbstractInitializer(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface Initializer {
        public String getName();

        public void updateSettingsMap(Class var1, Map var2);
    }

    public static class KitAndValue {
        public Class kitClass;
        public Object value;

        public KitAndValue(Class kitClass, Object value) {
            this.kitClass = kitClass;
            this.value = value;
        }
    }
}

