/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.deprecated.pre61settings.KitchenSink;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class OptionSupport
extends SystemOption {
    private static final Logger LOG = Logger.getLogger(OptionSupport.class.getName());
    static final long serialVersionUID = 2002899758839584077L;
    static final String OPTIONS_PREFIX = "OPTIONS_";
    private final Class kitClass;
    private final String typeName;
    private MimePath mimePath = null;
    private Preferences prefs = null;
    private static final HashMap kitClass2Type = new HashMap();

    public OptionSupport(Class kitClass, String typeName) {
        this.kitClass = kitClass;
        this.typeName = typeName;
        kitClass2Type.put(kitClass, typeName);
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static String getTypeName(Class kitClass) {
        return (String)kitClass2Type.get(kitClass);
    }

    public String displayName() {
        return this.getString(OPTIONS_PREFIX + this.typeName);
    }

    public Object getSettingValue(String settingName) {
        return KitchenSink.getValueFromPrefs(settingName, this.getPreferences(), this.mimePath);
    }

    protected final boolean getSettingBoolean(String settingName) {
        return this.getPreferences().getBoolean(settingName, false);
    }

    protected final int getSettingInteger(String settingName) {
        return this.getPreferences().getInt(settingName, 0);
    }

    public void setSettingValue(String settingName, Object newValue) {
        this.setSettingValue(settingName, newValue, settingName);
    }

    public void setSettingValue(String settingName, Object newValue, String propertyName) {
        this.doSetSettingValue(settingName, newValue, propertyName);
    }

    public void doSetSettingValue(String settingName, Object newValue, String propertyName) {
        KitchenSink.setValueToPreferences(settingName, newValue, this.getPreferences(), this.mimePath);
    }

    protected void setSettingBoolean(String settingName, boolean newValue, String propertyName) {
        this.getPreferences().putBoolean(settingName, newValue);
    }

    protected void setSettingInteger(String settingName, int newValue, String propertyName) {
        this.getPreferences().putInt(settingName, newValue);
    }

    protected String getString(String s) {
        return NbBundle.getMessage(OptionSupport.class, (String)s);
    }

    public static String[] mergeStringArrays(String[] a1, String[] a2) {
        return NbEditorUtilities.mergeStringArrays((String[])a1, (String[])a2);
    }

    protected String getSettingsInitializerName() {
        return this.getTypeName() + "-options-initalizer";
    }

    protected void updateSettingsMap(Class kitClass, Map settingsMap) {
    }

    Preferences getPreferences() {
        if (this.prefs == null) {
            this.mimePath = this.kitClass.equals(BaseKit.class) ? MimePath.EMPTY : MimePath.parse((String)this.getCTImpl());
            this.prefs = (Preferences)MimeLookup.getLookup((MimePath)this.mimePath).lookup(Preferences.class);
        }
        return this.prefs;
    }

    protected String getContentType() {
        BaseKit kit = BaseKit.getKit((Class)this.getKitClass());
        return kit.getContentType();
    }

    String getCTImpl() {
        String mimeType = this.getContentType();
        if (mimeType == null) {
            String msg = "Can't determine mime type for " + OptionSupport.simpleToString((Object)this) + "; kitClass = " + this.getKitClass();
            LOG.log(Level.WARNING, null, new Throwable(msg));
            mimeType = "text/plain";
        }
        return mimeType;
    }

    private static String simpleToString(Object o) {
        if (o == null) {
            return null;
        }
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }
}

