/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ClassLoadUnloadBreakpoint
extends JPDABreakpoint {
    public static final String PROP_CLASS_FILTERS = "classFilters";
    public static final String PROP_CLASS_EXCLUSION_FILTERS = "classExclusionFilters";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final int TYPE_CLASS_LOADED = 1;
    public static final int TYPE_CLASS_UNLOADED = 2;
    public static final int TYPE_CLASS_LOADED_UNLOADED = 3;
    private int type = 1;
    private String[] classFilters = new String[0];
    private String[] classExclusionFilters = new String[0];

    private ClassLoadUnloadBreakpoint() {
    }

    public static ClassLoadUnloadBreakpoint create(String string, boolean bl, int n) {
        ClassLoadUnloadBreakpointImpl classLoadUnloadBreakpointImpl = new ClassLoadUnloadBreakpointImpl();
        if (bl) {
            classLoadUnloadBreakpointImpl.setClassExclusionFilters(new String[]{string});
        } else {
            classLoadUnloadBreakpointImpl.setClassFilters(new String[]{string});
        }
        classLoadUnloadBreakpointImpl.setBreakpointType(n);
        return classLoadUnloadBreakpointImpl;
    }

    public static ClassLoadUnloadBreakpoint create(int n) {
        ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = new ClassLoadUnloadBreakpoint();
        classLoadUnloadBreakpoint.setBreakpointType(n);
        return classLoadUnloadBreakpoint;
    }

    public int getBreakpointType() {
        return this.type;
    }

    public void setBreakpointType(int n) {
        if (n == this.type) {
            return;
        }
        if ((n & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.type;
        this.type = n;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, n2, n);
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] stringArray) {
        if (stringArray == this.classFilters) {
            return;
        }
        String[] stringArray2 = this.classFilters;
        this.classFilters = stringArray;
        this.firePropertyChange(PROP_CLASS_FILTERS, stringArray2, stringArray);
    }

    public String[] getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public void setClassExclusionFilters(String[] stringArray) {
        if (stringArray == this.classExclusionFilters) {
            return;
        }
        String[] stringArray2 = this.classExclusionFilters;
        this.classExclusionFilters = stringArray;
        this.firePropertyChange(PROP_CLASS_EXCLUSION_FILTERS, stringArray2, stringArray);
    }

    public String toString() {
        return "ClassLoadUnloadBreakpoint " + Arrays.toString(this.classFilters);
    }

    private static final class ClassLoadUnloadBreakpointImpl
    extends ClassLoadUnloadBreakpoint
    implements PropertyChangeListener {
        private ClassLoadUnloadBreakpointImpl() {
        }

        public Breakpoint.GroupProperties getGroupProperties() {
            return new ClassGroupProperties();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.enginePropertyChange(propertyChangeEvent);
        }

        private final class ClassGroupProperties
        extends Breakpoint.GroupProperties {
            private ClassGroupProperties() {
            }

            public String getType() {
                return NbBundle.getMessage(ClassLoadUnloadBreakpoint.class, (String)"ClassBrkp_Type");
            }

            public String getLanguage() {
                return "Java";
            }

            public FileObject[] getFiles() {
                String[] stringArray = ClassLoadUnloadBreakpointImpl.this.getClassFilters();
                String[] stringArray2 = ClassLoadUnloadBreakpointImpl.this.getClassExclusionFilters();
                ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith("*") || stringArray[i].endsWith("*")) continue;
                    JPDABreakpoint.fillFilesForClass(stringArray[i], arrayList);
                }
                return arrayList.toArray(new FileObject[0]);
            }

            public Project[] getProjects() {
                FileObject[] fileObjectArray = this.getFiles();
                ArrayList<Project> arrayList = new ArrayList<Project>();
                for (FileObject fileObject : fileObjectArray) {
                    while (!(fileObject == null || (fileObject = fileObject.getParent()) != null && ProjectManager.getDefault().isProject(fileObject))) {
                    }
                    if (fileObject == null) continue;
                    try {
                        arrayList.add(ProjectManager.getDefault().findProject(fileObject));
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return arrayList.toArray(new Project[0]);
            }

            public DebuggerEngine[] getEngines() {
                return ClassLoadUnloadBreakpointImpl.this.getEngines();
            }

            public boolean isHidden() {
                return ClassLoadUnloadBreakpointImpl.this.isHidden();
            }
        }
    }
}

