/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ThreadBreakpoint
extends JPDABreakpoint {
    public static final String PROP_BREAKPOINT_TYPE = "breakpointtType";
    public static final int TYPE_THREAD_STARTED = 1;
    public static final int TYPE_THREAD_DEATH = 2;
    public static final int TYPE_THREAD_STARTED_OR_DEATH = 3;
    private int breakpointType = 1;

    private ThreadBreakpoint() {
    }

    public static ThreadBreakpoint create() {
        return new ThreadBreakpointImpl();
    }

    public int getBreakpointType() {
        return this.breakpointType;
    }

    public void setBreakpointType(int n) {
        if (n == this.breakpointType) {
            return;
        }
        if ((n & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.breakpointType;
        this.breakpointType = n;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, n2, n);
    }

    public String toString() {
        return "ThreadBreakpoint " + this.breakpointType;
    }

    private static final class ThreadBreakpointImpl
    extends ThreadBreakpoint
    implements PropertyChangeListener {
        private ThreadBreakpointImpl() {
        }

        public Breakpoint.GroupProperties getGroupProperties() {
            return new ThreadGroupProperties();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.enginePropertyChange(propertyChangeEvent);
        }

        private final class ThreadGroupProperties
        extends Breakpoint.GroupProperties {
            private ThreadGroupProperties() {
            }

            public String getType() {
                return NbBundle.getMessage(ThreadBreakpoint.class, (String)"ThreadBrkp_Type");
            }

            public String getLanguage() {
                return "Java";
            }

            public FileObject[] getFiles() {
                return null;
            }

            public Project[] getProjects() {
                return null;
            }

            public DebuggerEngine[] getEngines() {
                return ThreadBreakpointImpl.this.getEngines();
            }

            public boolean isHidden() {
                return ThreadBreakpointImpl.this.isHidden();
            }
        }
    }
}

