/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;

public class OrderingControllerByTypeID
implements InspectorOrderingController {
    private Integer order;
    private List<TypeID> types;
    private Comparator<InspectorFolder> comparatorByName = new Comparator<InspectorFolder>(){

        @Override
        public int compare(InspectorFolder fd1, InspectorFolder fd2) {
            return fd1.getDisplayName().compareTo(fd2.getDisplayName());
        }
    };
    private Comparator<TypeID> comparatorByType = new Comparator<TypeID>(){

        @Override
        public int compare(TypeID t1, TypeID t2) {
            return t1.toString().compareTo(t2.toString());
        }
    };

    public OrderingControllerByTypeID(Integer order, TypeID ... types) {
        if (types == null) {
            throw new IllegalArgumentException("types argument cant be null");
        }
        this.order = order;
        this.types = Arrays.asList(types);
    }

    @Override
    public List<InspectorFolder> getOrdered(DesignComponent component, Collection<InspectorFolder> folders) {
        TreeMap<TypeID, ArrayList<InspectorFolder>> foldersMap = new TreeMap<TypeID, ArrayList<InspectorFolder>>(this.comparatorByType);
        ArrayList<InspectorFolder> sortedList = new ArrayList<InspectorFolder>();
        for (InspectorFolder f : folders) {
            if (foldersMap.get(f.getTypeID()) == null) {
                foldersMap.put(f.getTypeID(), new ArrayList<InspectorFolder>(Arrays.asList(f)));
                continue;
            }
            ((List)foldersMap.get(f.getTypeID())).add(f);
        }
        for (List list : foldersMap.values()) {
            Collections.sort(list, this.comparatorByName);
            sortedList.addAll(list);
        }
        return sortedList;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public boolean isTypeIDSupported(DesignDocument document, TypeID typeID) {
        for (TypeID supportedTypeID : this.types) {
            if (!document.getDescriptorRegistry().isInHierarchy(supportedTypeID, typeID)) continue;
            return true;
        }
        return false;
    }
}

