/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.loader;

import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.errors.LifecycleErrorReporterAspect;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.loader.PluginLoader;
import org.apache.maven.plugin.loader.PluginLoaderException;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DefaultPluginLoader
implements PluginLoader,
LogEnabled {
    private Logger logger;
    private PluginManager pluginManager;

    /*
     * WARNING - void declaration
     */
    public PluginDescriptor loadPlugin(MojoBinding mojoBinding, MavenProject mavenProject, MavenSession mavenSession) throws PluginLoaderException {
        MojoBinding mojoBinding2 = mojoBinding;
        MavenProject mavenProject2 = mavenProject;
        MavenSession mavenSession2 = mavenSession;
        try {
            void session;
            void project;
            void mojoBinding3;
            PluginDescriptor pluginDescriptor = null;
            Plugin plugin = new Plugin();
            plugin.setGroupId(mojoBinding3.getGroupId());
            plugin.setArtifactId(mojoBinding3.getArtifactId());
            plugin.setVersion(mojoBinding3.getVersion());
            pluginDescriptor = this.loadPlugin(plugin, (MavenProject)project, (MavenSession)session);
            if (pluginDescriptor != null) {
                mojoBinding3.setGroupId(pluginDescriptor.getGroupId());
                mojoBinding3.setArtifactId(pluginDescriptor.getArtifactId());
                mojoBinding3.setVersion(pluginDescriptor.getVersion());
            }
            return pluginDescriptor;
        }
        catch (PluginLoaderException pluginLoaderException) {
            if (LifecycleErrorReporterAspect.ajc$cflowCounter$0.isValid() || LifecycleErrorReporterAspect.ajc$cflowCounter$1.isValid()) {
                LifecycleErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_errors_LifecycleErrorReporterAspect$1$1071cf4d(mojoBinding2, mavenProject2, pluginLoaderException);
            }
            throw pluginLoaderException;
        }
    }

    public PluginDescriptor loadPlugin(Plugin plugin, MavenProject project, MavenSession session) throws PluginLoaderException {
        if (plugin.getGroupId() == null) {
            plugin.setGroupId(PluginDescriptor.getDefaultPluginGroupId());
        }
        try {
            PluginDescriptor result = this.pluginManager.verifyPlugin(plugin, project, session);
            project.addPlugin(plugin);
            return result;
        }
        catch (ArtifactResolutionException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), e);
        }
        catch (PluginNotFoundException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), e);
        }
        catch (PluginVersionResolutionException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), e);
        }
        catch (InvalidPluginException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), e);
        }
        catch (PluginManagerException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), e);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public PluginDescriptor loadReportPlugin(MojoBinding mojoBinding, MavenProject project, MavenSession session) throws PluginLoaderException {
        ReportPlugin plugin = new ReportPlugin();
        plugin.setGroupId(mojoBinding.getGroupId());
        plugin.setArtifactId(mojoBinding.getArtifactId());
        plugin.setVersion(mojoBinding.getVersion());
        PluginDescriptor pluginDescriptor = this.loadReportPlugin(plugin, project, session);
        mojoBinding.setVersion(pluginDescriptor.getVersion());
        return pluginDescriptor;
    }

    public PluginDescriptor loadReportPlugin(ReportPlugin plugin, MavenProject project, MavenSession session) throws PluginLoaderException {
        try {
            return this.pluginManager.verifyReportPlugin(plugin, project, session);
        }
        catch (ArtifactResolutionException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (PluginNotFoundException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionResolutionException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidPluginException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (PluginManagerException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), (Throwable)e);
        }
        catch (PluginVersionNotFoundException e) {
            throw new PluginLoaderException(plugin, "Failed to load plugin. Reason: " + e.getMessage(), (Throwable)e);
        }
    }
}

