/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.easymock.ArgumentsMatcher;
import org.easymock.MockControl;
import org.easymock.internal.IBehavior;
import org.easymock.internal.IMockControlState;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;

public class RecordState
implements IMockControlState {
    private MethodCall lastMethodCall;
    private boolean lastMethodCallUsed = true;
    private IBehavior behavior;
    private static Map emptyReturnValues = new HashMap();

    public RecordState(IBehavior behavior) {
        this.behavior = behavior;
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        this.closeVoidMethod();
        this.lastMethodCall = new MethodCall(method, args);
        this.lastMethodCallUsed = false;
        return RecordState.emptyReturnValueFor(method.getReturnType());
    }

    public void replay() {
        this.closeVoidMethod();
    }

    public void verify() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("calling verify is not allowed in record state"));
    }

    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        this.behavior.setDefaultMatcher(matcher);
    }

    public void setMatcher(ArgumentsMatcher matcher) {
        this.requireMethodCall("matcher");
        this.behavior.setMatcher(this.lastMethodCall.getMethod(), matcher);
    }

    public void setVoidCallable(Range count) {
        this.requireMethodCall("void callable");
        this.requireVoidMethod();
        this.behavior.addExpected(this.lastMethodCall, Result.createReturnResult(null), count);
        this.lastMethodCallUsed = true;
    }

    public void setThrowable(Throwable throwable, Range count) {
        this.requireMethodCall("Throwable");
        this.requireValidThrowable(throwable);
        this.behavior.addExpected(this.lastMethodCall, Result.createThrowResult(throwable), count);
        this.lastMethodCallUsed = true;
    }

    public void setReturnValue(long value, Range count) {
        this.requireMethodCall("return value");
        Class<?> returnType = this.lastMethodCall.getMethod().getReturnType();
        Object primitiveReturnValue = this.createNumberObject(value, returnType);
        this.behavior.addExpected(this.lastMethodCall, Result.createReturnResult(primitiveReturnValue), count);
        this.lastMethodCallUsed = true;
    }

    public void setReturnValue(boolean value, Range count) {
        this.requireMethodCall("return value");
        this.requireReturnType(Boolean.TYPE);
        this.behavior.addExpected(this.lastMethodCall, Result.createReturnResult(value ? Boolean.TRUE : Boolean.FALSE), count);
        this.lastMethodCallUsed = true;
    }

    private void requireReturnType(Class clazz) {
        if (!this.lastMethodCall.getMethod().getReturnType().equals(clazz)) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("incompatible return value type"));
        }
    }

    public void setReturnValue(float value, Range count) {
        this.requireMethodCall("return value");
        this.requireReturnType(Float.TYPE);
        this.behavior.addExpected(this.lastMethodCall, Result.createReturnResult(new Float(value)), count);
        this.lastMethodCallUsed = true;
    }

    public void setReturnValue(double value, Range count) {
        this.requireMethodCall("return value");
        this.requireReturnType(Double.TYPE);
        this.behavior.addExpected(this.lastMethodCall, Result.createReturnResult(new Double(value)), count);
        this.lastMethodCallUsed = true;
    }

    public void setReturnValue(Object value, Range count) {
        this.requireMethodCall("return value");
        this.requireAssignable(value);
        this.behavior.addExpected(this.lastMethodCall, Result.createReturnResult(value), count);
        this.lastMethodCallUsed = true;
    }

    public void setDefaultThrowable(Throwable throwable) {
        this.requireMethodCall("default Throwable");
        this.requireValidThrowable(throwable);
        this.behavior.setDefaultResult(this.lastMethodCall.getMethod(), Result.createThrowResult(throwable));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultVoidCallable() {
        this.requireMethodCall("default void callable");
        this.requireVoidMethod();
        this.behavior.setDefaultResult(this.lastMethodCall.getMethod(), Result.createReturnResult(null));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(long value) {
        this.requireMethodCall("default return value");
        Class<?> returnType = this.lastMethodCall.getMethod().getReturnType();
        Object primitiveReturnValue = this.createNumberObject(value, returnType);
        this.behavior.setDefaultResult(this.lastMethodCall.getMethod(), Result.createReturnResult(primitiveReturnValue));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(boolean value) {
        this.requireMethodCall("default return value");
        this.requireReturnType(Boolean.TYPE);
        this.behavior.setDefaultResult(this.lastMethodCall.getMethod(), Result.createReturnResult(value ? Boolean.TRUE : Boolean.FALSE));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(float value) {
        this.requireMethodCall("default return value");
        this.requireReturnType(Float.TYPE);
        this.behavior.setDefaultResult(this.lastMethodCall.getMethod(), Result.createReturnResult(new Float(value)));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(double value) {
        this.requireMethodCall("default return value");
        this.requireReturnType(Double.TYPE);
        this.behavior.setDefaultResult(this.lastMethodCall.getMethod(), Result.createReturnResult(new Double(value)));
        this.lastMethodCallUsed = true;
    }

    public void setDefaultReturnValue(Object value) {
        this.requireMethodCall("default return value");
        this.requireAssignable(value);
        this.behavior.setDefaultResult(this.lastMethodCall.getMethod(), Result.createReturnResult(value));
        this.lastMethodCallUsed = true;
    }

    private Object createNumberObject(long value, Class returnType) {
        if (returnType.equals(Byte.TYPE)) {
            return new Byte((byte)value);
        }
        if (returnType.equals(Short.TYPE)) {
            return new Short((short)value);
        }
        if (returnType.equals(Character.TYPE)) {
            return new Character((char)value);
        }
        if (returnType.equals(Integer.TYPE)) {
            return new Integer((int)value);
        }
        if (returnType.equals(Long.TYPE)) {
            return new Long(value);
        }
        throw new RuntimeExceptionWrapper(new IllegalStateException("incompatible return value type"));
    }

    private void closeVoidMethod() {
        if (this.lastMethodCallUsed) {
            return;
        }
        try {
            this.requireVoidMethod();
        }
        catch (RuntimeExceptionWrapper e) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("missing behavior definition for the preceeding method call " + this.lastMethodCall.toString(MockControl.EQUALS_MATCHER)));
        }
        this.behavior.addExpected(this.lastMethodCall, Result.createReturnResult(null), MockControl.ONE);
        this.lastMethodCallUsed = true;
    }

    public static Object emptyReturnValueFor(Class type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (!emptyReturnValues.containsKey(type)) {
            throw new RuntimeException("EasyMock bug: no return value generated!");
        }
        return emptyReturnValues.get(type);
    }

    private void requireMethodCall(String failMessage) {
        if (this.lastMethodCall == null) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("method call on the mock needed before setting " + failMessage));
        }
    }

    private void requireAssignable(Object returnValue) {
        if (this.lastMethodIsVoidMethod()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("void method cannot return a value"));
        }
        if (returnValue == null) {
            return;
        }
        Class<?> returnedType = this.lastMethodCall.getMethod().getReturnType();
        if (!returnedType.isAssignableFrom(returnValue.getClass())) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("incompatible return value type"));
        }
    }

    private void requireValidThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new RuntimeExceptionWrapper(new NullPointerException("null cannot be thrown"));
        }
        if (this.isValidThrowable(throwable)) {
            return;
        }
        throw new RuntimeExceptionWrapper(new IllegalArgumentException("last method called on mock cannot throw " + throwable.getClass().getName()));
    }

    private void requireVoidMethod() {
        if (!this.lastMethodIsVoidMethod()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock is not a void method"));
        }
    }

    private boolean lastMethodIsVoidMethod() {
        Class<?> returnType = this.lastMethodCall.getMethod().getReturnType();
        boolean isVoid = returnType.equals(Void.TYPE);
        return isVoid;
    }

    private boolean isValidThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return true;
        }
        if (throwable instanceof Error) {
            return true;
        }
        Class<?>[] exceptions = this.lastMethodCall.getMethod().getExceptionTypes();
        Class<?> throwableClass = throwable.getClass();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!exceptions[i].isAssignableFrom(throwableClass)) continue;
            return true;
        }
        return false;
    }

    static {
        emptyReturnValues.put(Void.TYPE, null);
        emptyReturnValues.put(Boolean.TYPE, Boolean.FALSE);
        emptyReturnValues.put(Byte.TYPE, new Byte(0));
        emptyReturnValues.put(Short.TYPE, new Short(0));
        emptyReturnValues.put(Character.TYPE, new Character('\u0000'));
        emptyReturnValues.put(Integer.TYPE, new Integer(0));
        emptyReturnValues.put(Long.TYPE, new Long(0L));
        emptyReturnValues.put(Float.TYPE, new Float(0.0f));
        emptyReturnValues.put(Double.TYPE, new Double(0.0));
    }
}

