/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.core.startup.layers.BinaryFS;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.ParsingLayerCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

final class BinaryCacheManager
extends ParsingLayerCacheManager {
    private final String cacheLocation;
    private static final String[] ATTR_TYPES = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "urlvalue", "methodvalue", "newvalue", "serialvalue", "bundlevalue"};
    private HashMap<ParsingLayerCacheManager.MemFileOrFolder, Integer> sizes;

    BinaryCacheManager() {
        this("all-layers.dat");
    }

    BinaryCacheManager(String cacheLocation) {
        this.cacheLocation = cacheLocation;
    }

    @Override
    public FileSystem createEmptyFileSystem() throws IOException {
        return FileUtil.createMemoryFileSystem();
    }

    @Override
    public FileSystem load(FileSystem previous, ByteBuffer bb) throws IOException {
        try {
            BinaryFS fs = new BinaryFS(this.cacheLocation(), bb);
            return fs;
        }
        catch (BufferUnderflowException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
    }

    @Override
    public String cacheLocation() {
        return this.cacheLocation;
    }

    @Override
    protected boolean openURLs() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(FileSystem fs, ParsingLayerCacheManager.MemFolder root, OutputStream os) throws IOException {
        try {
            this.sizes = new HashMap(1000);
            int fsSize = this.computeSize(root);
            LayerCacheManager.err.fine("Writing binary layer cache of length " + (fsSize + BinaryFS.MAGIC.length) + " to " + this.cacheLocation());
            os.write(BinaryFS.MAGIC);
            BinaryWriter bw = new BinaryWriter(os, root, fsSize);
            this.writeFolder(bw, root, true);
        }
        finally {
            this.sizes = null;
            os.close();
        }
    }

    void writeFolder(BinaryWriter bw, ParsingLayerCacheManager.MemFolder folder) throws IOException {
        this.writeFolder(bw, folder, false);
    }

    void writeFolder(BinaryWriter bw, ParsingLayerCacheManager.MemFolder folder, boolean emptyURLsAllowed) throws IOException {
        this.writeBaseURLs(folder, bw, emptyURLsAllowed);
        if (folder.attrs != null) {
            bw.writeInt(folder.attrs.size());
            Iterator it = folder.attrs.iterator();
            while (it.hasNext()) {
                this.writeAttribute(bw, (ParsingLayerCacheManager.MemAttr)it.next());
            }
        } else {
            bw.writeInt(0);
        }
        if (folder.children != null) {
            bw.writeInt(folder.children.size());
            int baseOffset = bw.getPosition();
            for (ParsingLayerCacheManager.MemFileOrFolder item : folder.children) {
                baseOffset += this.computeHeaderSize(item);
            }
            for (ParsingLayerCacheManager.MemFileOrFolder item : folder.children) {
                bw.writeString(item.name);
                bw.writeByte(item instanceof ParsingLayerCacheManager.MemFile ? (byte)0 : 1);
                bw.writeInt(baseOffset);
                baseOffset += this.computeSize(item);
            }
            for (ParsingLayerCacheManager.MemFileOrFolder item : folder.children) {
                if (item instanceof ParsingLayerCacheManager.MemFile) {
                    this.writeFile(bw, (ParsingLayerCacheManager.MemFile)item);
                    continue;
                }
                this.writeFolder(bw, (ParsingLayerCacheManager.MemFolder)item);
            }
        } else {
            bw.writeInt(0);
        }
    }

    private void writeBaseURLs(ParsingLayerCacheManager.MemFileOrFolder folder, BinaryWriter bw, boolean emptyURLsAllowed) throws IOException {
        List<URL> urls = folder.getURLs();
        if (urls.size() > 0) {
            int last = urls.size() - 1;
            for (int i = 0; i < last; ++i) {
                URL u = urls.get(i);
                bw.writeBaseURL(u);
            }
            bw.writeBaseURL(urls.get(last), true);
        } else assert (emptyURLsAllowed);
    }

    private void writeFile(BinaryWriter bw, ParsingLayerCacheManager.MemFile file) throws IOException {
        this.writeBaseURLs(file, bw, false);
        if (file.attrs != null) {
            bw.writeInt(file.attrs.size());
            Iterator it = file.attrs.iterator();
            while (it.hasNext()) {
                this.writeAttribute(bw, (ParsingLayerCacheManager.MemAttr)it.next());
            }
        } else {
            bw.writeInt(0);
        }
        if (file.ref != null) {
            bw.writeInt(-1);
            bw.writeString(file.ref.toString());
        } else if (file.contents != null) {
            bw.writeInt(file.contents.length);
            bw.writeBytes(file.contents);
        } else {
            bw.writeInt(0);
        }
    }

    private void writeAttribute(BinaryWriter bw, ParsingLayerCacheManager.MemAttr attr) throws IOException {
        bw.writeString(attr.name);
        for (int i = 0; i < ATTR_TYPES.length; ++i) {
            if (!ATTR_TYPES[i].equals(attr.type)) continue;
            bw.writeByte((byte)i);
            bw.writeString(attr.data);
            return;
        }
        throw new IOException("Wrong type: " + attr);
    }

    private int computeSize(ParsingLayerCacheManager.MemFileOrFolder mf) {
        int size;
        block7: {
            block5: {
                ParsingLayerCacheManager.MemFile file;
                block6: {
                    Integer i = this.sizes.get(mf);
                    if (i != null) {
                        return i;
                    }
                    size = mf.getURLs().size() * 4;
                    size += 4;
                    if (mf.attrs != null) {
                        Iterator<ParsingLayerCacheManager.MemAttr> it = mf.attrs.iterator();
                        while (it.hasNext()) {
                            size += this.computeSize(it.next());
                        }
                    }
                    if (!(mf instanceof ParsingLayerCacheManager.MemFile)) break block5;
                    file = (ParsingLayerCacheManager.MemFile)mf;
                    size += 4;
                    if (file.ref == null) break block6;
                    size += BinaryCacheManager.computeSize(file.ref.toString());
                    break block7;
                }
                if (file.contents == null) break block7;
                size += file.contents.length;
                break block7;
            }
            ParsingLayerCacheManager.MemFolder folder = (ParsingLayerCacheManager.MemFolder)mf;
            size += 4;
            if (folder.children != null) {
                for (ParsingLayerCacheManager.MemFileOrFolder item : folder.children) {
                    size += this.computeHeaderSize(item);
                    size += this.computeSize(item);
                }
            }
        }
        this.sizes.put(mf, size);
        return size;
    }

    private int computeHeaderSize(ParsingLayerCacheManager.MemFileOrFolder mof) {
        return BinaryCacheManager.computeSize(mof.name) + 1 + 4;
    }

    private static int computeSize(String s) {
        try {
            return 4 + s.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw (IllegalStateException)new IllegalStateException(e.toString()).initCause(e);
        }
    }

    private int computeSize(ParsingLayerCacheManager.MemAttr attr) {
        return BinaryCacheManager.computeSize(attr.name) + 1 + BinaryCacheManager.computeSize(attr.data);
    }

    private static final class BinaryWriter {
        private OutputStream os;
        private int position;
        private Map urls;

        BinaryWriter(OutputStream os, ParsingLayerCacheManager.MemFolder root, int fsSize) throws IOException {
            this.os = os;
            this.urls = this.writeBaseUrls(root, fsSize);
            this.position = 0;
        }

        int getPosition() {
            return this.position;
        }

        void writeByte(byte b) throws IOException {
            this.os.write(b);
            ++this.position;
        }

        void writeBytes(byte[] bytes) throws IOException {
            this.os.write(bytes);
            this.position += bytes.length;
        }

        void writeInt(int num) throws IOException {
            byte[] data = new byte[]{(byte)num, (byte)(num >> 8), (byte)(num >> 16), (byte)(num >> 24)};
            this.writeBytes(data);
        }

        void writeString(String str) throws IOException {
            byte[] data;
            try {
                data = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw (IllegalStateException)new IllegalStateException(e.toString()).initCause(e);
            }
            this.writeInt(data.length);
            this.writeBytes(data);
        }

        void writeBaseURL(URL url) throws IOException {
            this.writeBaseURL(url, false);
        }

        void writeBaseURL(URL url, boolean negative) throws IOException {
            int[] number = (int[])this.urls.get(url);
            assert (number != null) : "Should not be null, because it was collected: " + url + " map: " + this.urls;
            int index = number[0];
            if (negative) {
                index = -10 - index;
            }
            this.writeInt(index);
        }

        private Map writeBaseUrls(ParsingLayerCacheManager.MemFileOrFolder root, int fsSize) throws IOException {
            URL u;
            Map.Entry<URL, Object> entry;
            int i;
            LinkedHashMap<URL, Object> map = new LinkedHashMap<URL, Object>();
            int[] counter = new int[1];
            this.collectBaseUrls(root, map, counter);
            int size = 0;
            Iterator<Map.Entry<URL, Object>> it = map.entrySet().iterator();
            for (i = 0; i < counter[0]; ++i) {
                entry = it.next();
                u = entry.getKey();
                assert (((int[])entry.getValue())[0] == i) : i + "th key should be it " + ((int[])entry.getValue())[0];
                size += BinaryCacheManager.computeSize(u.toExternalForm());
            }
            this.writeInt(BinaryFS.MAGIC.length + 4 + 4 + size + fsSize);
            this.writeInt(size);
            it = map.entrySet().iterator();
            for (i = 0; i < counter[0]; ++i) {
                entry = it.next();
                u = entry.getKey();
                this.writeString(u.toExternalForm());
            }
            return map;
        }

        private void collectBaseUrls(ParsingLayerCacheManager.MemFileOrFolder f, Map<URL, Object> map, int[] counter) {
            for (URL u : f.getURLs()) {
                int[] exists = (int[])map.get(u);
                if (exists != null) continue;
                map.put(u, counter.clone());
                counter[0] = counter[0] + 1;
            }
            if (f instanceof ParsingLayerCacheManager.MemFolder && ((ParsingLayerCacheManager.MemFolder)f).children != null) {
                Iterator<ParsingLayerCacheManager.MemFileOrFolder> it = ((ParsingLayerCacheManager.MemFolder)f).children.iterator();
                while (it.hasNext()) {
                    this.collectBaseUrls(it.next(), map, counter);
                }
            }
        }
    }
}

