/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.railsprojects.GenerateAction;
import org.netbeans.modules.ruby.railsprojects.MigrateAction;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginAction;
import org.netbeans.modules.ruby.railsprojects.ui.TreeRootNode;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.IrbAction;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.TestActionConfiguration;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunnerAction;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.rubyproject.ui.RubyBaseLogicalViewProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public final class RailsLogicalViewProvider
extends RubyBaseLogicalViewProvider {
    private static final RequestProcessor requestProcessor = new RequestProcessor("Rails Annotation");

    public RailsLogicalViewProvider(RailsProject project, UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper resolver) {
        super((RubyBaseProject)project, helper, evaluator, resolver);
    }

    public Node createLogicalView() {
        return new RailsLogicalViewRootNode();
    }

    protected Node findWithPathFinder(Node root, FileObject target) {
        Node n;
        TreeRootNode.PathFinder pf2 = (TreeRootNode.PathFinder)root.getLookup().lookup(TreeRootNode.PathFinder.class);
        if (pf2 != null && (n = pf2.findPath(root, target)) != null) {
            return n;
        }
        return null;
    }

    private final class RailsLogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private Set<FileObject> files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;
        private final RSpecSupport rspecSupport;

        public RailsLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)RailsLogicalViewProvider.this.getProject(), (String)"Projects/org-netbeans-modules-ruby-railsprojects/Nodes"), Lookups.singleton((Object)RailsLogicalViewProvider.this.getProject()));
            this.privateLock = new Object();
            this.setIconBaseWithExtension("org/netbeans/modules/ruby/railsprojects/ui/resources/rails.png");
            super.setName(ProjectUtils.getInformation((Project)RailsLogicalViewProvider.this.getProject()).getDisplayName());
            this.setProjectFiles((Project)RailsLogicalViewProvider.this.getProject());
            RailsLogicalViewProvider.this.getUpdateHelper().getRakeProjectHelper().addRakeProjectListener(new RakeProjectListener(){

                public void configurationXmlChanged(RakeProjectEvent ev) {
                    RailsLogicalViewRootNode.this.fireShortDescriptionChange();
                }

                public void propertiesChanged(RakeProjectEvent ev) {
                    RailsLogicalViewRootNode.this.fireShortDescriptionChange();
                }
            });
            this.rspecSupport = new RSpecSupport((Project)RailsLogicalViewProvider.this.getProject());
        }

        private void fireShortDescriptionChange() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RailsLogicalViewRootNode.this.fireShortDescriptionChange(null, null);
                }
            });
        }

        public String getShortDescription() {
            String platformDesc = RubyPlatform.platformDescriptionFor((Project)RailsLogicalViewProvider.this.getProject());
            if (platformDesc == null) {
                platformDesc = NbBundle.getMessage(RailsLogicalViewProvider.class, (String)"RailsLogicalViewProvider.PlatformNotFound");
            }
            String dirName = FileUtil.getFileDisplayName((FileObject)RailsLogicalViewProvider.this.getProject().getProjectDirectory());
            return NbBundle.getMessage(RailsLogicalViewProvider.class, (String)"RailsLogicalViewProvider.ProjectTooltipDescription", (Object)dirName, (Object)platformDesc);
        }

        protected final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private final void setGroups(Collection<SourceGroup> groups) {
            if (this.groupsListeners != null) {
                for (SourceGroup group : this.groupsListeners.keySet()) {
                    PropertyChangeListener pcl = this.groupsListeners.get(group);
                    group.removePropertyChangeListener(pcl);
                }
            }
            this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
            HashSet<FileObject> roots = new HashSet<FileObject>();
            Iterator<SourceGroup> it = groups.iterator();
            for (SourceGroup group : groups) {
                PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
                this.groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject fo = group.getRootFolder();
                roots.add(fo);
            }
            this.setFiles(roots);
        }

        protected final void setFiles(Set<FileObject> files) {
            if (this.fileSystemListeners != null) {
                for (FileSystem fs : this.fileSystemListeners.keySet()) {
                    FileStatusListener fsl = this.fileSystemListeners.get(fs);
                    fs.removeFileStatusListener(fsl);
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = files;
            if (files == null) {
                return;
            }
            Iterator<FileObject> it = files.iterator();
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            while (it.hasNext()) {
                FileObject fo = it.next();
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, 0, "Cannot get " + fo + " filesystem, ignoring...", null, null, null);
                    err.notify(1, (Throwable)e);
                }
            }
        }

        public Image getIcon(int type) {
            Image img = super.getIcon(type);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fo = this.files.iterator().next();
                    img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            Image img = this.getMyOpenedIcon(type);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fo = this.files.iterator().next();
                    img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return img;
        }

        private Image getMyOpenedIcon(int type) {
            Image original = super.getOpenedIcon(type);
            return original;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean fireName;
            boolean fireIcon;
            Object object = this.privateLock;
            synchronized (object) {
                fireIcon = this.iconChange;
                fireName = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (fireIcon) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (fireName) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent event) {
            if (this.task == null) {
                this.task = requestProcessor.create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                    for (FileObject fo : this.files) {
                        if (!event.hasChanged(fo)) continue;
                        this.iconChange |= event.isIconChange();
                        this.nameChange |= event.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setProjectFiles((Project)RailsLogicalViewProvider.this.getProject());
            this.fireShortDescriptionChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setProjectFiles((Project)RailsLogicalViewProvider.this.getProject());
        }

        public Action[] getActions(boolean context) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String s) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)RailsLogicalViewProvider.this.getProject(), (String)s);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(RailsLogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            RailsLogicalViewProvider.this.bundlerSupport.initialize();
            ResourceBundle bundle = NbBundle.getBundle(RailsLogicalViewProvider.class);
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(SystemAction.get(GenerateAction.class));
            actions.add(null);
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add(SystemAction.get(RakeRunnerAction.class));
            actions.add(SystemAction.get(IrbAction.class));
            actions.add(SystemAction.get(MigrateAction.class));
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"rails-console", (String)bundle.getString("LBL_ConsoleAction_Name"), null));
            actions.add(SystemAction.get(PluginAction.class));
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null));
            if (AutoTestSupport.isInstalled((Project)RailsLogicalViewProvider.this.getProject(), (TestRunner.TestType)TestRunner.TestType.AUTOTEST) && TestActionConfiguration.enable((String)"autotest", (Project)RailsLogicalViewProvider.this.getProject())) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"autotest", (String)bundle.getString("LBL_AutoTest"), null));
            }
            if (AutoTestSupport.isInstalled((Project)RailsLogicalViewProvider.this.getProject(), (TestRunner.TestType)TestRunner.TestType.AUTOSPEC) && TestActionConfiguration.enable((String)"autospec", (Project)RailsLogicalViewProvider.this.getProject())) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"autospec", (String)bundle.getString("LBL_AutoSpec"), null));
            }
            if (this.rspecSupport.isRSpecInstalled() && TestActionConfiguration.enable((String)"rspec", (Project)RailsLogicalViewProvider.this.getProject())) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"rspec", (String)bundle.getString("LBL_RSpec"), null));
            }
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)bundle.getString("LBL_DebugAction_Name"), null));
            if (TestActionConfiguration.enable((String)"test", (Project)RailsLogicalViewProvider.this.getProject())) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)bundle.getString("LBL_TestAction_Name"), null));
            }
            if (RailsLogicalViewProvider.this.bundlerSupport.installed()) {
                actions.add(RailsLogicalViewProvider.this.bundlerSupport.createAction());
            }
            actions.add(RubyCoverageProvider.createCoverageAction((Project)RailsLogicalViewProvider.this.getProject()));
            actions.add(null);
            actions.add(CommonProjectActions.setProjectConfigurationAction());
            actions.add(null);
            actions.add(CommonProjectActions.setAsMainProjectAction());
            actions.add(CommonProjectActions.openSubprojectsAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(null);
            actions.add(CommonProjectActions.renameProjectAction());
            actions.add(CommonProjectActions.moveProjectAction());
            actions.add(CommonProjectActions.copyProjectAction());
            actions.add(CommonProjectActions.deleteProjectAction());
            actions.add(null);
            actions.add(SystemAction.get(FindAction.class));
            actions.add(null);
            actions.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            actions.add(null);
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        public String toString() {
            return super.toString() + "[project=" + RailsLogicalViewProvider.this.getProject() + "]";
        }
    }
}

