/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.modules.web.taglib.TLDEditorSupport;
import org.netbeans.modules.web.taglib.TLDNode;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;

public final class TLDDataObject
extends MultiDataObject
implements CookieSet.Factory {
    private static final boolean debug = false;
    private volatile transient TLDEditorSupport editorSupport;
    private static final long serialVersionUID = -7581377241494497816L;

    public TLDDataObject() throws DataObjectExistsException, IOException {
        super(null, null);
    }

    public TLDDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException, IOException {
        super(fileObject, multiFileLoader);
        this.getCookieSet().add(TLDEditorSupport.class, (CookieSet.Factory)this);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)validateXMLSupport);
        this.getCookieSet().assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{XmlFileEncodingQueryImpl.singleton()});
    }

    protected synchronized Node createNodeDelegate() {
        return new TLDNode(this);
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public Taglib getTaglib() throws IOException {
        InputStream inputStream = this.getPrimaryFile().getInputStream();
        try {
            return Taglib.createGraph(inputStream);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(runtimeException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Taglib taglib) throws IOException {
        File file = FileUtil.toFile((FileObject)this.getPrimaryFile());
        FileObject fileObject = this.getPrimaryFile();
        try {
            FileLock fileLock = fileObject.lock();
            try {
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                try {
                    String string = taglib.getAttributeValue("version");
                    if (string == null) {
                        taglib.changeDocType("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd");
                        taglib.setAttributeValue("xmlns", null);
                    }
                    taglib.write(outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            // empty catch block
        }
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(TLDEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TLDEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            TLDDataObject tLDDataObject = this;
            synchronized (tLDDataObject) {
                if (this.editorSupport == null) {
                    this.editorSupport = new TLDEditorSupport(this);
                }
            }
        }
        return this.editorSupport;
    }
}

