/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.FieldWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

public class FieldVariable
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.Field,
Refreshable {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    protected Field field;
    private ObjectReference objectReference;
    private ReferenceType classType;
    private boolean valueSet = true;
    private final Object valueLock = new Object();
    private boolean valueRetrieved = false;
    private PrimitiveValue value;

    public FieldVariable(JPDADebuggerImpl jPDADebuggerImpl, PrimitiveValue primitiveValue, Field field, String string, ObjectReference objectReference) {
        super(jPDADebuggerImpl, primitiveValue, FieldVariable.getID(string, field));
        this.field = field;
        this.objectReference = objectReference;
    }

    public FieldVariable(JPDADebuggerImpl jPDADebuggerImpl, Field field, String string, ObjectReference objectReference) {
        this(jPDADebuggerImpl, null, field, string, objectReference);
        this.valueSet = false;
    }

    private static String getID(String string, Field field) {
        try {
            return string + '.' + TypeComponentWrapper.name(field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return string + '.' + internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return string + ".0";
        }
    }

    public String getName() {
        try {
            return TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public String getClassName() {
        try {
            return ReferenceTypeWrapper.name(TypeComponentWrapper.declaringType(this.field));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public JPDAClassType getDeclaringClass() {
        return new JPDAClassTypeImpl(this.getDebugger(), this.getTheDeclaringClassType());
    }

    private ReferenceType getTheDeclaringClassType() {
        ReferenceType referenceType = this.classType;
        if (referenceType == null) {
            this.classType = referenceType = FieldVariable.getTheDeclaringClassType(this.objectReference, this.field);
        }
        return referenceType;
    }

    static ReferenceType getTheDeclaringClassType(ObjectReference objectReference, Field field) {
        ReferenceType referenceType;
        try {
            referenceType = objectReference != null ? (ReferenceType)ValueWrapper.type(objectReference) : TypeComponentWrapper.declaringType(field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            throw internalExceptionWrapper.getCause();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            throw vMDisconnectedExceptionWrapper.getCause();
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            throw objectCollectedExceptionWrapper.getCause();
        }
        return referenceType;
    }

    public String getDeclaredType() {
        try {
            return FieldWrapper.typeName(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "";
        }
    }

    public boolean isStatic() {
        return TypeComponentWrapper.isStatic0(this.field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Value getInnerValue() {
        if (this.valueSet) {
            return super.getInnerValue();
        }
        Object object = this.valueLock;
        synchronized (object) {
            if (!this.valueRetrieved) {
                Value value;
                if (logger.isLoggable(Level.FINE)) {
                    if (this.objectReference == null) {
                        logger.fine("STARTED (FV): " + this.getTheDeclaringClassType() + ".getValue(" + this.field + ")");
                    } else {
                        logger.fine("STARTED (FV): " + this.objectReference + ".getValue(" + this.field + ")");
                    }
                }
                try {
                    value = this.objectReference == null ? ReferenceTypeWrapper.getValue(this.getTheDeclaringClassType(), this.field) : ObjectReferenceWrapper.getValue(this.objectReference, this.field);
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    value = null;
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    value = null;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    value = null;
                }
                if (logger.isLoggable(Level.FINE)) {
                    if (this.objectReference == null) {
                        logger.fine("FINISHED(FV): " + this.getTheDeclaringClassType() + ".getValue(" + this.field + ") = " + value);
                    } else {
                        logger.fine("FINISHED(FV): " + this.objectReference + ".getValue(" + this.field + ") = " + value);
                    }
                    logger.log(Level.FINE, "Called from ", new IllegalStateException("TEST"));
                }
                this.value = (PrimitiveValue)value;
                this.valueRetrieved = true;
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        block15: {
            try {
                Object object;
                boolean bl = false;
                if (this.objectReference != null) {
                    ObjectReferenceWrapper.setValue(this.objectReference, this.field, value);
                    bl = true;
                } else {
                    object = this.getTheDeclaringClassType();
                    if (object instanceof ClassType) {
                        ClassType classType = (ClassType)object;
                        ClassTypeWrapper.setValue(classType, this.field, value);
                        bl = true;
                    }
                }
                if (!bl) {
                    throw new InvalidExpressionException(this.field.toString());
                }
                if (this.valueSet) break block15;
                object = this.valueLock;
                synchronized (object) {
                    this.value = (PrimitiveValue)value;
                }
            }
            catch (IllegalArgumentExceptionWrapper illegalArgumentExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)illegalArgumentExceptionWrapper.getCause());
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new InvalidExpressionException((Throwable)invalidTypeException);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                throw new InvalidExpressionException((Throwable)classNotLoadedException);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)internalExceptionWrapper);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)vMDisconnectedExceptionWrapper);
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)classNotPreparedExceptionWrapper);
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                throw new InvalidExpressionException((Throwable)objectCollectedExceptionWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws RefreshFailedException {
        if (this.valueSet) {
            return;
        }
        Object object = this.valueLock;
        synchronized (object) {
            if (!this.valueRetrieved) {
                this.getInnerValue();
            }
        }
    }

    @Override
    public synchronized boolean isCurrent() {
        return this.valueSet || this.valueRetrieved;
    }

    @Override
    public FieldVariable clone() {
        String string;
        try {
            string = TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            string = internalExceptionWrapper.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            string = "0";
        }
        FieldVariable fieldVariable = new FieldVariable(this.getDebugger(), (PrimitiveValue)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + string + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.objectReference);
        fieldVariable.classType = this.classType;
        return fieldVariable;
    }

    @Override
    public String toString() {
        try {
            return "FieldVariable " + TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return "Disconnected";
        }
    }
}

