/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.SyntaxParserResult;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;

public class JsfUtils {
    public static final String COMPOSITE_LIBRARY_NS = "http://java.sun.com/jsf/composite";
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";

    public static String getCompositeLibraryURL(String string) {
        return "http://java.sun.com/jsf/composite/" + string;
    }

    public static boolean isCompositeComponentLibrary(FaceletsLibrary faceletsLibrary) {
        return faceletsLibrary instanceof CompositeComponentLibrary;
    }

    public static boolean importLibrary(Document document, FaceletsLibrary faceletsLibrary, String string) {
        return !JsfUtils.importLibrary(document, Collections.singletonMap(faceletsLibrary, string)).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<FaceletsLibrary, String> importLibrary(Document document, Map<FaceletsLibrary, String> map) {
        Object object;
        Object object2;
        Object object3;
        assert (document instanceof BaseDocument);
        LinkedHashMap<FaceletsLibrary, String> linkedHashMap = new LinkedHashMap<FaceletsLibrary, String>(map);
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (FaceletsLibrary)iterator.next();
            object2 = (String)linkedHashMap.get(object3);
            if (object2 != null) continue;
            object = ((FaceletsLibrary)object3).getDefaultPrefix();
            if (object != null) {
                linkedHashMap.put((FaceletsLibrary)object3, (String)object);
                continue;
            }
            iterator.remove();
        }
        object3 = (BaseDocument)document;
        try {
            Object object4;
            Object object5;
            Object object62;
            object2 = Source.create((Document)object3);
            object = new HtmlParserResult[1];
            ParserManager.parse(Collections.singleton(object2), (UserTask)new UserTask((HtmlParserResult[])object){
                final /* synthetic */ HtmlParserResult[] val$_result;
                {
                    this.val$_result = htmlParserResultArray;
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    ResultIterator resultIterator2 = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                    if (resultIterator2 != null) {
                        this.val$_result[0] = (HtmlParserResult)resultIterator2.getParserResult();
                    }
                }
            });
            if (object[0] == null) {
                return Collections.emptyMap();
            }
            HtmlParserResult htmlParserResult = object[0];
            Object object7 = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.addAll(htmlParserResult.roots().values());
            arrayList.add(htmlParserResult.root(SyntaxParserResult.UNDECLARED_TAGS_NAMESPACE));
            for (Object object62 : arrayList) {
                object5 = object62.children(new AstNode.NodeFilter(){

                    public boolean accepts(AstNode astNode) {
                        return (astNode.type() == AstNode.NodeType.OPEN_TAG || astNode.type() == AstNode.NodeType.UNKNOWN_TAG) && !astNode.isEmpty();
                    }
                });
                if (object5.isEmpty()) continue;
                object4 = (AstNode)object5.get(0);
                if (object7 == null) {
                    object7 = object4;
                    continue;
                }
                if (object4.startOffset() >= object7.startOffset()) continue;
                object7 = object4;
            }
            Object object8 = object7;
            if (object8 == null) {
                return Collections.emptyMap();
            }
            object62 = linkedHashMap.keySet().iterator();
            while (object62.hasNext()) {
                object5 = (FaceletsLibrary)object62.next();
                object4 = htmlParserResult.getNamespaces();
                String string = (String)object4.get(((FaceletsLibrary)object5).getNamespace());
                if (string == null && object5 instanceof CompositeComponentLibrary) {
                    String string2 = ((CompositeComponentLibrary)object5).getDefaultNamespace();
                    string = (String)object4.get(string2);
                }
                if (string == null) continue;
                object62.remove();
            }
            object5 = Indent.get((Document)object3);
            object5.lock();
            try {
                object3.runAtomic(new Runnable((AstNode)object8, linkedHashMap, htmlParserResult, (BaseDocument)object3, (Indent)object5){
                    final /* synthetic */ AstNode val$rootNode;
                    final /* synthetic */ Map val$imports;
                    final /* synthetic */ HtmlParserResult val$result;
                    final /* synthetic */ BaseDocument val$bdoc;
                    final /* synthetic */ Indent val$indent;
                    {
                        this.val$rootNode = astNode;
                        this.val$imports = map;
                        this.val$result = htmlParserResult;
                        this.val$bdoc = baseDocument;
                        this.val$indent = indent;
                    }

                    @Override
                    public void run() {
                        try {
                            boolean bl = this.val$rootNode.getAttributeKeys().isEmpty();
                            int n = 0;
                            Iterator iterator = this.val$imports.keySet().iterator();
                            int n2 = this.val$result.getSnapshot().getOriginalOffset(this.val$rootNode.endOffset() - 1);
                            if (n2 == -1) {
                                this.val$imports.clear();
                                return;
                            }
                            while (iterator.hasNext()) {
                                FaceletsLibrary faceletsLibrary = (FaceletsLibrary)iterator.next();
                                String string = (String)this.val$imports.get(faceletsLibrary);
                                int n3 = n2 + n;
                                String string2 = (!bl ? "\n" : "") + " xmlns:" + string + "=\"" + faceletsLibrary.getNamespace() + "\"";
                                this.val$bdoc.insertString(n3, string2, null);
                                n += string2.length();
                            }
                            this.val$indent.reindent(n2, n2 + n);
                        }
                        catch (BadLocationException badLocationException) {
                            Logger.global.log(Level.INFO, null, badLocationException);
                        }
                    }
                });
            }
            finally {
                object5.unlock();
            }
            return linkedHashMap;
        }
        catch (ParseException parseException) {
            Logger.global.log(Level.INFO, null, parseException);
            return Collections.emptyMap();
        }
    }

    public static OffsetRange createOffsetRange(Snapshot snapshot, String string, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = string.length();
        for (int i = n; i >= 0; --i) {
            n3 = snapshot.getOriginalOffset(i);
            if (n3 == -1) continue;
            n4 = n3;
            break;
        }
        try {
            n5 = GsfUtilities.getRowEnd((CharSequence)string, (int)n4);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        for (int i = n2; i <= snapshot.getText().length(); ++i) {
            n3 = snapshot.getOriginalOffset(i);
            if (n3 == -1) continue;
            n5 = n3;
            break;
        }
        return new OffsetRange(n4, n5);
    }

    public static Parser.Result getEmbeddedParserResult(ResultIterator resultIterator, String string) throws ParseException {
        for (Embedding embedding : resultIterator.getEmbeddings()) {
            if (!embedding.getMimeType().equals(string)) continue;
            return resultIterator.getResultIterator(embedding).getParserResult();
        }
        return null;
    }

    public static Map<String, FaceletsLibrary> getDeclaredLibraries(HtmlParserResult htmlParserResult) {
        Set set = htmlParserResult.getNamespaces().keySet();
        HashMap<String, FaceletsLibrary> hashMap = new HashMap<String, FaceletsLibrary>();
        JsfSupport jsfSupport = JsfSupport.findFor(htmlParserResult.getSnapshot().getSource().getFileObject());
        if (jsfSupport != null) {
            Map<String, FaceletsLibrary> map = jsfSupport.getFaceletsLibraries();
            for (String string : set) {
                FaceletsLibrary faceletsLibrary = map.get(string);
                if (faceletsLibrary == null) continue;
                hashMap.put(string, faceletsLibrary);
            }
        }
        return hashMap;
    }
}

