/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bugtracking.kenai.QueryDescriptor;
import org.netbeans.modules.bugtracking.kenai.QueryResultHandleImpl;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.WeakListeners;

class QueryHandleImpl
extends QueryHandle
implements QueryDescriptor,
ActionListener,
PropertyChangeListener {
    private final Query query;
    private final PropertyChangeSupport changeSupport;
    protected final boolean predefined;
    private Issue[] issues = new Issue[0];
    private String stringValue;
    protected boolean needsRefresh;

    QueryHandleImpl(Query query, boolean needsRefresh, boolean predefined) {
        this.query = query;
        this.needsRefresh = needsRefresh;
        this.predefined = predefined;
        this.changeSupport = new PropertyChangeSupport(query);
        query.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)query));
        this.registerIssues();
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public boolean isPredefined() {
        return this.predefined;
    }

    public String getDisplayName() {
        return this.query.getDisplayName();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BugtrackingUtil.openQuery((Query)this.query, null, (boolean)true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("bugtracking.query.issues_changed")) {
            this.registerIssues();
            this.changeSupport.firePropertyChange(new PropertyChangeEvent(this, "queryResult", null, this.getQueryResults()));
        } else if (evt.getPropertyName().equals("issue.seen_changed")) {
            this.changeSupport.firePropertyChange(new PropertyChangeEvent(this, "queryResult", null, this.getQueryResults()));
        }
    }

    List<QueryResultHandle> getQueryResults() {
        ArrayList<QueryResultHandle> ret = new ArrayList<QueryResultHandle>();
        QueryResultHandleImpl qh = QueryResultHandleImpl.forStatus(this.query, 14);
        if (qh != null) {
            ret.add(qh);
        }
        if ((qh = QueryResultHandleImpl.forStatus(this.query, 12)) != null) {
            ret.add(qh);
        }
        if ((qh = QueryResultHandleImpl.getAllChangedResult(this.query)) != null) {
            ret.add(qh);
        }
        return ret;
    }

    synchronized void refreshIfNeeded() {
        if (this.needsRefresh) {
            this.needsRefresh = false;
            KenaiSupport ks = (KenaiSupport)this.query.getRepository().getLookup().lookup(KenaiSupport.class);
            assert (ks != null);
            if (ks != null) {
                ks.refresh(this.query, true);
            }
        }
    }

    private void registerIssues() {
        for (Issue issue : this.issues = this.query.getIssues(14)) {
            issue.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)issue));
            IssueCacheUtils.addCacheListener((Issue)issue, (PropertyChangeListener)this);
        }
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            sb.append(this.query.getRepository().getDisplayName());
            sb.append(",");
            sb.append(this.query.getDisplayName());
            sb.append("]");
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryHandleImpl other = (QueryHandleImpl)obj;
        return !(this.toString() == null ? other.toString() != null : !this.toString().equals(other.toString()));
    }
}

