/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.ui.spi.impl;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.support.ValidateableSupport;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.UIUtilities;
import org.openide.util.NbBundle;

class EmptyDetailsViewPanel
extends JPanel
implements ValidationListener {
    private final DLightConfiguration configuration;
    private final DLightTool currentTool;
    private final DLightTarget targetToValidateWith;
    private final Map<Validateable<DLightTarget>, ValidationStatus> states = new HashMap<Validateable<DLightTarget>, ValidationStatus>();
    private final Map<Validateable<DLightTarget>, Integer> panels = new HashMap<Validateable<DLightTarget>, Integer>();
    private final List<JPanel> panelsList;

    public EmptyDetailsViewPanel(DLightConfiguration dlightConfiguration, DLightTool tool, DLightTarget targetToValidateWith) {
        this.configuration = dlightConfiguration;
        this.targetToValidateWith = targetToValidateWith;
        this.currentTool = tool;
        List collectors = this.configuration.getConfigurationOptions(false).getCollectors(this.currentTool);
        ArrayList toRepairList = new ArrayList();
        this.panelsList = new ArrayList<JPanel>();
        this.setLayout(new BoxLayout(this, 1));
        JPanel repairPanel = new JPanel();
        repairPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        repairPanel.setLayout(new BoxLayout(repairPanel, 1));
        if (collectors == null || collectors.size() == 0) {
            JPanel p = new JPanel();
            p.setBorder(new EmptyBorder(10, 10, 10, 10));
            p.setLayout(new BoxLayout(p, 1));
            ValidationStatus status = tool.validateDataCollectors(dlightConfiguration, targetToValidateWith);
            if (!status.isKnown() || status.isValid()) {
                status = ValidationStatus.invalidStatus((String)NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"DataCollectorDisabled"));
            }
            JEditorPane editorPane = UIUtilities.createJEditorPane((String)status.getReason(), (boolean)true);
            p.add(editorPane);
            repairPanel.add(p);
            repairPanel.add(Box.createVerticalGlue());
        } else {
            for (DataCollector c : collectors) {
                JEditorPane label;
                JPanel p;
                if (c.getValidationStatus() == ValidationStatus.initialStatus()) {
                    c.addValidationListener((ValidationListener)this);
                    this.states.put((Validateable<DLightTarget>)c, c.getValidationStatus());
                    p = new JPanel();
                    p.setBorder(new EmptyBorder(10, 10, 10, 10));
                    p.setLayout(new BoxLayout(p, 1));
                    label = UIUtilities.createJEditorPane((String)NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"Validating"), (boolean)true);
                    p.add(label);
                    repairPanel.add(p);
                    repairPanel.add(Box.createVerticalGlue());
                    this.panelsList.add(p);
                    this.panels.put((Validateable<DLightTarget>)c, this.panelsList.indexOf(p));
                    this.repair((Validateable<DLightTarget>)c);
                    continue;
                }
                if (!c.getValidationStatus().isKnown()) {
                    c.addValidationListener((ValidationListener)this);
                    this.states.put((Validateable<DLightTarget>)c, c.getValidationStatus());
                    p = new JPanel();
                    p.setBorder(new EmptyBorder(10, 10, 10, 10));
                    p.setLayout(new BoxLayout(p, 1));
                    label = UIUtilities.createJEditorPane((String)c.getValidationStatus().getReason(), (boolean)false);
                    Dimension d = label.getPreferredSize();
                    label.setMaximumSize(new Dimension(d.width + 10, d.height));
                    label.setAlignmentX(0.5f);
                    p.add(label);
                    p.add(Box.createVerticalStrut(10));
                    JButton repairButton = new JButton(NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"Repair"));
                    repairButton.setAlignmentX(0.5f);
                    repairButton.addActionListener(new ActionListener((Validateable)c){
                        final /* synthetic */ Validateable val$c;
                        {
                            this.val$c = validateable;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EmptyDetailsViewPanel.this.repair((Validateable<DLightTarget>)this.val$c);
                        }
                    });
                    p.add(repairButton);
                    p.add(Box.createVerticalGlue());
                    repairPanel.add(p);
                    repairPanel.add(Box.createVerticalGlue());
                    this.panelsList.add(p);
                    this.panels.put((Validateable<DLightTarget>)c, this.panelsList.indexOf(p));
                    continue;
                }
                ValidationStatus status = c.getValidationStatus();
                JPanel p2 = new JPanel();
                p2.setBorder(new EmptyBorder(10, 10, 10, 10));
                p2.setLayout(new BoxLayout(p2, 1));
                if (!status.isKnown()) {
                    p2.add(UIUtilities.createJEditorPane((String)status.getReason(), (boolean)false));
                } else if (status.isValid()) {
                    String message = NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"NextRun");
                    if (!this.configuration.getConfigurationOptions(false).areCollectorsTurnedOn()) {
                        message = NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"DataCollectorDisabled");
                    }
                    p2.add(UIUtilities.createJEditorPane((String)message, (boolean)true));
                } else if (status.isInvalid()) {
                    JEditorPane editorPane = UIUtilities.createJEditorPane((String)status.getReason(), (boolean)false);
                    p2.add(editorPane);
                }
                repairPanel.add(p2);
                repairPanel.add(Box.createVerticalGlue());
                this.panelsList.add(p2);
                this.panels.put((Validateable<DLightTarget>)c, this.panelsList.indexOf(p2));
            }
        }
        repairPanel.setAlignmentX(0.5f);
        repairPanel.setAlignmentY(0.5f);
        this.add(repairPanel);
        if (!toRepairList.isEmpty()) {
            for (DataCollector c : toRepairList) {
                this.repair((Validateable<DLightTarget>)c);
            }
        }
    }

    private void repair(final Validateable<DLightTarget> c) {
        ValidateableSupport support = new ValidateableSupport(c);
        final Future taskStatus = support.asyncValidate((Object)this.targetToValidateWith, true);
        DLightExecutorService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ValidationStatus status = (ValidationStatus)taskStatus.get();
                UIThread.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EmptyDetailsViewPanel.this.updateUI((Validateable<DLightTarget>)c);
                    }
                });
                return status.isKnown();
            }
        }, (String)"EmptyDetailsViewPanel task");
    }

    private void updateUI(final Validateable<DLightTarget> v) {
        JPanel p = this.panelsList.get(this.panels.get(v));
        p.removeAll();
        ValidationStatus status = v.getValidationStatus();
        if (!status.isKnown()) {
            JEditorPane label = UIUtilities.createJEditorPane((String)status.getReason(), (boolean)false);
            Dimension d = label.getPreferredSize();
            label.setMaximumSize(new Dimension(d.width + 10, d.height));
            label.setAlignmentX(0.5f);
            p.add(label);
            p.add(Box.createVerticalStrut(10));
            JButton repairButton = new JButton(NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"Repair"));
            repairButton.setAlignmentX(0.5f);
            repairButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmptyDetailsViewPanel.this.repair((Validateable<DLightTarget>)v);
                }
            });
            p.add(repairButton);
            p.add(Box.createVerticalGlue());
            p.repaint();
            this.repaint();
            return;
        }
        if (status.isValid()) {
            String message = NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"NextRun");
            if (!this.configuration.getConfigurationOptions(false).areCollectorsTurnedOn()) {
                message = NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"DataCollectorDisabled");
            }
            p.add(UIUtilities.createJEditorPane((String)message, (boolean)true));
            p.repaint();
            this.repaint();
            return;
        }
        if (status.isInvalid()) {
            p.add(UIUtilities.createJEditorPane((String)status.getReason(), (boolean)false));
            p.repaint();
            this.repaint();
            return;
        }
    }

    private void updateAllUI() {
        for (final Validateable<DLightTarget> v : this.states.keySet()) {
            JPanel p = this.panelsList.get(this.panels.get(v));
            p.removeAll();
            ValidationStatus status = v.getValidationStatus();
            if (!status.isKnown()) {
                JEditorPane label = UIUtilities.createJEditorPane((String)status.getReason(), (boolean)false);
                Dimension d = label.getPreferredSize();
                label.setMaximumSize(new Dimension(d.width + 10, d.height));
                label.setAlignmentX(0.5f);
                p.add(label);
                p.add(Box.createVerticalStrut(10));
                JButton repairButton = new JButton(NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"Repair"));
                repairButton.setAlignmentX(0.5f);
                repairButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EmptyDetailsViewPanel.this.repair((Validateable<DLightTarget>)v);
                    }
                });
                p.add(repairButton);
                p.add(Box.createVerticalGlue());
                p.repaint();
                this.repaint();
            } else if (status.isValid()) {
                String message = NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"NextRun");
                if (!this.configuration.getConfigurationOptions(false).areCollectorsTurnedOn()) {
                    message = NbBundle.getMessage(EmptyDetailsViewPanel.class, (String)"DataCollectorDisabled");
                }
                p.add(UIUtilities.createJEditorPane((String)message, (boolean)true));
            } else if (status.isInvalid()) {
                p.add(UIUtilities.createJEditorPane((String)status.getReason(), (boolean)false));
            }
            p.repaint();
        }
        this.repaint();
    }

    public void validationStateChanged(final Validateable source, ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (this.states.get(source) == null) {
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    EmptyDetailsViewPanel.this.updateAllUI();
                }
            });
            return;
        }
        UIThread.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                EmptyDetailsViewPanel.this.updateUI((Validateable<DLightTarget>)source);
            }
        });
    }
}

