/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.AddPushRegistryPanel;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.customizer.MIDletScanner;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CustomizerPushReg
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener,
ChangeListener,
TableModelListener {
    static final long serialVersionUID = 1191422396924194938L;
    static final String[] PROPERTY_GROUP = new String[]{"manifest.pushregistry"};
    protected final JTable table;
    protected final StorableTableModel tableModel;
    private final DefaultComboBoxModel cbmClassesForAdd = new DefaultComboBoxModel();
    private VisualPropertySupport vps;
    private String configuration;
    private String configurationProfileValue;
    private String defaultProfileValue;
    protected HashSet<String> classes;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bMoveDown;
    private JButton bMoveUp;
    private JButton bRemove;
    private JCheckBox cDefault;
    private ErrorPanel errorPanel;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public CustomizerPushReg() {
        this.initComponents();
        this.initAccessibility();
        this.tableModel = new StorableTableModel();
        this.table = new JTable(this.tableModel);
        this.tableModel.addTableModelListener(this);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setResizable(true);
        col.setPreferredWidth(150);
        col = this.table.getColumnModel().getColumn(1);
        col.setResizable(true);
        col.setPreferredWidth(100);
        col = this.table.getColumnModel().getColumn(2);
        col.setResizable(true);
        col.setPreferredWidth(200);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setForeground(isSelected ? table.getSelectionForeground() : (column == 0 && CustomizerPushReg.this.classes != null && !CustomizerPushReg.this.classes.contains(value) ? Color.RED : table.getForeground()));
                return component;
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    CustomizerPushReg.this.bEditActionPerformed(null);
                }
            }
        });
    }

    private void initComponents() {
        this.cDefault = new JCheckBox();
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.bMoveUp = new JButton();
        this.bMoveDown = new JButton();
        this.errorPanel = new ErrorPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cDefault, gridBagConstraints);
        this.lTable.setLabelFor(this.lTable);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Table"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Add"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPushReg.this.bAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Edit"));
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPushReg.this.bEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.bEdit, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Remove"));
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPushReg.this.bRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.bRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bMoveUp, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_MoveUp"));
        this.bMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPushReg.this.bMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.bMoveUp, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bMoveDown, (String)NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_MoveDown"));
        this.bMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPushReg.this.bMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.bMoveDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPushReg.class, (String)"ACSN_Push"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPushReg.class, (String)"ACSD_Push"));
    }

    private void bEditActionPerformed(ActionEvent evt) {
        final int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        final AddPushRegistryPanel add = new AddPushRegistryPanel(this.cbmClassesForAdd, (String)this.tableModel.getValueAt(row, 0), (String)this.tableModel.getValueAt(row, 1), (String)this.tableModel.getValueAt(row, 2));
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(CustomizerPushReg.class, (String)"TITLE_EditPush"), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    CustomizerPushReg.this.tableModel.setRow(row, add.getClazz(), add.getSender(), add.getString());
                    CustomizerPushReg.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bAddActionPerformed(ActionEvent evt) {
        final AddPushRegistryPanel add = new AddPushRegistryPanel(this.cbmClassesForAdd);
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(CustomizerPushReg.class, (String)"TITLE_AddPush"), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    int row = CustomizerPushReg.this.tableModel.addRow(add.getClazz(), add.getSender(), add.getString());
                    CustomizerPushReg.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bMoveDownActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i >= this.tableModel.getRowCount() - 1) {
            return;
        }
        this.tableModel.moveDown(i);
        this.table.getSelectionModel().setSelectionInterval(++i, i);
    }

    private void bMoveUpActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i <= 0) {
            return;
        }
        this.tableModel.moveUp(i);
        this.table.getSelectionModel().setSelectionInterval(--i, i);
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.tableModel.removeRow(i);
        int max = this.tableModel.getRowCount();
        if (max <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (i < max) {
            this.table.getSelectionModel().setSelectionInterval(i, i);
        } else {
            this.table.getSelectionModel().setSelectionInterval(max - 1, max - 1);
        }
    }

    @Override
    public void initValues(ProjectProperties props, String configuration) {
        this.configuration = configuration;
        this.configurationProfileValue = (String)props.get(VisualPropertySupport.translatePropertyName(configuration, "platform.profile", false));
        this.defaultProfileValue = (String)props.get("platform.profile");
        this.configuration = configuration;
        this.classes = null;
        MIDletScanner scanner = MIDletScanner.getDefault(props);
        scanner.scan(this.cbmClassesForAdd, null, configuration, this);
        this.vps = VisualPropertySupport.getDefault(props);
        this.vps.register(this.cDefault, configuration, this);
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    private boolean isMIDP10() {
        String value = null;
        if (this.configuration != null) {
            value = this.configurationProfileValue;
        }
        if (value == null) {
            value = this.defaultProfileValue;
        }
        return value != null && value.equals("MIDP-1.0");
    }

    @Override
    public void initGroupValues(boolean useDefault) {
        this.vps.register(this.tableModel, new String[]{"manifest.pushregistry"}, useDefault);
        this.bAdd.setEnabled(!useDefault);
        this.bEdit.setEnabled(!useDefault);
        this.bRemove.setEnabled(!useDefault);
        this.table.setEnabled(!useDefault);
        this.lTable.setEnabled(!useDefault);
        this.table.setBackground(UIManager.getDefaults().getColor(useDefault ? "TextField.inactiveBackground" : "Table.background"));
        this.valueChanged(null);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.classes != null && !this.classes.containsAll(this.tableModel.getClasses())) {
            this.errorPanel.setErrorBundleMessage("ERR_CustMIDlets_WrongMIDlets");
        } else {
            this.errorPanel.setErrorBundleMessage(this.isMIDP10() ? "ERR_Push_NotUsed" : null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean enabled = this.table.isEnabled() && this.table.getSelectedRow() >= 0;
        this.bEdit.setEnabled(enabled);
        this.bRemove.setEnabled(enabled);
        this.bMoveUp.setEnabled(enabled && this.table.getSelectedRow() > 0);
        this.bMoveDown.setEnabled(enabled && this.table.getSelectedRow() < this.tableModel.getRowCount() - 1);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.classes = new HashSet();
        for (int i = 0; i < this.cbmClassesForAdd.getSize(); ++i) {
            this.classes.add((String)this.cbmClassesForAdd.getElementAt(i));
        }
        this.tableModel.fireTableDataChanged();
    }

    private static class StorableTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        public static final String PREFIX = "MIDlet-Push-";
        private static final int[] COLUMN_MAP = new int[]{1, 2, 0};
        private HashMap<String, String> map = new HashMap();
        private int rows = 0;
        private static final long serialVersionUID = 920375326055211848L;

        private StorableTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        public Set<String> getClasses() {
            HashSet<String> classes = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                classes.add((String)this.getValueAt(i, 0));
            }
            return classes;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Column_Class");
                }
                case 1: {
                    return NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Column_Sender");
                }
                case 2: {
                    return NbBundle.getMessage(CustomizerPushReg.class, (String)"LBL_Push_Column_String");
                }
            }
            return null;
        }

        public int addRow(String clazz, String sender, String string) {
            ++this.rows;
            this.setRow(this.rows - 1, string + ',' + clazz + ',' + sender);
            this.fireTableRowsInserted(this.rows - 1, this.rows - 1);
            return this.rows - 1;
        }

        private String getRow(int row) {
            assert (row < this.rows);
            String value = this.map.get(PREFIX + String.valueOf(row + 1));
            return value == null ? ",," : value;
        }

        private void setRow(int row, String value) {
            assert (row < this.rows);
            this.map.put(PREFIX + String.valueOf(row + 1), value);
        }

        public void removeRow(int row) {
            for (int i = row; i < this.rows - 1; ++i) {
                this.setRow(i, this.getRow(i + 1));
            }
            this.map.remove(PREFIX + String.valueOf(this.rows));
            --this.rows;
            this.fireTableRowsDeleted(row, row);
        }

        public void moveUp(int row) {
            String r = this.getRow(row);
            this.setRow(row, this.getRow(row - 1));
            this.setRow(row - 1, r);
            this.fireTableRowsUpdated(row - 1, row);
        }

        public void moveDown(int row) {
            String r = this.getRow(row);
            this.setRow(row, this.getRow(row + 1));
            this.setRow(row + 1, r);
            this.fireTableRowsUpdated(row, row + 1);
        }

        @Override
        public Object getValueAt(int row, int column) {
            assert (column < 3);
            return this.getRow(row).split(",", 3)[COLUMN_MAP[column]].trim();
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            return new Object[]{this.map};
        }

        @Override
        public synchronized void setDataDelegates(Object[] data) {
            this.map = data[0] == null ? new HashMap() : (HashMap)data[0];
            this.rows = 0;
            for (String key : this.map.keySet()) {
                if (!key.startsWith(PREFIX)) continue;
                try {
                    int i = Integer.parseInt(key.substring(PREFIX.length()));
                    if (i <= this.rows) continue;
                    this.rows = i;
                }
                catch (NumberFormatException nfe) {
                    assert (false) : nfe;
                }
            }
            this.fireTableDataChanged();
        }

        public void setRow(int row, String clazz, String sender, String string) {
            this.setRow(row, string + ',' + clazz + ',' + sender);
            this.fireTableRowsUpdated(row, row);
        }
    }
}

