/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class SourceUtilsEx {
    public static FileObject getFile(Element element, ClasspathInfo classpathInfo, Cache cache) {
        String string;
        Element element2;
        Parameters.notNull((CharSequence)"element", (Object)element);
        Parameters.notNull((CharSequence)"cpInfo", (Object)classpathInfo);
        Parameters.notNull((CharSequence)"cache", (Object)cache);
        Element element3 = element;
        Element element4 = element2 = element3.getKind() == ElementKind.PACKAGE ? element3 : null;
        while (element3.getKind() != ElementKind.PACKAGE) {
            element2 = element3;
            element3 = element3.getEnclosingElement();
        }
        if (element2 == null) {
            return null;
        }
        ElementKind elementKind = element2.getKind();
        if (elementKind.isClass() || elementKind.isInterface()) {
            string = ((TypeElement)element2).getQualifiedName().toString();
        } else if (elementKind == ElementKind.PACKAGE) {
            string = ((PackageElement)element2).getQualifiedName().toString();
        } else {
            return null;
        }
        Object object = cache.cacheOfSrcFiles.get(string);
        if (object == null) {
            ElementHandle elementHandle = ElementHandle.create((Element)element2);
            object = SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)classpathInfo);
            cache.cacheOfSrcFiles.put(string, object != null ? object : Cache.NULL);
        } else if (object == Cache.NULL) {
            object = null;
        }
        return (FileObject)object;
    }

    public static Collection<FileObject> getFiles(Collection<ElementHandle<? extends Element>> collection, ClasspathInfo classpathInfo) {
        Parameters.notNull((CharSequence)"handle", collection);
        Parameters.notNull((CharSequence)"cpInfo", (Object)classpathInfo);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(collection.size());
        HashMap<String, ArrayList<ResolvedElementHandle>> hashMap = new HashMap<String, ArrayList<ResolvedElementHandle>>();
        try {
            ClassPath classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), SourceUtilsEx.createClassPath(classpathInfo, ClasspathInfo.PathKind.BOOT), SourceUtilsEx.createClassPath(classpathInfo, ClasspathInfo.PathKind.COMPILE)});
            for (ElementHandle<? extends Element> object : collection) {
                ResolvedElementHandle resolvedElementHandle = ResolvedElementHandle.create(object);
                ArrayList<ResolvedElementHandle> arrayList2 = (ArrayList<ResolvedElementHandle>)hashMap.get(resolvedElementHandle.pkgName);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<ResolvedElementHandle>();
                    hashMap.put(resolvedElementHandle.pkgName, arrayList2);
                }
                arrayList2.add(resolvedElementHandle);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                SourceUtilsEx.searchFiles((String)entry.getKey(), (List)entry.getValue(), classPath, arrayList);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }

    private static void searchFiles(String string, List<ResolvedElementHandle> list, ClassPath classPath, List<FileObject> list2) throws IOException {
        List list3 = classPath.findAllResources(string);
        for (FileObject fileObject : list3) {
            FileObject fileObject2;
            Iterator<ResolvedElementHandle> iterator;
            FileObject fileObject3 = classPath.findOwnerRoot(fileObject);
            assert (fileObject3 != null);
            FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObject3.getURL()).getRoots();
            ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
            LinkedList<FileObject> linkedList = new LinkedList<FileObject>(classPath2.findAllResources(string));
            Iterator<ResolvedElementHandle> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                iterator = iterator2.next();
                if (!((ResolvedElementHandle)((Object)iterator)).pkg) continue;
                list2.add(linkedList.isEmpty() ? fileObject : (FileObject)linkedList.get(0));
                iterator2.remove();
                break;
            }
            if (list.isEmpty()) {
                return;
            }
            boolean bl = SourceUtilsEx.isCaseSensitive();
            linkedList.addFirst(fileObject);
            for (Object object : linkedList) {
                for (FileObject fileObject4 : fileObject2 = object.getChildren()) {
                    SourceUtilsEx.searchChildren(fileObject4, list, list2, bl);
                    if (!list.isEmpty()) continue;
                    return;
                }
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = iterator.next();
                fileObject2 = fileObjectArray.length == 0 ? SourceUtilsEx.findSource(object.signature[0], fileObject3) : SourceUtilsEx.findSource(object.signature[0], fileObjectArray);
                if (fileObject2 == null) continue;
                iterator.remove();
                list2.add(fileObject2);
            }
        }
    }

    private static void searchChildren(FileObject fileObject, List<ResolvedElementHandle> list, List<FileObject> list2, boolean bl) {
        Iterator<ResolvedElementHandle> iterator = list.iterator();
        while (iterator.hasNext()) {
            ResolvedElementHandle resolvedElementHandle = iterator.next();
            if ((!bl || !fileObject.getName().equals(resolvedElementHandle.getSourceFileName())) && (bl || !fileObject.getName().equalsIgnoreCase(resolvedElementHandle.getSourceFileName())) || !fileObject.isData() || !"java".equalsIgnoreCase(fileObject.getExt())) continue;
            iterator.remove();
            list2.add(fileObject);
        }
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    private static String getSourceFileName(String string) {
        int n = string.indexOf(36);
        return n == -1 ? string : string.substring(0, n);
    }

    private static String[] getElementHandleSignature(ElementHandle elementHandle) {
        try {
            Method method = ElementHandle.class.getDeclaredMethod("getSignature", new Class[0]);
            method.setAccessible(true);
            return (String[])method.invoke((Object)elementHandle, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static ClassPath createClassPath(ClasspathInfo classpathInfo, ClasspathInfo.PathKind pathKind) {
        try {
            Method method = SourceUtils.class.getDeclaredMethod("createClassPath", ClasspathInfo.class, ClasspathInfo.PathKind.class);
            method.setAccessible(true);
            return (ClassPath)method.invoke(null, classpathInfo, pathKind);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static FileObject findSource(String string, FileObject ... fileObjectArray) throws IOException {
        try {
            Method method = SourceUtils.class.getDeclaredMethod("findSource", String.class, FileObject[].class);
            method.setAccessible(true);
            return (FileObject)method.invoke(null, string, fileObjectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof IOException) {
                throw (IOException)invocationTargetException.getCause();
            }
            throw new IllegalStateException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static String convertPackage2Folder(String string) {
        return string.replace('.', '/');
    }

    private static final class ResolvedElementHandle {
        String pkgName;
        String className;
        String[] signature;
        boolean pkg;
        private String sourceFileName;

        private ResolvedElementHandle() {
        }

        static ResolvedElementHandle create(ElementHandle<? extends Element> elementHandle) {
            ResolvedElementHandle resolvedElementHandle = new ResolvedElementHandle();
            resolvedElementHandle.pkg = elementHandle.getKind() == ElementKind.PACKAGE;
            resolvedElementHandle.signature = SourceUtilsEx.getElementHandleSignature(elementHandle);
            assert (resolvedElementHandle.signature.length >= 1);
            if (resolvedElementHandle.pkg) {
                resolvedElementHandle.pkgName = SourceUtilsEx.convertPackage2Folder(resolvedElementHandle.signature[0]);
            } else {
                int n = resolvedElementHandle.signature[0].lastIndexOf(46);
                if (n < 0) {
                    resolvedElementHandle.pkgName = "";
                    resolvedElementHandle.className = resolvedElementHandle.signature[0];
                } else {
                    resolvedElementHandle.pkgName = SourceUtilsEx.convertPackage2Folder(resolvedElementHandle.signature[0].substring(0, n));
                    resolvedElementHandle.className = resolvedElementHandle.signature[0].substring(n + 1);
                }
            }
            return resolvedElementHandle;
        }

        public String getSourceFileName() {
            if (this.sourceFileName == null) {
                this.sourceFileName = SourceUtilsEx.getSourceFileName(this.className);
            }
            return this.sourceFileName;
        }
    }

    public static final class Cache {
        private static final Object NULL = new Object();
        private final Map<String, Object> cacheOfSrcFiles = new HashMap<String, Object>();
    }
}

