/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelativePath
implements Comparable<RelativePath> {
    protected final String path;

    protected RelativePath(String p) {
        this.path = p;
    }

    public abstract RelativeDirectory dirname();

    public abstract String basename();

    public File getFile(File directory) {
        if (this.path.length() == 0) {
            return directory;
        }
        return new File(directory, this.path.replace('/', File.separatorChar));
    }

    @Override
    public int compareTo(RelativePath other) {
        return this.path.compareTo(other.path);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RelativePath)) {
            return false;
        }
        return this.path.equals(((RelativePath)other).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "RelPath[" + this.path + "]";
    }

    public String getPath() {
        return this.path;
    }

    public static class RelativeFile
    extends RelativePath {
        static RelativeFile forClass(CharSequence className, JavaFileObject.Kind kind) {
            return new RelativeFile(((Object)className).toString().replace('.', '/') + kind.extension);
        }

        public RelativeFile(String p) {
            super(p);
            if (p.endsWith("/")) {
                throw new IllegalArgumentException(p);
            }
        }

        public RelativeFile(RelativeDirectory d, String p) {
            this(d.path + p);
        }

        RelativeFile(RelativeDirectory d, RelativePath p) {
            this(d, p.path);
        }

        public RelativeDirectory dirname() {
            int sep = this.path.lastIndexOf(47);
            return new RelativeDirectory(this.path.substring(0, sep + 1));
        }

        public String basename() {
            int sep = this.path.lastIndexOf(47);
            return this.path.substring(sep + 1);
        }

        ZipEntry getZipEntry(ZipFile zip) {
            return zip.getEntry(this.path);
        }

        public String toString() {
            return "RelativeFile[" + this.path + "]";
        }
    }

    public static class RelativeDirectory
    extends RelativePath {
        static RelativeDirectory forPackage(CharSequence packageName) {
            return new RelativeDirectory(((Object)packageName).toString().replace('.', '/'));
        }

        public RelativeDirectory(String p) {
            super(p.length() == 0 || p.endsWith("/") ? p : p + "/");
        }

        public RelativeDirectory(RelativeDirectory d, String p) {
            this(d.path + p);
        }

        public RelativeDirectory dirname() {
            int l = this.path.length();
            if (l == 0) {
                return this;
            }
            int sep = this.path.lastIndexOf(47, l - 2);
            return new RelativeDirectory(this.path.substring(0, sep + 1));
        }

        public String basename() {
            int l = this.path.length();
            if (l == 0) {
                return this.path;
            }
            int sep = this.path.lastIndexOf(47, l - 2);
            return this.path.substring(sep + 1, l - 1);
        }

        boolean contains(RelativePath other) {
            return other.path.length() > this.path.length() && other.path.startsWith(this.path);
        }

        public String toString() {
            return "RelativeDirectory[" + this.path + "]";
        }
    }
}

