/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.customizer;

import com.sun.javacard.filemodels.ParseErrorHandler;
import com.sun.javacard.filemodels.WebXmlModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.customizer.AllClassesOfTypeExplorerPanel;
import org.netbeans.modules.javacard.project.customizer.WebEditorUnlockPanel;
import org.netbeans.modules.javacard.project.customizer.WebProjectProperties;
import org.netbeans.modules.javacard.project.ui.CheckboxListView;
import org.netbeans.modules.javacard.project.ui.FileModelFactory;
import org.netbeans.modules.javacard.project.ui.NodeCheckObserver;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebCustomizer
extends AllClassesOfTypeExplorerPanel
implements DocumentListener,
PropertyChangeListener,
NodeCheckObserver,
FocusListener,
ActionListener {
    private WebProjectProperties props;
    private final ProjectCustomizer.Category category;
    private JTextField displayNameField;
    private JLabel jLabel1;
    private JLabel listLabel;
    private JTextField mappingField;
    private JLabel mappingLabel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JScrollPane servletList;
    private WebEditorUnlockPanel unlockPanel1;
    private JCheckBox useAsDefault;
    private WebXmlModel diskModel;
    private final Object lock = new Object();
    private boolean locked;
    private boolean inUpdateFields;
    private final Set<Node> checkedNodes = new HashSet<Node>();
    L l = new L();

    public WebCustomizer(WebProjectProperties props, ProjectCustomizer.Category category) {
        super("javax.servlet.http.HttpServlet", NbBundle.getMessage(WebCustomizer.class, (String)"WAIT_MSG"));
        this.category = category;
        this.initComponents();
        if (props != null) {
            this.setProperties(props);
        }
        ((CheckboxListView)((Object)this.servletList)).setNodeCheckObserver(this);
        ((CheckboxListView)((Object)this.servletList)).setCheckboxesVisible(false);
        for (Component c : this.getComponents()) {
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                Mnemonics.setLocalizedText((AbstractButton)b, (String)b.getText());
                continue;
            }
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                Mnemonics.setLocalizedText((JLabel)l, (String)l.getText());
                continue;
            }
            if (!(c instanceof JTextComponent)) continue;
            c.addFocusListener(this);
        }
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this);
        this.mappingField.getDocument().addDocumentListener(this);
        this.nameField.getDocument().addDocumentListener(this);
        this.displayNameField.getDocument().addDocumentListener(this);
        this.unlockPanel1.setVisible(false);
        this.unlockPanel1.addActionListener(this.l);
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.WebPanel");
    }

    private void change(Document document) {
        if (this.inUpdateFields) {
            return;
        }
        Node[] nodes = this.mgr.getSelectedNodes();
        if (nodes.length == 1) {
            Node n = nodes[0];
            if (document == this.nameField.getDocument()) {
                n.setValue("servletName", (Object)this.nameField.getText());
            } else if (document == this.mappingField.getDocument()) {
                n.setValue("mapping", (Object)this.mappingField.getText());
            }
        }
        this.updatePropsUiModel();
    }

    private void updatePropsUiModel() {
        if (this.locked) {
            return;
        }
        WebXmlModel m = this.getModelFromUI();
        String problem = m.getProblem();
        this.setProblem(problem);
        if (problem == null) {
            this.props.setWebXmlUiModel(m);
            this.props.setWebContextPathAndMainUrl(m.defaultServlet(), m.defaultMapping());
        }
    }

    private void initComponents() {
        this.servletList = new CheckboxListView();
        this.listLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.mappingLabel = new JLabel();
        this.mappingField = new JTextField();
        this.jLabel1 = new JLabel();
        this.displayNameField = new JTextField();
        this.useAsDefault = new JCheckBox();
        this.unlockPanel1 = new WebEditorUnlockPanel();
        this.servletList.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.listLabel.setLabelFor(this.servletList);
        this.listLabel.setText(NbBundle.getMessage(WebCustomizer.class, (String)"WebCustomizer.listLabel.text"));
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(NbBundle.getMessage(WebCustomizer.class, (String)"WebCustomizer.nameLabel.text"));
        this.nameLabel.setEnabled(false);
        this.nameField.setText(NbBundle.getMessage(WebCustomizer.class, (String)"WebCustomizer.nameField.text"));
        this.nameField.setEnabled(false);
        this.mappingLabel.setLabelFor(this.mappingField);
        this.mappingLabel.setText(NbBundle.getMessage(WebCustomizer.class, (String)"WebCustomizer.mappingLabel.text"));
        this.mappingLabel.setEnabled(false);
        this.mappingField.setText(NbBundle.getMessage(WebCustomizer.class, (String)"WebCustomizer.mappingField.text"));
        this.mappingField.setEnabled(false);
        this.jLabel1.setText(NbBundle.getMessage(WebCustomizer.class, (String)"WebCustomizer.jLabel1.text"));
        this.jLabel1.setEnabled(false);
        this.displayNameField.setText(NbBundle.getMessage(WebCustomizer.class, (String)"WebCustomizer.displayNameField.text"));
        this.displayNameField.setEnabled(false);
        this.useAsDefault.setText(NbBundle.getMessage(WebCustomizer.class, (String)"WebCustomizer.useAsDefault.text"));
        this.useAsDefault.setEnabled(false);
        this.useAsDefault.setHorizontalTextPosition(10);
        this.useAsDefault.addActionListener(this);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.unlockPanel1, -1, 682, Short.MAX_VALUE).add((Component)this.useAsDefault).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.displayNameField, -1, 519, Short.MAX_VALUE)).add(1, (Component)this.listLabel, -2, 173, -2).add(1, (Component)this.servletList, -1, 682, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.nameLabel).addPreferredGap(0).add((Component)this.nameField, -1, 161, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.mappingLabel).addPreferredGap(0).add((Component)this.mappingField, -1, 155, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.displayNameField, -2, -1, -2)).addPreferredGap(1).add((Component)this.listLabel).add(11, 11, 11).add((Component)this.servletList, -2, 162, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameField, -2, -1, -2).add((Component)this.mappingLabel).add((Component)this.mappingField, -2, -1, -2)).addPreferredGap(1).add((Component)this.useAsDefault).addPreferredGap(1).add((Component)this.unlockPanel1, -2, 135, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.useAsDefault) {
            this.useAsDefaultActionPerformed(evt);
        }
    }

    private void useAsDefaultActionPerformed(ActionEvent evt) {
        if (this.inUpdateFields) {
            return;
        }
        Node[] n = this.mgr.getSelectedNodes();
        boolean sel = this.useAsDefault.isSelected();
        if (sel) {
            if (n.length == 1 && n[0].getLookup().lookup(String.class) != null) {
                for (Node nd : this.mgr.getRootContext().getChildren().getNodes()) {
                    nd.setValue("default", (Object)Boolean.FALSE);
                }
            }
            n[0].setValue("default", (Object)Boolean.TRUE);
            String webContextPath = (String)n[0].getValue("servletName");
            String mainUrl = (String)n[0].getValue("mapping");
            this.props.setWebContextPathAndMainUrl(webContextPath, mainUrl);
        } else {
            n[0].setValue("default", (Object)Boolean.FALSE);
        }
    }

    synchronized void setProperties(WebProjectProperties props) {
        this.props = props;
        this.setClassPath(props.getProject().getSourceClassPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSearchBegun() {
        if (!this.isDisplayable()) {
            return;
        }
        JCProject project = this.props.getProject();
        FileObject webXml = project.getProjectDirectory().getFileObject("WEB-INF/web.xml");
        try {
            WebXmlModel m;
            InputStream in = webXml.getInputStream();
            try {
                m = new WebXmlModel(in, (ParseErrorHandler)new PEH());
            }
            finally {
                in.close();
            }
            Object object = this.lock;
            synchronized (object) {
                this.diskModel = m;
            }
            if (m.hasUnknownTags()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebCustomizer.this.locked = true;
                        ((CheckboxListView)((Object)WebCustomizer.this.servletList)).setCheckboxesEnabled(false);
                        WebCustomizer.this.unlockPanel1.setVisible(true);
                        WebCustomizer.this.repaint();
                    }
                });
            }
            if (m.isError()) {
                this.category.setErrorMessage(NbBundle.getMessage(WebCustomizer.class, (String)"WEB_XML_HAS_ERRORS"));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected void onSearchCompleted() {
        WebXmlModel m;
        Node[] nodes = this.mgr.getRootContext().getChildren().getNodes();
        if (nodes.length == 0) {
            this.category.setErrorMessage(NbBundle.getMessage(WebCustomizer.class, (String)"MSG_NO_SERVLETS_FOUND"));
        }
        if ((m = this.getModelFromFile()) != null && !m.isError()) {
            FileModelFactory.writeTo(m, nodes);
            this.displayNameField.setEnabled(!this.locked);
        } else if (m != null && m.isError()) {
            this.unlockPanel1.setVisible(false);
        }
        for (Node n : nodes) {
            if (Boolean.TRUE.equals(n.getValue("selected"))) {
                this.checkedNodes.add(n);
            }
            String mapping = (String)n.getValue("mapping");
            String name = (String)n.getValue("servletName");
            if (name == null || mapping == null || !name.equals(this.props.getWebContextPath()) || !mapping.equals(this.props.getServletMapping())) continue;
            n.setValue("default", (Object)Boolean.TRUE);
        }
        this.props.setWebXmlFileModel(this.diskModel);
        ((CheckboxListView)((Object)this.servletList)).setCheckboxesVisible(true);
        this.displayNameField.setText(m.getDisplayName());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebCustomizer.this.propertyChange(null);
                WebCustomizer.this.updateFields();
                WebCustomizer.this.servletList.requestFocus();
                WebCustomizer.this.displayNameField.setEnabled(!m.isError() && !WebCustomizer.this.locked);
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.change(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.change(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.change(e.getDocument());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null || "selectedNodes".equals(evt.getPropertyName())) {
            WebXmlModel m;
            Node[] n = this.mgr.getSelectedNodes();
            boolean enable = false;
            if (n.length == 1) {
                enable = this.checkedNodes.contains(n[0]);
            }
            if ((m = this.getModelFromFile()) == null || m.isError()) {
                enable = false;
            }
            if (this.locked) {
                enable = false;
            }
            this.mappingLabel.setEnabled(enable);
            this.nameField.setEnabled(enable);
            this.mappingField.setEnabled(enable);
            this.nameLabel.setEnabled(enable);
            this.jLabel1.setEnabled(enable);
            this.useAsDefault.setEnabled(enable);
            if (evt != null) {
                this.updateFields();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFields() {
        this.inUpdateFields = true;
        try {
            Node[] nodes = this.mgr.getSelectedNodes();
            if (nodes.length == 0) {
                this.nameField.setText("");
                this.mappingField.setText("");
            } else {
                Node n = nodes[0];
                String mapping = (String)n.getValue("mapping");
                String name = (String)n.getValue("servletName");
                this.nameField.setText(name);
                this.mappingField.setText(mapping);
                if (mapping != null && name != null && mapping.equals(this.props.getServletMapping()) && name.equals(this.props.getWebContextPath())) {
                    this.useAsDefault.setSelected(true);
                }
                boolean def = this.mgr.getRootContext().getChildren().getNodes().length == 1 ? true : Boolean.TRUE.equals(n.getValue("default"));
                this.useAsDefault.setSelected(def);
            }
        }
        finally {
            this.inUpdateFields = false;
        }
    }

    @Override
    public void onNodeChecked(Node node) {
        this.checkedNodes.add(node);
        this.propertyChange(null);
        this.updatePropsUiModel();
    }

    @Override
    public void onNodeUnchecked(Node node) {
        this.checkedNodes.remove(node);
        this.propertyChange(null);
        this.updatePropsUiModel();
    }

    @Override
    public void focusGained(FocusEvent e) {
        ((JTextComponent)e.getComponent()).selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    boolean fileHasErrors() {
        WebXmlModel m = this.getModelFromFile();
        return m == null ? false : m.isError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebXmlModel getModelFromFile() {
        WebXmlModel result;
        Object object = this.lock;
        synchronized (object) {
            result = this.diskModel;
        }
        return result;
    }

    WebXmlModel getModelFromUI() {
        WebXmlModel result = FileModelFactory.webXmlModel(this.mgr.getRootContext().getChildren().getNodes());
        result.setDefaultServlet(this.nameField.getText().trim());
        result.setDefaultMapping(this.mappingField.getText().trim());
        result.setDisplayName(this.displayNameField.getText());
        return result;
    }

    public boolean hasChanges() {
        WebXmlModel fromUi = this.getModelFromUI();
        WebXmlModel fromFile = this.getModelFromFile();
        if (fromFile == null || fromFile.isError()) {
            return false;
        }
        return !fromFile.equals((Object)fromUi);
    }

    public boolean isProblem() {
        return this.category.isValid();
    }

    public void setProblem(String problem) {
        boolean bad = problem == null ? false : problem.trim().length() != 0;
        this.category.setValid(!bad);
        if (bad) {
            this.category.setErrorMessage(problem);
        } else {
            this.category.setErrorMessage("");
        }
    }

    private class L
    implements ActionListener {
        private L() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WebCustomizer.this.locked = false;
            ((CheckboxListView)((Object)WebCustomizer.this.servletList)).setCheckboxesEnabled(true);
            WebCustomizer.this.unlockPanel1.setVisible(false);
            WebCustomizer.this.displayNameField.setEnabled(true);
            WebCustomizer.this.servletList.requestFocus();
            WebCustomizer.this.propertyChange(null);
            WebCustomizer.this.invalidate();
            WebCustomizer.this.revalidate();
            WebCustomizer.this.repaint();
        }
    }

    private class PEH
    implements ParseErrorHandler {
        private PEH() {
        }

        public void handleError(IOException arg0) throws IOException {
            throw arg0;
        }

        public void handleBadAIDError(IllegalArgumentException arg0, String arg1) {
            Logger.getLogger(PEH.class.getName()).log(Level.INFO, "Bad AID in " + arg1, arg0);
        }

        public void unrecognizedElementEncountered(String arg0) throws IOException {
        }
    }
}

