/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server.system;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class HeapDump {
    private static Object hotspotDiag;
    private static Method dumpHeapMethod;
    private static boolean initialized;

    private HeapDump() {
    }

    public static void initialize(boolean jdk15) {
        if (jdk15) {
            HeapDump.initialize15();
        } else {
            HeapDump.initialize16();
        }
    }

    public static String takeHeapDump(boolean jdk15, String outputFile) {
        if (jdk15) {
            return HeapDump.takeHeapDump15(outputFile);
        }
        return HeapDump.takeHeapDump16(outputFile);
    }

    private static native void initialize15();

    private static void initialize16() {
        MBeanServer mserver;
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            mserver = ManagementFactory.getPlatformMBeanServer();
        }
        catch (JMRuntimeException ex) {
            System.err.println(ex.getLocalizedMessage());
            initialized = false;
            return;
        }
        try {
            ObjectInstance instance = mserver.getObjectInstance(new ObjectName("com.sun.management:type=HotSpotDiagnostic"));
            hotspotDiag = mserver.instantiate(instance.getClassName());
            dumpHeapMethod = hotspotDiag.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (MalformedObjectNameException ex) {
            ex.printStackTrace();
        }
        catch (InstanceNotFoundException ex) {
            System.err.println("Heap Dump is not available");
        }
        catch (MBeanException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (ReflectionException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
    }

    private static String takeHeapDump15(String outputFile) {
        int error = -1;
        try {
            error = HeapDump.takeHeapDump15Native(outputFile);
        }
        catch (Exception ex) {
            return ex.getLocalizedMessage();
        }
        if (error == -1) {
            return "Take heap dump is not available.";
        }
        return null;
    }

    private static native int takeHeapDump15Native(String var0);

    private static String takeHeapDump16(String outputFile) {
        String error = null;
        HeapDump.initialize16();
        if (dumpHeapMethod == null || hotspotDiag == null) {
            return "Take heap dump is not available.";
        }
        try {
            dumpHeapMethod.invoke(hotspotDiag, outputFile, Boolean.TRUE);
        }
        catch (IllegalArgumentException ex) {
            error = ex.getLocalizedMessage();
        }
        catch (IllegalAccessException ex) {
            error = ex.getLocalizedMessage();
        }
        catch (InvocationTargetException ex) {
            error = ex.getTargetException().getLocalizedMessage();
        }
        return error;
    }
}

