/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.model.Build;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SelectAppServerPanel;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.profile.Activation;
import org.netbeans.modules.maven.model.profile.ActivationProperty;
import org.netbeans.modules.maven.model.profile.Profile;
import org.netbeans.modules.maven.model.profile.ProfilesModel;
import org.netbeans.modules.maven.spi.customizer.ModelHandleUtils;
import org.netbeans.modules.maven.spi.debug.MavenDebugger;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.OutputWriter;

public class ExecutionChecker
implements ExecutionResultChecker,
PrerequisitesChecker {
    private final Project project;
    public static final String DEV_NULL = "DEV-NULL";
    public static final String MODULEURI = "netbeans.deploy.clientModuleUri";
    public static final String CLIENTURLPART = "netbeans.deploy.clientUrlPart";
    private static final String NB_COS = ".netbeans_automatic_build";

    ExecutionChecker(Project project) {
        this.project = project;
    }

    public void executionResult(RunConfig runConfig, ExecutionContext executionContext, int n) {
        boolean bl = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy"));
        if (bl && n == 0) {
            if (RunUtils.hasApplicationCompileOnSaveEnabled((RunConfig)runConfig)) {
                this.touchCoSTimeStamp(runConfig, System.currentTimeMillis());
            }
            String string = runConfig.getProperties().getProperty(MODULEURI);
            String string2 = runConfig.getProperties().getProperty(CLIENTURLPART, "");
            boolean bl2 = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy.forceRedeploy", "true"));
            boolean bl3 = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy.debugmode"));
            boolean bl4 = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy.profilemode"));
            this.performDeploy(executionContext, bl3, bl4, string, string2, bl2);
        }
    }

    private void performDeploy(ExecutionContext executionContext, boolean bl, boolean bl2, String string, String string2, boolean bl3) {
        FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)this.project.getProjectDirectory())});
        OutputWriter outputWriter = executionContext.getInputOutput().getErr();
        OutputWriter outputWriter2 = executionContext.getInputOutput().getOut();
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            outputWriter.println();
            outputWriter.println();
            outputWriter.println("NetBeans: Application Server deployment not available for Maven project '" + ProjectUtils.getInformation((Project)this.project).getDisplayName() + "'");
            return;
        }
        String string3 = j2eeModuleProvider.getServerInstanceID();
        if (DEV_NULL.equals(string3)) {
            outputWriter.println();
            outputWriter.println();
            outputWriter.println("NetBeans: No suitable Deployment Server is defined for the project or globally.");
            return;
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(string3);
        try {
            outputWriter2.println("NetBeans: Deploying on " + (serverInstance != null ? serverInstance.getDisplayName() : string3));
        }
        catch (InstanceRemovedException instanceRemovedException) {
            outputWriter2.println("NetBeans: Deploying on " + string3);
        }
        try {
            String string4;
            FileObject fileObject;
            outputWriter2.println("    profile mode: " + bl2);
            outputWriter2.println("    debug mode: " + bl);
            outputWriter2.println("    force redeploy: " + bl3);
            Deployment.Mode mode = Deployment.Mode.RUN;
            if (bl) {
                mode = Deployment.Mode.DEBUG;
            } else if (bl2) {
                mode = Deployment.Mode.PROFILE;
            }
            String string5 = Deployment.getDefault().deploy(j2eeModuleProvider, mode, string, string2, bl3, (Deployment.Logger)new DLogger(outputWriter2));
            if (string5 != null) {
                fileObject = this.project.getProjectDirectory();
                boolean bl4 = true;
                if (fileObject != null) {
                    string4 = (String)fileObject.getAttribute("netbeans.deploy.showBrowser");
                    boolean bl5 = bl4 = string4 != null ? Boolean.parseBoolean(string4) : true;
                }
                if (bl4) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(string5));
                }
            }
            if (bl && (fileObject = j2eeModuleProvider.getServerDebugInfo()) != null) {
                String string6 = fileObject.getHost();
                string4 = fileObject.getTransport();
                String string7 = "";
                string7 = string4.equals("dt_shmem") ? fileObject.getShmemName() : Integer.toString(fileObject.getPort());
                MavenDebugger mavenDebugger = (MavenDebugger)this.project.getLookup().lookup(MavenDebugger.class);
                mavenDebugger.attachDebugger(executionContext.getInputOutput(), "Debug Deployed app", string4, string6, string7);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ExecutionChecker.class.getName()).log(Level.FINE, "Exception occured wile deploying to Application Server.", exception);
        }
    }

    public boolean checkRunConfig(RunConfig runConfig) {
        J2eeModuleProvider j2eeModuleProvider;
        boolean bl = Boolean.parseBoolean(runConfig.getProperties().getProperty("netbeans.deploy"));
        if (bl && (j2eeModuleProvider = (J2eeModuleProvider)runConfig.getProject().getLookup().lookup(J2eeModuleProvider.class)) != null && DEV_NULL.equals(j2eeModuleProvider.getServerInstanceID())) {
            boolean bl2 = this.neitherJettyNorCargo(runConfig.getGoals());
            SelectAppServerPanel selectAppServerPanel = new SelectAppServerPanel(!bl2, this.project);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectAppServerPanel, NbBundle.getMessage(ExecutionChecker.class, (String)"TIT_Select"));
            selectAppServerPanel.setNLS(dialogDescriptor.createNotificationLineSupport());
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object == NotifyDescriptor.OK_OPTION) {
                String string = selectAppServerPanel.getSelectedServerInstance();
                String string2 = selectAppServerPanel.getSelectedServerType();
                if (!DEV_NULL.equals(string)) {
                    Object object2;
                    boolean bl3 = selectAppServerPanel.isPermanent();
                    if (bl3) {
                        this.persistServer(string, string2, selectAppServerPanel.getChosenProject());
                    } else {
                        object2 = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
                        ((SessionContent)object2).setServerInstanceId(string);
                        WebModuleProviderImpl webModuleProviderImpl = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
                        POHImpl pOHImpl = (POHImpl)((Object)this.project.getLookup().lookup(POHImpl.class));
                        if (webModuleProviderImpl != null) {
                            pOHImpl.setContextPath(webModuleProviderImpl.getWebModuleImplementation().getContextPath());
                        }
                        pOHImpl.hackModuleServerChange();
                        j2eeModuleProvider = null;
                    }
                    object2 = new LogRecord(Level.INFO, "USG_PROJECT_CONFIG_MAVEN_SERVER");
                    ((LogRecord)object2).setLoggerName("org.netbeans.ui.metrics.maven");
                    ((LogRecord)object2).setParameters(new Object[]{POHImpl.obtainServerName(this.project)});
                    POHImpl.USG_LOGGER.log((LogRecord)object2);
                    return true;
                }
                if (selectAppServerPanel.isIgnored()) {
                    this.removeNetbeansDeployFromActionMappings(runConfig.getActionName());
                    return true;
                }
            }
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExecutionChecker.class, (String)"ERR_Action_without_deployment_server"));
            return false;
        }
        return true;
    }

    private boolean touchCoSTimeStamp(RunConfig runConfig, long l) {
        if (runConfig.getProject() == null) {
            return false;
        }
        Build build = runConfig.getMavenProject().getBuild();
        if (build == null || build.getOutputDirectory() == null) {
            return false;
        }
        File file = new File(build.getOutputDirectory());
        if (!(file = FileUtil.normalizeFile((File)file)).exists()) {
            return false;
        }
        File file2 = new File(file, NB_COS);
        if (!file2.exists()) {
            try {
                return file2.createNewFile();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return file2.setLastModified(l);
    }

    public static boolean hasCoSTimeStamp(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject == null) {
            return false;
        }
        Build build = nbMavenProject.getMavenProject().getBuild();
        if (build == null || build.getOutputDirectory() == null) {
            return false;
        }
        File file = new File(build.getOutputDirectory());
        file = FileUtil.normalizeFile((File)file);
        File file2 = new File(file, NB_COS);
        return file2.exists();
    }

    private void removeNetbeansDeployFromActionMappings(String string) {
        try {
            Properties properties;
            ModelHandle modelHandle = ModelHandleUtils.createModelHandle((Project)this.project);
            NetbeansActionMapping netbeansActionMapping = ModelHandle.getActiveMapping((String)string, (Project)this.project);
            if (netbeansActionMapping != null && (properties = netbeansActionMapping.getProperties()) != null) {
                properties.remove("netbeans.deploy");
                ModelHandle.setUserActionMapping((NetbeansActionMapping)netbeansActionMapping, (ActionToGoalMapping)modelHandle.getActionMappings());
                modelHandle.markAsModified((Object)modelHandle.getActionMappings());
                ModelHandleUtils.writeModelHandle((ModelHandle)modelHandle, (Project)this.project);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            Exceptions.printStackTrace((Throwable)xmlPullParserException);
        }
    }

    private boolean neitherJettyNorCargo(List<String> list) {
        for (String string : list) {
            if (!string.contains("jetty") && !string.contains("cargo")) continue;
            return false;
        }
        return true;
    }

    private void persistServer(final String string, final String string2, Project project) {
        ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel pOMModel) {
                org.netbeans.modules.maven.model.pom.Properties properties = pOMModel.getProject().getProperties();
                if (properties == null) {
                    properties = pOMModel.getFactory().createProperties();
                    pOMModel.getProject().setProperties(properties);
                }
                properties.setProperty("netbeans.hint.deploy.server", string2);
            }
        };
        ModelOperation<ProfilesModel> modelOperation2 = new ModelOperation<ProfilesModel>(){

            public void performOperation(ProfilesModel profilesModel) {
                Profile profile;
                org.netbeans.modules.maven.model.profile.Properties properties;
                Profile profile2 = null;
                List list = profilesModel.getProfilesRoot().getProfiles();
                if (list != null) {
                    properties = list.iterator();
                    while (properties.hasNext()) {
                        profile = (Profile)properties.next();
                        if (!"netbeans-private".equals(profile.getId())) continue;
                        profile2 = profile;
                        break;
                    }
                }
                if (profile2 == null) {
                    profile2 = profilesModel.getFactory().createProfile();
                    profile2.setId("netbeans-private");
                    properties = profilesModel.getFactory().createActivation();
                    profile = profilesModel.getFactory().createActivationProperty();
                    profile.setName("netbeans.execution");
                    profile.setValue("true");
                    properties.setActivationProperty((ActivationProperty)profile);
                    profile2.setActivation((Activation)properties);
                    profilesModel.getProfilesRoot().addProfile(profile2);
                }
                if ((properties = profile2.getProperties()) == null) {
                    properties = profilesModel.getFactory().createProperties();
                    profile2.setProperties(properties);
                }
                properties.setProperty("netbeans.deployment.server.id", string);
            }
        };
        final FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject("pom.xml");
        try {
            fileObject2.getFileSystem().runAtomicAction(new FileSystem.AtomicAction((ModelOperation)modelOperation2, fileObject2, (ModelOperation)modelOperation){
                final /* synthetic */ ModelOperation val$profoperation;
                final /* synthetic */ FileObject val$fo;
                final /* synthetic */ ModelOperation val$operation;
                {
                    this.val$profoperation = modelOperation;
                    this.val$fo = fileObject2;
                    this.val$operation = modelOperation2;
                }

                public void run() throws IOException {
                    FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)"profiles.xml");
                    Utilities.performProfilesModelOperations((FileObject)fileObject2, Collections.singletonList(this.val$profoperation));
                    Utilities.performPOMModelOperations((FileObject)this.val$fo, Collections.singletonList(this.val$operation));
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        POHImpl pOHImpl = (POHImpl)((Object)this.project.getLookup().lookup(POHImpl.class));
        pOHImpl.hackModuleServerChange();
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        Set set = subprojectProvider.getSubprojects();
        if (!set.contains(this.project)) {
            NbMavenProject.fireMavenProjectReload((Project)this.project);
        }
        for (Project project2 : set) {
            NbMavenProject.fireMavenProjectReload((Project)project2);
        }
    }

    private static class DLogger
    implements Deployment.Logger {
        private OutputWriter logger;

        public DLogger(OutputWriter outputWriter) {
            this.logger = outputWriter;
        }

        public void log(String string) {
            this.logger.println(string);
        }
    }
}

