/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.BuildPlatformConfiguration;
import org.netbeans.modules.cnd.makeproject.platform.Platform;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbBundle;

public class DevelopmentHostConfiguration {
    public static final String PROP_DEV_HOST = "devHost";
    private final int def;
    private int value = 0;
    private List<ExecutionEnvironment> servers = ServerList.getEnvironments();
    private BuildPlatformConfiguration buildPlatformConfiguration;
    private boolean modified;
    private boolean dirty = false;
    private PropertyChangeSupport pcs;

    public DevelopmentHostConfiguration(ExecutionEnvironment execEnv) {
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!execEnv.equals(this.servers.get(i))) continue;
            this.value = i;
            break;
        }
        this.def = this.value;
        this.pcs = new PropertyChangeSupport(this);
        int buildPlatform = CompilerSetManager.get((ExecutionEnvironment)execEnv).getPlatform();
        if (buildPlatform == -1) {
            buildPlatform = 6;
        }
        this.buildPlatformConfiguration = new BuildPlatformConfiguration(buildPlatform, Platforms.getPlatformDisplayNames());
    }

    public String getHostKey() {
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.servers.get(this.value));
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.servers.get(this.value);
    }

    public String getDisplayName(boolean displayIfNotFound) {
        String out = ServerList.get((ExecutionEnvironment)this.getExecutionEnvironment()).getDisplayName();
        if (displayIfNotFound && !this.isConfigured()) {
            out = NbBundle.getMessage(DevelopmentHostConfiguration.class, (String)"NOT_CONFIGURED", (Object)out);
        } else {
            int platformID = this.getBuildPlatformConfiguration().getValue();
            Platform platform = Platforms.getPlatform(platformID);
            if (platform != null) {
                out = out + " [" + platform.getDisplayName() + "]";
            }
        }
        return out;
    }

    public String getHostDisplayName(boolean displayIfNotFound) {
        String out = ServerList.get((ExecutionEnvironment)this.getExecutionEnvironment()).getServerDisplayName();
        if (displayIfNotFound && !this.isConfigured()) {
            out = NbBundle.getMessage(DevelopmentHostConfiguration.class, (String)"NOT_CONFIGURED", (Object)out);
        }
        return out;
    }

    public boolean isConfigured() {
        return !CompilerSetManager.get((ExecutionEnvironment)this.getExecutionEnvironment()).isUninitialized();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(String v) {
        this.setValue(v, false);
    }

    public void setValue(String v, boolean firePC) {
        if (this.setValueImpl(v, firePC)) {
            return;
        }
        this.addDevelopmentHost(v);
        this.setValueImpl(v, firePC);
    }

    public boolean setHost(ExecutionEnvironment execEnv) {
        return this.setHost(execEnv, false);
    }

    public boolean setHost(ExecutionEnvironment execEnv, boolean firePC) {
        CndUtils.assertTrue((execEnv != null ? 1 : 0) != 0);
        boolean result = this.setHostImpl(execEnv);
        if (!result) {
            this.addDevelopmentHost(execEnv);
            result = this.setHostImpl(execEnv);
        }
        if (firePC) {
            this.fireHostChanged();
        }
        return result;
    }

    private boolean setHostImpl(ExecutionEnvironment execEnv) {
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!this.servers.get(i).equals(execEnv)) continue;
            this.value = i;
            this.setBuildPlatform(CompilerSetManager.get((ExecutionEnvironment)execEnv).getPlatform());
            if (this.getBuildPlatform() == -1) {
                this.setBuildPlatform(6);
            }
            return true;
        }
        return false;
    }

    private void fireHostChanged() {
        ExecutionEnvironment env;
        ExecutionEnvironment executionEnvironment = env = 0 < this.value && this.value < this.servers.size() ? this.servers.get(this.value) : null;
        if (env != null) {
            this.pcs.firePropertyChange(PROP_DEV_HOST, ExecutionEnvironmentFactory.toUniqueID(env), this);
        }
    }

    private boolean setValueImpl(String v, final boolean firePC) {
        for (int i = 0; i < this.servers.size(); ++i) {
            final ExecutionEnvironment currEnv = this.servers.get(i);
            final ServerRecord currRecord = ServerList.get((ExecutionEnvironment)currEnv);
            if (!currRecord.getDisplayName().equals(v)) continue;
            final int newValue = i;
            final Runnable setter = new Runnable(){

                @Override
                public void run() {
                    DevelopmentHostConfiguration.this.value = newValue;
                    DevelopmentHostConfiguration.this.setBuildPlatform(CompilerSetManager.get((ExecutionEnvironment)currEnv).getPlatform());
                    if (DevelopmentHostConfiguration.this.getBuildPlatform() == -1) {
                        DevelopmentHostConfiguration.this.setBuildPlatform(6);
                    }
                    if (firePC) {
                        DevelopmentHostConfiguration.this.fireHostChanged();
                    }
                }
            };
            if (currRecord.isSetUp()) {
                setter.run();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (currRecord.setUp()) {
                            setter.run();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private boolean addDevelopmentHost(String host) {
        return this.addDevelopmentHost(ExecutionEnvironmentFactory.fromUniqueID((String)host));
    }

    private boolean addDevelopmentHost(ExecutionEnvironment execEnv) {
        ServerRecord record = ServerList.addServer((ExecutionEnvironment)execEnv, null, null, (boolean)false, (boolean)false);
        this.servers = ServerList.getEnvironments();
        return record != null;
    }

    public void reset() {
        this.servers = ServerList.getEnvironments();
        this.value = this.def;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    void assign(DevelopmentHostConfiguration conf) {
        boolean dirty2 = false;
        ExecutionEnvironment oldEnv = this.getExecutionEnvironment();
        ExecutionEnvironment newEnv = conf.getExecutionEnvironment();
        if (this.servers.size() != conf.servers.size()) {
            this.servers = ServerList.getEnvironments();
            dirty2 = true;
        }
        if (!newEnv.equals(oldEnv)) {
            dirty2 = true;
        }
        this.setDirty(dirty2);
        this.setHost(newEnv);
        this.getBuildPlatformConfiguration().assign(conf.getBuildPlatformConfiguration());
    }

    public DevelopmentHostConfiguration clone() {
        DevelopmentHostConfiguration clone = new DevelopmentHostConfiguration(this.getExecutionEnvironment());
        clone.setHost(this.getExecutionEnvironment());
        clone.setBuildPlatformConfiguration(this.getBuildPlatformConfiguration().clone());
        return clone;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public boolean isLocalhost() {
        return this.getExecutionEnvironment().isLocal();
    }

    public int getBuildPlatform() {
        return this.getBuildPlatformConfiguration().getValue();
    }

    public void setBuildPlatform(int buildPlatform) {
        this.getBuildPlatformConfiguration().setValue(buildPlatform);
    }

    public String getBuildPlatformDisplayName() {
        if (this.isConfigured()) {
            return Platforms.getPlatform(this.getBuildPlatform()).getDisplayName();
        }
        return "";
    }

    public String getBuildPlatformName() {
        if (this.isConfigured()) {
            return Platforms.getPlatform(this.getBuildPlatform()).getName();
        }
        return "";
    }

    public BuildPlatformConfiguration getBuildPlatformConfiguration() {
        return this.buildPlatformConfiguration;
    }

    public void setBuildPlatformConfiguration(BuildPlatformConfiguration buildPlatformConfiguration) {
        this.buildPlatformConfiguration = buildPlatformConfiguration;
    }
}

