/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.util.ArrayList;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;

public class CppUtils {
    private CppUtils() {
    }

    public static String reformatWhitespaces(String string) {
        return CppUtils.reformatWhitespaces(string, "");
    }

    public static String reformatWhitespaces(String string, String prepend) {
        return CppUtils.reformatWhitespaces(string, prepend, "");
    }

    public static String reformatWhitespaces(String string, String prepend, String delimiter) {
        if (string == null || string.length() == 0) {
            return string;
        }
        boolean firstToken = true;
        ArrayList<String> tokens = CppUtils.tokenizeString(string);
        StringBuilder formattedString = new StringBuilder(string.length());
        for (String token : tokens) {
            if (!firstToken) {
                formattedString.append(delimiter);
                formattedString.append(" ");
            }
            formattedString.append(prepend);
            formattedString.append(token);
            firstToken = false;
        }
        return formattedString.toString();
    }

    public static ArrayList<String> tokenizeString(String string) {
        ArrayList<String> list = new ArrayList<String>(0);
        if (string == null || string.length() == 0) {
            return list;
        }
        StringBuilder token = new StringBuilder();
        boolean inToken = false;
        boolean inQuote = false;
        char quoteChar = '\u0000';
        for (int i = 0; i <= string.length(); ++i) {
            boolean eol;
            boolean bl = eol = i == string.length();
            if (eol || inToken) {
                if (!eol && inQuote) {
                    token.append(string.charAt(i));
                    if (string.charAt(i) != quoteChar) continue;
                    inQuote = false;
                    continue;
                }
                if (eol || Character.isWhitespace(string.charAt(i))) {
                    if (token.length() > 0) {
                        list.add(token.toString());
                    }
                    inToken = false;
                    token = new StringBuilder();
                    continue;
                }
                token.append(string.charAt(i));
                if (string.charAt(i) != '\"' && string.charAt(i) != '`' && string.charAt(i) != '\'') continue;
                inQuote = true;
                quoteChar = string.charAt(i);
                continue;
            }
            if (Character.isWhitespace(string.charAt(i))) continue;
            token.append(string.charAt(i));
            inToken = true;
        }
        if (token.length() > 0) {
            list.add(token.toString());
        }
        return list;
    }

    public static String normalizeDriveLetter(CompilerSet cs, String path) {
        if (path.length() > 1 && path.charAt(1) == ':') {
            return cs.getCompilerFlavor().getToolchainDescriptor().getDriveLetterPrefix() + path.charAt(0) + path.substring(2);
        }
        return path;
    }

    @CheckReturnValue
    public static String getQmakeSpec(CompilerSet cs, int platform) {
        CompilerFlavor flavor = cs.getCompilerFlavor();
        String qmakespec = flavor.getToolchainDescriptor().getQmakeSpec();
        if (qmakespec != null && 0 <= qmakespec.indexOf("${os}")) {
            String os = null;
            switch (platform) {
                case 2: {
                    os = "linux";
                    break;
                }
                case 4: {
                    os = "macx";
                    break;
                }
                case 0: 
                case 1: {
                    os = "solaris";
                    break;
                }
                case 3: {
                    os = "win32";
                }
            }
            qmakespec = os == null ? null : qmakespec.replaceAll("\\$\\{os\\}", os);
        }
        return qmakespec;
    }

    public static String getDefaultDevelopmentHost() {
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ServerList.getDefaultRecord().getExecutionEnvironment());
    }
}

