/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BuildActionsPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ConfigureUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.MakefileOrConfigureDescriptorPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MakefileOrConfigurePanel
extends JPanel
implements HelpCtx.Provider {
    private DocumentListener documentListener;
    private MakefileOrConfigureDescriptorPanel descriptorPanel;
    private ButtonGroup buttonGroup;
    private JLabel configureArgumentsLabel;
    private JTextField configureArgumentsTextField;
    private JButton configureBrowseButton;
    private JLabel configureMakefileNameLabel;
    private JTextField configureMakefileNameTextField;
    private JLabel configureNameLabel;
    private JTextField configureNameTextField;
    private JRadioButton configureRadioButton;
    private JLabel infoLabel;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JCheckBox makeCheckBox;
    private JButton makefileBrowseButton;
    private JLabel makefileNameLabel;
    private JTextField makefileNameTextField;
    private JRadioButton makefileRadioButton;
    private JCheckBox runConfigureCheckBox;

    MakefileOrConfigurePanel(MakefileOrConfigureDescriptorPanel buildActionsDescriptorPanel) {
        this.initComponents();
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.descriptorPanel = buildActionsDescriptorPanel;
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MakefileOrConfigurePanel.this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MakefileOrConfigurePanel.this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MakefileOrConfigurePanel.this.update(e);
            }
        };
        this.buttonGroup.add(this.makefileRadioButton);
        this.buttonGroup.add(this.configureRadioButton);
        this.makefileNameTextField.requestFocus();
        this.getAccessibleContext().setAccessibleDescription(MakefileOrConfigurePanel.getString("MakefileOrConfigureName_AD"));
        this.makefileNameTextField.getAccessibleContext().setAccessibleDescription(MakefileOrConfigurePanel.getString("MAKEFILE_NAME_AD"));
        this.makefileBrowseButton.getAccessibleContext().setAccessibleDescription(MakefileOrConfigurePanel.getString("MAKEFILE_BROWSE_BUTTON_AD"));
        this.addDocumentLiseners();
    }

    private void addDocumentLiseners() {
        this.makefileNameTextField.getDocument().addDocumentListener(this.documentListener);
        this.configureNameTextField.getDocument().addDocumentListener(this.documentListener);
    }

    private void removeDocumentLiseners() {
        this.makefileNameTextField.getDocument().removeDocumentListener(this.documentListener);
        this.configureNameTextField.getDocument().removeDocumentListener(this.documentListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewMakeWizardP11");
    }

    private void update(DocumentEvent e) {
        this.descriptorPanel.stateChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(WizardDescriptor wizardDescriptor) {
        String hostUID = (String)wizardDescriptor.getProperty("hostUID");
        ExecutionEnvironment ee = null;
        if (hostUID != null) {
            ee = ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
        }
        CompilerSet cs = null;
        if (ee != null) {
            cs = (CompilerSet)wizardDescriptor.getProperty("toolchain");
        }
        try {
            this.removeDocumentLiseners();
            String path = (String)wizardDescriptor.getProperty("simpleModeFolder");
            if (path != null) {
                String configureScript;
                boolean selected = false;
                String makeFile = ConfigureUtils.findMakefile(path);
                if (makeFile != null) {
                    this.makefileNameTextField.setText(makeFile);
                    this.makefileRadioButton.setSelected(true);
                    selected = true;
                }
                if ((configureScript = ConfigureUtils.findConfigureScript(path)) != null) {
                    if (!selected) {
                        this.configureRadioButton.setSelected(true);
                        this.runConfigureCheckBox.setSelected(true);
                    }
                    this.configureNameTextField.setText(configureScript);
                    this.configureArgumentsTextField.setText(ConfigureUtils.getConfigureArguments(ee, cs, configureScript, ""));
                }
            }
        }
        finally {
            this.addDocumentLiseners();
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        if (this.makefileRadioButton.isSelected()) {
            wizardDescriptor.putProperty("makefileName", (Object)this.makefileNameTextField.getText());
            wizardDescriptor.putProperty("configureName", (Object)"");
            wizardDescriptor.putProperty("configureArguments", (Object)"");
            wizardDescriptor.putProperty("makeProject", (Object)(this.makeCheckBox.isSelected() ? "true" : "false"));
            wizardDescriptor.putProperty("runConfigure", (Object)"");
        } else {
            wizardDescriptor.putProperty("makefileName", (Object)this.configureMakefileNameTextField.getText());
            wizardDescriptor.putProperty("configureName", (Object)this.configureNameTextField.getText());
            wizardDescriptor.putProperty("configureArguments", (Object)this.configureArgumentsTextField.getText());
            wizardDescriptor.putProperty("runConfigure", (Object)(this.runConfigureCheckBox.isSelected() ? "true" : "false"));
            wizardDescriptor.putProperty("makeProject", (Object)"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean valid(WizardDescriptor settings) {
        if (this.makefileRadioButton.isSelected()) {
            this.makefileNameLabel.setEnabled(true);
            this.makefileNameTextField.setEnabled(true);
            this.makefileBrowseButton.setEnabled(true);
            this.makeCheckBox.setEnabled(true);
            this.configureNameLabel.setEnabled(false);
            this.configureNameTextField.setEnabled(false);
            this.configureArgumentsLabel.setEnabled(false);
            this.configureBrowseButton.setEnabled(false);
            this.configureArgumentsTextField.setEnabled(false);
            this.configureMakefileNameTextField.setEnabled(false);
            this.configureMakefileNameLabel.setEnabled(false);
            this.runConfigureCheckBox.setEnabled(false);
        } else {
            this.makefileNameLabel.setEnabled(false);
            this.makefileNameTextField.setEnabled(false);
            this.makefileBrowseButton.setEnabled(false);
            this.makeCheckBox.setEnabled(false);
            this.configureNameLabel.setEnabled(true);
            this.configureNameTextField.setEnabled(true);
            this.configureArgumentsLabel.setEnabled(true);
            this.configureBrowseButton.setEnabled(true);
            this.configureArgumentsTextField.setEnabled(true);
            this.configureMakefileNameTextField.setEnabled(true);
            this.configureMakefileNameLabel.setEnabled(true);
            this.runConfigureCheckBox.setEnabled(true);
        }
        try {
            this.removeDocumentLiseners();
            if (this.makefileRadioButton.isSelected()) {
                String cn;
                if (this.makefileNameTextField.getText().isEmpty()) {
                    String msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOMAKEFILE");
                    this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
                    boolean bl = false;
                    return bl;
                }
                if (!CndPathUtilitities.isPathAbsolute((String)this.makefileNameTextField.getText()) || !new File(this.makefileNameTextField.getText()).exists() || new File(this.makefileNameTextField.getText()).isDirectory()) {
                    String msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"MAKEFILEDOESNOTEXIST");
                    this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
                    boolean bl = false;
                    return bl;
                }
                String mn = this.makefileNameTextField.getText();
                int i = mn.replace('\\', '/').lastIndexOf(47);
                if (i > 0 && (cn = ConfigureUtils.findConfigureScript(mn.substring(0, i))) != null && new File(cn).exists()) {
                    this.configureNameTextField.setText(cn);
                }
            } else {
                this.configureMakefileNameTextField.setText("");
                if (this.configureNameTextField.getText().isEmpty()) {
                    String msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOCONFIGUREFILE");
                    this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
                    boolean i = false;
                    return i;
                }
                File file = new File(this.configureNameTextField.getText());
                if (!CndPathUtilitities.isPathAbsolute((String)this.configureNameTextField.getText()) || !file.exists() || file.isDirectory()) {
                    String msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"CONFIGUREFILEDOESNOTEXIST");
                    this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
                    boolean cn = false;
                    return cn;
                }
                if (!ConfigureUtils.isRunnable(file)) {
                    String msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"CONFIGUREFILEISNOTEXECUTABLE");
                    this.descriptorPanel.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
                    boolean cn = false;
                    return cn;
                }
                int i = this.configureNameTextField.getText().replace('\\', '/').lastIndexOf(47);
                if (i > 0) {
                    String mn = this.configureNameTextField.getText().substring(0, i + 1) + "Makefile";
                    this.configureMakefileNameTextField.setText(mn);
                    if (new File(mn).exists()) {
                        this.makefileNameTextField.setText(mn);
                    }
                }
            }
        }
        finally {
            this.addDocumentLiseners();
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.infoLabel = new JLabel();
        this.makefileRadioButton = new JRadioButton();
        this.makefileNameLabel = new JLabel();
        this.makefileNameTextField = new JTextField();
        this.makefileBrowseButton = new JButton();
        this.configureRadioButton = new JRadioButton();
        this.configureNameLabel = new JLabel();
        this.configureNameTextField = new JTextField();
        this.configureBrowseButton = new JButton();
        this.configureArgumentsLabel = new JLabel();
        this.configureArgumentsTextField = new JTextField();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.configureMakefileNameLabel = new JLabel();
        this.configureMakefileNameTextField = new JTextField();
        this.runConfigureCheckBox = new JCheckBox();
        this.makeCheckBox = new JCheckBox();
        this.setPreferredSize(new Dimension(323, 223));
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.infoLabel.setText(bundle.getString("INTRO_LABEL_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.infoLabel, gridBagConstraints);
        this.makefileRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MAKEFILE_RADIO_BUTTON_MN").charAt(0));
        this.makefileRadioButton.setSelected(true);
        this.makefileRadioButton.setText(bundle.getString("MAKEFILE_RADIO_BUTTON_TXT"));
        this.makefileRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.makefileRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakefileOrConfigurePanel.this.makefileRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.makefileRadioButton, gridBagConstraints);
        this.makefileRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakefileOrConfigurePanel.class, (String)"MAKEFILE_RADIO_BUTTON_AD"));
        this.makefileNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MAKEFILE_NAME_MN").charAt(0));
        this.makefileNameLabel.setLabelFor(this.makefileNameTextField);
        this.makefileNameLabel.setText(bundle.getString("MAKEFILE_NAME_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.makefileNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.makefileNameTextField, gridBagConstraints);
        this.makefileBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MAKEFILE_BROWSE_BUTTON_MN").charAt(0));
        this.makefileBrowseButton.setText(bundle.getString("MAKEFILE_BROWSE_BUTTON"));
        this.makefileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakefileOrConfigurePanel.this.makefileBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.makefileBrowseButton, gridBagConstraints);
        this.configureRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_RADIO_BUTTON_MN").charAt(0));
        this.configureRadioButton.setText(bundle.getString("CONFIGURE_RADIO_BUTTON_TXT"));
        this.configureRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.configureRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakefileOrConfigurePanel.this.configureRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.configureRadioButton, gridBagConstraints);
        this.configureRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakefileOrConfigurePanel.class, (String)"CONFIGURE_RADIO_BUTTON_AD"));
        this.configureNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_NAME_MN").charAt(0));
        this.configureNameLabel.setLabelFor(this.configureNameTextField);
        this.configureNameLabel.setText(bundle.getString("CONFIGURE_NAME_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.configureNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.configureNameTextField, gridBagConstraints);
        this.configureBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_BROWSE_BUTTON_MN").charAt(0));
        this.configureBrowseButton.setText(bundle.getString("CONFIGURE_BROWSE_BUTTON"));
        this.configureBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MakefileOrConfigurePanel.this.configureBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.configureBrowseButton, gridBagConstraints);
        this.configureArgumentsLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_ARGUMENT_LABEL_MN").charAt(0));
        this.configureArgumentsLabel.setLabelFor(this.configureArgumentsTextField);
        this.configureArgumentsLabel.setText(bundle.getString("CONFIGURE_ARGUMENT_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.add((Component)this.configureArgumentsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.configureArgumentsTextField, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(bundle.getString("MakefileOrConfigureInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.instructionsTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MakefileOrConfigurePanel.class, (String)"CONFIGURE_HELP"));
        this.instructionsTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakefileOrConfigurePanel.class, (String)"CONFIGURE_HELP_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.configureMakefileNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("CONFIGURE_MAKEFILE_NAME_MN").charAt(0));
        this.configureMakefileNameLabel.setLabelFor(this.configureMakefileNameTextField);
        this.configureMakefileNameLabel.setText(bundle.getString("CONFIGURE_MAKEFILE_NAME_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.configureMakefileNameLabel, gridBagConstraints);
        this.configureMakefileNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.configureMakefileNameTextField, gridBagConstraints);
        this.runConfigureCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("RUN_CONFIGURE_CHECKBOX").charAt(0));
        this.runConfigureCheckBox.setSelected(true);
        this.runConfigureCheckBox.setText(bundle.getString("RUN_CONFIGURE_CHECKBOX"));
        this.runConfigureCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 16, 0, 0);
        this.add((Component)this.runConfigureCheckBox, gridBagConstraints);
        this.makeCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.makeCheckBox, (String)bundle.getString("CLEAN_BUILD_CHECKBOX"));
        this.makeCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 16, 0, 0);
        this.add((Component)this.makeCheckBox, gridBagConstraints);
    }

    private void configureRadioButtonActionPerformed(ActionEvent evt) {
        this.descriptorPanel.stateChanged(null);
    }

    private void makefileRadioButtonActionPerformed(ActionEvent evt) {
        this.descriptorPanel.stateChanged(null);
    }

    private void configureBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = null;
        seed = this.makefileNameTextField.getText().length() > 0 ? this.makefileNameTextField.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileChooser fileChooser = new FileChooser(MakefileOrConfigurePanel.getString("CONFIGURE_CHOOSER_TITLE_TXT"), MakefileOrConfigurePanel.getString("MAKEFILE_CHOOSER_BUTTON_TXT"), 0, new FileFilter[]{FileFilterFactory.getConfigureFileFilter()}, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = CndPathUtilitities.normalize((String)path);
        this.configureNameTextField.setText(path);
    }

    private void makefileBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = null;
        seed = this.makefileNameTextField.getText().length() > 0 ? this.makefileNameTextField.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
        FileChooser fileChooser = new FileChooser(MakefileOrConfigurePanel.getString("MAKEFILE_CHOOSER_TITLE_TXT"), MakefileOrConfigurePanel.getString("MAKEFILE_CHOOSER_BUTTON_TXT"), 0, new FileFilter[]{FileFilterFactory.getMakefileFileFilter()}, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = CndPathUtilitities.normalize((String)path);
        this.makefileNameTextField.setText(path);
    }

    private static String getString(String s) {
        return NbBundle.getBundle(BuildActionsPanel.class).getString(s);
    }
}

