/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc10;

import java.util.Date;
import java.util.Vector;
import jmunit.framework.cldc10.AssertionFailedException;
import jmunit.framework.cldc10.GuiListener;
import jmunit.framework.cldc10.Test;
import jmunit.framework.cldc10.TestListener;
import jmunit.framework.cldc10.TestResult;

public abstract class TestRunner
extends Test {
    private int delay;

    public TestRunner(int n) {
        this("TestRunner", n);
    }

    public TestRunner(String string, int n) {
        super(string);
        if (n > 0) {
            this.delay = n;
        }
    }

    protected abstract Test getNestedTest();

    public void doStart() {
        new Thread(new Runnable(){

            public void run() {
                TestRunner.this.test();
                try {
                    Thread.sleep(TestRunner.this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TestRunner.this.notifyDestroyed();
            }
        }).start();
    }

    public int countTestCases() {
        return this.getNestedTest().countTestCases();
    }

    public void run(TestResult testResult) {
        testResult.removeListeners();
        testResult.addListener(new GuiListener(this));
        testResult.addListener(new XmlTestResultsListener(this));
        testResult.clear();
        this.getNestedTest().run(testResult);
    }

    private static class XmlTestResultsListener
    implements TestListener {
        private Test test;
        private int numCompletedTests;
        private Vector xmlElements;
        private Throwable t;
        private long testCaseStartTime;
        private long testSuiteStartTime;
        private int numErrors;
        private int numFailures;

        public XmlTestResultsListener(Test test) {
            this.test = test;
            this.testSuiteStartTime = System.currentTimeMillis();
            this.xmlElements = new Vector();
        }

        public void addError(Class clazz, String string, Throwable throwable) {
            this.t = throwable;
            ++this.numErrors;
        }

        public void addFailure(Class clazz, String string, AssertionFailedException assertionFailedException) {
            this.t = assertionFailedException;
            ++this.numFailures;
        }

        public void clear() {
            this.xmlElements.removeAllElements();
            this.testSuiteStartTime = System.currentTimeMillis();
            this.numErrors = 0;
            this.numFailures = 0;
        }

        private String convertTimeToString(long l) {
            String string = "" + l;
            while (string.length() < 4) {
                string = "0" + string;
            }
            string = string.substring(0, string.length() - 3) + "." + string.substring(string.length() - 3);
            return string;
        }

        public void endTest(Class clazz, String string) {
            long l = System.currentTimeMillis() - this.testCaseStartTime;
            String string2 = "<testcase classname=\"" + clazz.getName() + "\" name=\"" + string + "\" time=\"" + this.convertTimeToString(l) + "\">";
            this.xmlElements.addElement(string2);
            if (this.t != null) {
                this.xmlElements.addElement(this.t);
            }
            this.xmlElements.addElement("</testcase>");
            ++this.numCompletedTests;
            if (this.numCompletedTests == this.test.countTestCases()) {
                this.xmlElements.insertElementAt("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", 0);
                long l2 = System.currentTimeMillis() - this.testSuiteStartTime;
                String string3 = "<testsuite errors=\"" + this.numErrors + "\" failures=\"" + this.numFailures + "\" name=\"" + this.test.name + "\" tests=\"" + this.test.countTestCases() + "\" time=\"" + this.convertTimeToString(l2) + "\" timestamp=\"" + new Date() + "\">";
                this.xmlElements.insertElementAt(string3, 1);
                this.xmlElements.addElement("</testsuite>");
                System.out.println("<XmlTestResultsListener>");
                for (int i = 0; i < this.xmlElements.size(); ++i) {
                    Object e = this.xmlElements.elementAt(i);
                    if (e instanceof Throwable) {
                        Throwable throwable = (Throwable)e;
                        String string4 = throwable instanceof AssertionFailedException ? "failure" : "error";
                        System.out.println("<" + string4 + ">");
                        throwable.printStackTrace();
                        System.out.println("</" + string4 + ">");
                        continue;
                    }
                    System.out.println(e);
                }
                System.out.println("</XmlTestResultsListener>");
            }
        }

        public void startTest(Class clazz, String string) {
            this.testCaseStartTime = System.currentTimeMillis();
            this.t = null;
        }
    }
}

