/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.FixData;
import org.netbeans.modules.editor.hints.ParseErrorAnnotation;
import org.netbeans.spi.editor.highlighting.HighlightAttributeValue;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class AnnotationHolder
implements ChangeListener,
PropertyChangeListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(AnnotationHolder.class.getName());
    static final Map<Severity, AttributeSet> COLORINGS = new EnumMap<Severity, AttributeSet>(Severity.class);
    private Map<ErrorDescription, List<Position>> errors2Lines;
    private Map<Position, List<ErrorDescription>> line2Errors;
    private Map<Position, ParseErrorAnnotation> line2Annotations;
    private Map<String, List<ErrorDescription>> layer2Errors;
    private Set<JEditorPane> openedComponents;
    private EditorCookie.Observable editorCookie;
    private FileObject file;
    private DataObject od;
    private BaseDocument doc;
    private static Map<DataObject, AnnotationHolder> file2Holder;
    Attacher attacher = new NbDocumentAttacher();
    private List<Reference<Position>> knownPositions = new ArrayList<Reference<Position>>();
    private static RuntimeException ABORT;
    private static final RequestProcessor INSTANCE;

    public static synchronized AnnotationHolder getInstance(FileObject file) {
        if (file == null) {
            return null;
        }
        try {
            DataObject od = DataObject.find((FileObject)file);
            AnnotationHolder result = file2Holder.get(od);
            if (result == null) {
                EditorCookie.Observable editorCookie = (EditorCookie.Observable)od.getCookie(EditorCookie.Observable.class);
                if (editorCookie == null) {
                    LOG.log(Level.WARNING, "No EditorCookie.Observable for file: " + FileUtil.getFileDisplayName((FileObject)file));
                } else {
                    StyledDocument doc = editorCookie.getDocument();
                    if (doc instanceof BaseDocument) {
                        result = new AnnotationHolder(file, od, (BaseDocument)doc, editorCookie);
                        file2Holder.put(od, result);
                    }
                }
            }
            return result;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
            return null;
        }
    }

    private AnnotationHolder(FileObject file, DataObject od, BaseDocument doc, EditorCookie.Observable editorCookie) {
        if (file == null) {
            return;
        }
        this.init();
        this.file = file;
        this.od = od;
        this.doc = doc;
        AnnotationHolder.getBag((Document)doc);
        this.doc.addDocumentListener((DocumentListener)this);
        editorCookie.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)editorCookie));
        this.editorCookie = editorCookie;
        this.propertyChange(null);
        Logger.getLogger("TIMER").log(Level.FINE, "Annotation Holder", new Object[]{file, this});
    }

    private synchronized void init() {
        this.errors2Lines = new IdentityHashMap<ErrorDescription, List<Position>>();
        this.line2Errors = new HashMap<Position, List<ErrorDescription>>();
        this.line2Annotations = new HashMap<Position, ParseErrorAnnotation>();
        this.layer2Errors = new HashMap<String, List<ErrorDescription>>();
        this.openedComponents = new HashSet<JEditorPane>();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.updateVisibleRanges();
    }

    void attachAnnotation(Position line, ParseErrorAnnotation a) throws BadLocationException {
        this.attacher.attachAnnotation(line, a);
    }

    void detachAnnotation(Annotation a) {
        this.attacher.detachAnnotation(a);
    }

    private synchronized void clearAll() {
        for (ParseErrorAnnotation a : this.line2Annotations.values()) {
            this.detachAnnotation(a);
        }
        file2Holder.remove(this.od);
        this.doc.removeDocumentListener((DocumentListener)this);
        AnnotationHolder.getBag((Document)this.doc).clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JEditorPane[] panes = AnnotationHolder.this.editorCookie.getOpenedPanes();
                if (panes == null) {
                    AnnotationHolder.this.clearAll();
                    return;
                }
                HashSet<JEditorPane> addedPanes = new HashSet<JEditorPane>(Arrays.asList(panes));
                HashSet removedPanes = new HashSet(AnnotationHolder.this.openedComponents);
                removedPanes.removeAll(addedPanes);
                addedPanes.removeAll(AnnotationHolder.this.openedComponents);
                for (JEditorPane pane : addedPanes) {
                    Container parent = pane.getParent();
                    if (!(parent instanceof JViewport)) continue;
                    JViewport viewport = (JViewport)parent;
                    viewport.addChangeListener(WeakListeners.change((ChangeListener)AnnotationHolder.this, (Object)viewport));
                }
                AnnotationHolder.this.openedComponents.removeAll(removedPanes);
                AnnotationHolder.this.openedComponents.addAll(addedPanes);
                AnnotationHolder.this.updateVisibleRanges();
            }
        });
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        try {
            int offset = Utilities.getRowStart((BaseDocument)this.doc, (int)e.getOffset());
            HashSet<Position> modifiedLines = new HashSet<Position>();
            int index = this.findPositionGE(offset);
            if (index == this.knownPositions.size()) {
                return;
            }
            Position line = this.knownPositions.get(index).get();
            if (line == null) {
                return;
            }
            List<ErrorDescription> eds = this.getErrorsForLine(line, false);
            if (eds == null) {
                return;
            }
            eds = new LinkedList<ErrorDescription>(eds);
            for (ErrorDescription ed : eds) {
                for (Position position : this.errors2Lines.remove(ed)) {
                    this.line2Errors.get(position).remove(ed);
                    modifiedLines.add(position);
                }
                for (List list : this.layer2Errors.values()) {
                    list.remove(ed);
                }
            }
            this.line2Errors.remove(line);
            try {
                int rowStart = e.getOffset();
                int rowEnd = Utilities.getRowEnd((BaseDocument)this.doc, (int)(e.getOffset() + e.getLength()));
                AnnotationHolder.getBag((Document)this.doc).removeHighlights(rowStart, rowEnd, false);
            }
            catch (BadLocationException ex) {
                throw (IOException)new IOException().initCause(ex);
            }
            for (Position lineToken : modifiedLines) {
                this.updateAnnotationOnLine(lineToken);
                this.updateHighlightsOnLine(lineToken);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        try {
            Position current = null;
            int index = -1;
            int startOffset = Utilities.getRowStart((BaseDocument)this.doc, (int)e.getOffset());
            while (current == null) {
                index = this.findPositionGE(startOffset);
                if (this.knownPositions.size() == 0) break;
                if (index == this.knownPositions.size()) {
                    return;
                }
                current = this.knownPositions.get(index).get();
            }
            if (current == null) {
                return;
            }
            assert (index != -1);
            while (index > 0) {
                Position minusOne = this.knownPositions.get(index - 1).get();
                if (minusOne == null) {
                    --index;
                    continue;
                }
                if (minusOne.getOffset() != current.getOffset()) break;
                --index;
            }
            HashSet<Position> modifiedLinesTokens = new HashSet<Position>();
            while (index < this.knownPositions.size()) {
                Position next = this.knownPositions.get(index).get();
                if (next == null) {
                    ++index;
                    continue;
                }
                if (next.getOffset() != current.getOffset()) break;
                modifiedLinesTokens.add(next);
                ++index;
            }
            for (Position line : new LinkedList(modifiedLinesTokens)) {
                List<ErrorDescription> eds = this.line2Errors.get(line);
                if (eds == null || eds.isEmpty()) continue;
                eds = new LinkedList<ErrorDescription>(eds);
                for (ErrorDescription ed : eds) {
                    for (Position position : this.errors2Lines.remove(ed)) {
                        this.line2Errors.get(position).remove(ed);
                        modifiedLinesTokens.add(position);
                    }
                    for (List list : this.layer2Errors.values()) {
                        list.remove(ed);
                    }
                }
                this.line2Errors.remove(line);
            }
            for (Position line : modifiedLinesTokens) {
                this.updateAnnotationOnLine(line);
                this.updateHighlightsOnLine(line);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void updateVisibleRanges() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                final ArrayList visibleRanges = new ArrayList();
                AnnotationHolder.this.doc.render(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AnnotationHolder annotationHolder = AnnotationHolder.this;
                        synchronized (annotationHolder) {
                            for (JEditorPane pane : AnnotationHolder.this.openedComponents) {
                                Container parent = pane.getParent();
                                if (!(parent instanceof JViewport)) continue;
                                JViewport viewport = (JViewport)parent;
                                Point start = viewport.getViewPosition();
                                Dimension size = viewport.getExtentSize();
                                Point end = new Point(start.x + size.width, start.y + size.height);
                                int startPosition = pane.viewToModel(start);
                                int endPosition = pane.viewToModel(end);
                                visibleRanges.add(new int[]{startPosition, endPosition});
                            }
                        }
                    }
                });
                INSTANCE.post(new Runnable(){

                    @Override
                    public void run() {
                        for (int[] span : visibleRanges) {
                            AnnotationHolder.this.updateAnnotations(span[0], span[1]);
                        }
                    }
                });
                long endTime = System.currentTimeMillis();
                LOG.log(Level.FINE, "updateVisibleRanges: time={0}", endTime - startTime);
            }
        });
    }

    private void updateAnnotations(final int startPosition, final int endPosition) {
        long startTime = System.currentTimeMillis();
        final ArrayList errorsToUpdate = new ArrayList();
        this.doc.render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        int end;
                        if (AnnotationHolder.this.doc.getLength() == 0) {
                            return;
                        }
                        int start = startPosition < AnnotationHolder.this.doc.getLength() ? startPosition : AnnotationHolder.this.doc.getLength() - 1;
                        int n = end = endPosition < AnnotationHolder.this.doc.getLength() ? endPosition : AnnotationHolder.this.doc.getLength() - 1;
                        if (start < 0) {
                            start = 0;
                        }
                        if (end < 0) {
                            end = 0;
                        }
                        int startLine = Utilities.getRowStart((BaseDocument)AnnotationHolder.this.doc, (int)start);
                        int endLine = Utilities.getRowEnd((BaseDocument)AnnotationHolder.this.doc, (int)end) + 1;
                        int index = AnnotationHolder.this.findPositionGE(startLine);
                        while (index < AnnotationHolder.this.knownPositions.size()) {
                            Position lineToken;
                            Reference r = (Reference)AnnotationHolder.this.knownPositions.get(index++);
                            if (r == null || (lineToken = (Position)r.get()) == null) continue;
                            if (lineToken.getOffset() <= endLine) {
                                List errors = (List)AnnotationHolder.this.line2Errors.get(lineToken);
                                if (errors == null) continue;
                                errorsToUpdate.addAll(errors);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            }
        });
        LOG.log(Level.FINE, "updateAnnotations: errorsToUpdate={0}", errorsToUpdate);
        for (ErrorDescription e : errorsToUpdate) {
            LazyFixList l;
            if (e == null || !(l = e.getFixes()).probablyContainsFixes() || l.isComputed()) continue;
            l.getFixes();
        }
        long endTime = System.currentTimeMillis();
        LOG.log(Level.FINE, "updateAnnotations: time={0}", endTime - startTime);
    }

    private List<ErrorDescription> getErrorsForLayer(String layer) {
        List<ErrorDescription> errors = this.layer2Errors.get(layer);
        if (errors == null) {
            errors = new ArrayList<ErrorDescription>();
            this.layer2Errors.put(layer, errors);
        }
        return errors;
    }

    private List<ErrorDescription> getErrorsForLine(Position line, boolean create) {
        List<ErrorDescription> errors = this.line2Errors.get(line);
        if (errors == null && create) {
            errors = new ArrayList<ErrorDescription>();
            this.line2Errors.put(line, errors);
        }
        if (errors != null && errors.isEmpty() && !create) {
            this.line2Errors.remove(line);
            errors = null;
        }
        return errors;
    }

    private static List<ErrorDescription> filter(List<ErrorDescription> errors, boolean onlyErrors) {
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        for (ErrorDescription e : errors) {
            if (e.getSeverity() == Severity.ERROR) {
                if (!onlyErrors) continue;
                result.add(e);
                continue;
            }
            if (onlyErrors) continue;
            result.add(e);
        }
        return result;
    }

    private static void concatDescription(List<ErrorDescription> errors, StringBuffer description) {
        boolean first = true;
        for (ErrorDescription e : errors) {
            if (!first) {
                description.append("\n\n");
            }
            description.append(e.getDescription());
            first = false;
        }
    }

    private LazyFixList computeFixes(List<ErrorDescription> errors) {
        ArrayList<LazyFixList> result = new ArrayList<LazyFixList>();
        for (ErrorDescription e : errors) {
            result.add(e.getFixes());
        }
        return ErrorDescriptionFactory.lazyListForDelegates(result);
    }

    private void updateAnnotationOnLine(Position line) throws BadLocationException {
        Severity mostImportantSeverity;
        List<ErrorDescription> errorDescriptions = this.getErrorsForLine(line, false);
        if (errorDescriptions == null) {
            Annotation ann = this.line2Annotations.remove(line);
            this.detachAnnotation(ann);
            return;
        }
        errorDescriptions = this.getErrorsForLine(line, true);
        List<ErrorDescription> trueErrors = AnnotationHolder.filter(errorDescriptions, true);
        List<ErrorDescription> others = AnnotationHolder.filter(errorDescriptions, false);
        boolean hasErrors = !trueErrors.isEmpty();
        StringBuffer description = new StringBuffer();
        AnnotationHolder.concatDescription(trueErrors, description);
        if (!trueErrors.isEmpty() && !others.isEmpty()) {
            description.append("\n\n");
        }
        AnnotationHolder.concatDescription(others, description);
        if (hasErrors) {
            mostImportantSeverity = Severity.ERROR;
        } else {
            mostImportantSeverity = Severity.HINT;
            for (ErrorDescription e : others) {
                if (mostImportantSeverity.compareTo(e.getSeverity()) <= 0) continue;
                mostImportantSeverity = e.getSeverity();
            }
        }
        FixData fixes = new FixData(this.computeFixes(trueErrors), this.computeFixes(others));
        ParseErrorAnnotation pea = new ParseErrorAnnotation(mostImportantSeverity, fixes, description.toString(), line, this);
        Annotation previous = this.line2Annotations.put(line, pea);
        if (previous != null) {
            this.detachAnnotation(previous);
        }
        this.attachAnnotation(line, pea);
    }

    void updateHighlightsOnLine(Position line) throws IOException {
        List<ErrorDescription> errorDescriptions = this.getErrorsForLine(line, false);
        OffsetsBag bag = AnnotationHolder.getBag((Document)this.doc);
        AnnotationHolder.updateHighlightsOnLine(bag, this.doc, line, errorDescriptions);
    }

    static void updateHighlightsOnLine(OffsetsBag bag, BaseDocument doc, Position line, List<ErrorDescription> errorDescriptions) throws IOException {
        try {
            int rowStart = line.getOffset();
            int rowEnd = Utilities.getRowEnd((BaseDocument)doc, (int)rowStart);
            int rowHighlightStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)rowStart);
            int rowHighlightEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)rowStart) + 1;
            bag.removeHighlights(rowStart, rowEnd, false);
            if (errorDescriptions != null) {
                bag.addAllHighlights(AnnotationHolder.computeHighlights((Document)doc, errorDescriptions).getHighlights(rowHighlightStart, rowHighlightEnd));
            }
        }
        catch (BadLocationException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static OffsetsBag computeHighlights(Document doc, List<ErrorDescription> errorDescriptions) throws IOException, BadLocationException {
        OffsetsBag bag = new OffsetsBag(doc);
        Iterator<Severity> i$ = Arrays.asList(Severity.VERIFIER, Severity.WARNING, Severity.ERROR).iterator();
        block6: while (i$.hasNext()) {
            Severity s = i$.next();
            ArrayList<ErrorDescription> filteredDescriptions = new ArrayList<ErrorDescription>();
            for (ErrorDescription e : errorDescriptions) {
                if (e.getSeverity() != s) continue;
                filteredDescriptions.add(e);
            }
            ArrayList<int[]> currentHighlights = new ArrayList<int[]>();
            Iterator i$2 = filteredDescriptions.iterator();
            while (true) {
                if (!i$2.hasNext()) break;
                ErrorDescription e = (ErrorDescription)i$2.next();
                int beginOffset = e.getRange().getBegin().getPosition().getOffset();
                int endOffset = e.getRange().getEnd().getPosition().getOffset();
                if (endOffset < beginOffset) {
                    int swap = endOffset;
                    endOffset = beginOffset;
                    beginOffset = swap;
                    LOG.warning("Incorrect highlight in ErrorDescription, attach your messages.log to issue #112566: " + e.toString());
                }
                int[] h = new int[]{beginOffset, endOffset};
                Iterator it = currentHighlights.iterator();
                block9: while (it.hasNext() && h != null) {
                    int[] hl = (int[])it.next();
                    switch (AnnotationHolder.detectCollisions(hl, h)) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            it.remove();
                            break;
                        }
                        case 2: {
                            h = null;
                            break block9;
                        }
                        case 3: 
                        case 4: {
                            int start = Math.min(hl[0], h[0]);
                            int end = Math.max(hl[1], h[1]);
                            h = new int[]{start, end};
                            it.remove();
                        }
                    }
                }
                if (h == null) continue;
                currentHighlights.add(h);
            }
            i$2 = currentHighlights.iterator();
            while (true) {
                if (!i$2.hasNext()) continue block6;
                int[] h = (int[])i$2.next();
                if (h[0] <= h[1]) {
                    bag.addHighlight(h[0], h[1], COLORINGS.get((Object)s));
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                for (ErrorDescription e : filteredDescriptions) {
                    sb.append("[");
                    sb.append(e.getRange().getBegin().getOffset());
                    sb.append("-");
                    sb.append(e.getRange().getEnd().getOffset());
                    sb.append("]");
                }
                sb.append("=>");
                for (int[] h2 : currentHighlights) {
                    sb.append("[");
                    sb.append(h2[0]);
                    sb.append("-");
                    sb.append(h2[1]);
                    sb.append("]");
                }
                LOG.warning("Incorrect highlight computed, please reopen issue #112566 and attach the following output: " + sb.toString());
            }
            break;
        }
        return bag;
    }

    private static int detectCollisions(int[] h1, int[] h2) {
        if (h2[1] < h1[0]) {
            return 0;
        }
        if (h1[1] < h2[0]) {
            return 0;
        }
        if (h2[0] < h1[0] && h2[1] > h1[1]) {
            return 1;
        }
        if (h1[0] < h2[0] && h1[1] > h2[1]) {
            return 2;
        }
        if (h1[0] < h2[0]) {
            return 3;
        }
        return 4;
    }

    public void setErrorDescriptions(final String layer, final Collection<? extends ErrorDescription> errors) {
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    AnnotationHolder.this.setErrorDescriptionsImpl(AnnotationHolder.this.file, layer, errors);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                }
            }
        });
    }

    private synchronized void setErrorDescriptionsImpl(FileObject file, String layer, Collection<? extends ErrorDescription> errors) throws IOException {
        long start;
        block17: {
            start = System.currentTimeMillis();
            if (file != null) break block17;
            long end = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + layer, new Object[]{file, end - start});
            return;
        }
        try {
            List<ErrorDescription> layersErrors = this.getErrorsForLayer(layer);
            HashSet<Position> primaryLines = new HashSet<Position>();
            HashSet<Position> allLines = new HashSet<Position>();
            for (ErrorDescription ed : layersErrors) {
                List<Position> list = this.errors2Lines.remove(ed);
                if (list == null) {
                    LOG.log(Level.WARNING, "Inconsistent error2Lines for layer {0}, file {1}.", new Object[]{layer, file.getPath()});
                    continue;
                }
                boolean first = true;
                for (Position line : list) {
                    List<ErrorDescription> errorsForLine = this.getErrorsForLine(line, false);
                    if (errorsForLine != null) {
                        errorsForLine.remove(ed);
                    }
                    if (first) {
                        primaryLines.add(line);
                    }
                    allLines.add(line);
                    first = false;
                }
            }
            ArrayList<ErrorDescription> validatedErrors = new ArrayList<ErrorDescription>();
            for (ErrorDescription errorDescription : errors) {
                if (errorDescription == null) {
                    LOG.log(Level.WARNING, "'null' ErrorDescription in layer {0}.", layer);
                    continue;
                }
                if (errorDescription.getRange() == null) continue;
                validatedErrors.add(errorDescription);
                ArrayList<Position> lines = new ArrayList<Position>();
                int startLine = errorDescription.getRange().getBegin().getLine();
                int endLine = errorDescription.getRange().getEnd().getLine();
                for (int cntr = startLine; cntr <= endLine; ++cntr) {
                    Position p = this.getPosition(cntr, true);
                    lines.add(p);
                }
                this.errors2Lines.put(errorDescription, lines);
                boolean first = true;
                for (Position line : lines) {
                    this.getErrorsForLine(line, true).add(errorDescription);
                    if (first) {
                        primaryLines.add(line);
                    }
                    allLines.add(line);
                    first = false;
                }
            }
            layersErrors.clear();
            layersErrors.addAll(validatedErrors);
            for (Position position : primaryLines) {
                this.updateAnnotationOnLine(position);
            }
            for (Position position : allLines) {
                this.updateHighlightsOnLine(position);
            }
            this.updateVisibleRanges();
        }
        catch (BadLocationException ex) {
            try {
                throw (IOException)new IOException().initCause(ex);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + layer, new Object[]{file, end - start});
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Errors update for " + layer, new Object[]{file, end - start});
    }

    private synchronized int findPositionGE(int offset) {
        while (true) {
            try {
                int index = Collections.binarySearch(this.knownPositions, offset, new PositionComparator());
                if (index >= 0) {
                    return index;
                }
                return -(index + 1);
            }
            catch (Abort a) {
                LOG.log(Level.FINE, "a null Position detected - clearing");
                int removedCount = 0;
                Iterator<Reference<Position>> it = this.knownPositions.iterator();
                while (it.hasNext()) {
                    if (it.next().get() != null) continue;
                    ++removedCount;
                    it.remove();
                }
                LOG.log(Level.FINE, "clearing finished, {0} positions cleared", removedCount);
                continue;
            }
            break;
        }
    }

    private synchronized Position getPosition(int lineNumber, boolean create) throws BadLocationException {
        while (true) {
            Position p;
            int index;
            int lineStart;
            block11: {
                lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)this.doc, (int)lineNumber);
                try {
                    Reference<Position> r;
                    index = Collections.binarySearch(this.knownPositions, lineStart, new PositionComparator());
                    if (index >= 0 && (p = (r = this.knownPositions.get(index)).get()) != null) {
                        Position position = p;
                        return position;
                    }
                    if (create) break block11;
                    r = null;
                    return r;
                }
                catch (Abort a) {
                    LOG.log(Level.FINE, "a null Position detected - clearing");
                    int removedCount = 0;
                    Iterator<Reference<Position>> it = this.knownPositions.iterator();
                    while (it.hasNext()) {
                        if (it.next().get() != null) continue;
                        ++removedCount;
                        it.remove();
                    }
                    LOG.log(Level.FINE, "clearing finished, {0} positions cleared", removedCount);
                    continue;
                }
            }
            Position p2 = NbDocument.createPosition((Document)this.doc, (int)lineStart, (Position.Bias)Position.Bias.Forward);
            this.knownPositions.add(-(index + 1), new WeakReference<Position>(p2));
            Logger.getLogger("TIMER").log(Level.FINE, "Annotation Holder - Line Token", new Object[]{this.file, p2});
            p = p2;
            return p;
            break;
        }
        finally {
            LOG.log(Level.FINE, "knownPositions.size={0}", this.knownPositions.size());
        }
    }

    public synchronized boolean hasErrors() {
        for (ErrorDescription e : this.errors2Lines.keySet()) {
            if (e.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public synchronized List<ErrorDescription> getErrors() {
        return new ArrayList<ErrorDescription>(this.errors2Lines.keySet());
    }

    public synchronized List<Annotation> getAnnotations() {
        return new ArrayList<Annotation>(this.line2Annotations.values());
    }

    public void setErrorsForLine(final int offset, final Map<String, List<ErrorDescription>> errs) {
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    Position pos = AnnotationHolder.this.getPosition(Utilities.getLineOffset((BaseDocument)AnnotationHolder.this.doc, (int)offset), true);
                    List errsForCurrentLine = AnnotationHolder.this.getErrorsForLine(pos, true);
                    for (Map.Entry e : errs.entrySet()) {
                        HashSet errorsForLayer = new HashSet(AnnotationHolder.this.getErrorsForLayer((String)e.getKey()));
                        errorsForLayer.removeAll(errsForCurrentLine);
                        HashSet toSet = new HashSet();
                        toSet.addAll((Collection)e.getValue());
                        toSet.addAll(errorsForLayer);
                        ((List)e.getValue()).clear();
                        ((List)e.getValue()).addAll(toSet);
                    }
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        for (Map.Entry<String, List<ErrorDescription>> e : errs.entrySet()) {
            List<ErrorDescription> eds = e.getValue();
            this.setErrorDescriptions(e.getKey(), eds);
        }
    }

    public synchronized List<ErrorDescription> getErrorsGE(int offset) {
        try {
            Position current = null;
            int index = -1;
            int startOffset = Utilities.getRowStart((BaseDocument)this.doc, (int)offset);
            while (current == null) {
                index = this.findPositionGE(startOffset);
                if (this.knownPositions.size() == 0) break;
                if (index == this.knownPositions.size()) {
                    return Collections.emptyList();
                }
                current = this.knownPositions.get(index).get();
            }
            if (current == null) {
                return Collections.emptyList();
            }
            assert (index != -1);
            List<ErrorDescription> errors = this.line2Errors.get(current);
            if (errors != null) {
                TreeMap<Integer, LinkedList<ErrorDescription>> sortedErrors = new TreeMap<Integer, LinkedList<ErrorDescription>>();
                for (ErrorDescription ed : errors) {
                    LinkedList<ErrorDescription> errs = (LinkedList<ErrorDescription>)sortedErrors.get(ed.getRange().getBegin().getOffset());
                    if (errs == null) {
                        errs = new LinkedList<ErrorDescription>();
                        sortedErrors.put(ed.getRange().getBegin().getOffset(), errs);
                    }
                    errs.add(ed);
                }
                SortedMap tail = sortedErrors.tailMap(offset);
                if (!tail.isEmpty()) {
                    Integer k = tail.firstKey();
                    return new LinkedList<ErrorDescription>((Collection)sortedErrors.get(k));
                }
            }
            int endOffset = Utilities.getRowEnd((BaseDocument)this.doc, (int)offset);
            return this.getErrorsGE(endOffset + 1);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public static OffsetsBag getBag(Document doc) {
        OffsetsBag ob = (OffsetsBag)doc.getProperty(AnnotationHolder.class);
        if (ob == null) {
            ob = new OffsetsBag(doc);
            doc.putProperty(AnnotationHolder.class, ob);
        }
        return ob;
    }

    public int lineNumber(final Position offset) {
        final int[] result = new int[]{-1};
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = Utilities.getLineOffset((BaseDocument)AnnotationHolder.this.doc, (int)offset.getOffset());
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        return result[0];
    }

    static {
        COLORINGS.put(Severity.ERROR, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, new Color(255, 0, 0), EditorStyleConstants.Tooltip, new TooltipResolver()}));
        COLORINGS.put(Severity.WARNING, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, new Color(192, 192, 0), EditorStyleConstants.Tooltip, new TooltipResolver()}));
        COLORINGS.put(Severity.VERIFIER, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, new Color(255, 213, 85), EditorStyleConstants.Tooltip, new TooltipResolver()}));
        COLORINGS.put(Severity.HINT, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, new TooltipResolver()}));
        file2Holder = new HashMap<DataObject, AnnotationHolder>();
        ABORT = new Abort();
        INSTANCE = new RequestProcessor("AnnotationHolder");
    }

    private static final class TooltipResolver
    implements HighlightAttributeValue<String> {
        private TooltipResolver() {
        }

        public String getValue(JTextComponent component, final Document document, Object attributeKey, final int startOffset, final int endOffset) {
            final Object source = document.getProperty("stream");
            if (!(source instanceof DataObject) || !(document instanceof BaseDocument)) {
                return null;
            }
            final String[] result = new String[1];
            document.render(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        int lineNumber = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)startOffset);
                        if (lineNumber < 0) {
                            return;
                        }
                        AnnotationHolder h = AnnotationHolder.getInstance(((DataObject)source).getPrimaryFile());
                        if (h == null) {
                            LOG.log(Level.INFO, "File: " + ((DataObject)source).getPrimaryFile().getPath() + "\nStartOffset: " + startOffset);
                            return;
                        }
                        AnnotationHolder annotationHolder = h;
                        synchronized (annotationHolder) {
                            Position p = h.getPosition(lineNumber, false);
                            if (p == null) {
                                return;
                            }
                            List errors = (List)h.line2Errors.get(p);
                            if (errors == null || errors.isEmpty()) {
                                return;
                            }
                            LinkedList<ErrorDescription> trueErrors = new LinkedList<ErrorDescription>();
                            LinkedList<ErrorDescription> others = new LinkedList<ErrorDescription>();
                            for (ErrorDescription ed : errors) {
                                PositionBounds pb;
                                if (ed == null || startOffset > (pb = ed.getRange()).getEnd().getOffset() || pb.getBegin().getOffset() > endOffset) continue;
                                if (ed.getSeverity() == Severity.ERROR) {
                                    trueErrors.add(ed);
                                    continue;
                                }
                                others.add(ed);
                            }
                            StringBuffer description = new StringBuffer();
                            AnnotationHolder.concatDescription(trueErrors, description);
                            if (!trueErrors.isEmpty() && !others.isEmpty()) {
                                description.append("\n\n");
                            }
                            AnnotationHolder.concatDescription(others, description);
                            result[0] = description.toString() + NbBundle.getMessage(AnnotationHolder.class, (String)"LBL_shortcut_promotion");
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            return result[0];
        }
    }

    private static class PositionComparator
    implements Comparator<Object> {
        private PositionComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int left = -1;
            if (o1 instanceof Reference) {
                Position value = (Position)((Reference)o1).get();
                if (value == null) {
                    throw ABORT;
                }
                left = value.getOffset();
                assert (left != -1) : "o1=" + o1 + ", value=" + value;
            } else if (o1 instanceof Integer) {
                left = (Integer)o1;
                assert (left != -1) : "o1=" + o1;
            } else assert (false) : "Unexpected type: o1=" + o1;
            int right = -1;
            if (o2 instanceof Reference) {
                Position value = (Position)((Reference)o2).get();
                if (value == null) {
                    throw ABORT;
                }
                right = value.getOffset();
                assert (right != -1) : "o2=" + o2 + ", value=" + value;
            } else if (o2 instanceof Integer) {
                right = (Integer)o2;
                assert (right != -1) : "o2=" + o2;
            } else assert (false) : "Unexpected type: o2=" + o2;
            return left - right;
        }
    }

    private static class Abort
    extends RuntimeException {
        private Abort() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    final class NbDocumentAttacher
    implements Attacher {
        NbDocumentAttacher() {
        }

        @Override
        public void attachAnnotation(Position lineStart, ParseErrorAnnotation a) throws BadLocationException {
            NbDocument.addAnnotation((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (Position)lineStart, (int)-1, (Annotation)a);
        }

        @Override
        public void detachAnnotation(Annotation a) {
            if (AnnotationHolder.this.doc != null) {
                NbDocument.removeAnnotation((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (Annotation)a);
            }
        }
    }

    final class LineAttacher
    implements Attacher {
        LineAttacher() {
        }

        @Override
        public void attachAnnotation(Position line, ParseErrorAnnotation a) throws BadLocationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void detachAnnotation(Annotation a) {
            a.detach();
        }
    }

    static interface Attacher {
        public void attachAnnotation(Position var1, ParseErrorAnnotation var2) throws BadLocationException;

        public void detachAnnotation(Annotation var1);
    }
}

