/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.LocalContext;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.core.TextBlock;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.utility.Collections12;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Macro
extends TemplateElement
implements TemplateModel {
    private final String name;
    private final String[] argumentNames;
    private Map args;
    private String catchAll;
    boolean isFunction;
    static final Macro DO_NOTHING_MACRO = new Macro(".pass", Collections.EMPTY_LIST, Collections12.EMPTY_MAP, TextBlock.EMPTY_BLOCK);

    Macro(String name, List argumentNames, Map args, TemplateElement nestedBlock) {
        this.name = name;
        this.argumentNames = argumentNames.toArray(new String[argumentNames.size()]);
        this.args = args;
        this.nestedBlock = nestedBlock;
    }

    public String getCatchAll() {
        return this.catchAll;
    }

    public void setCatchAll(String value) {
        this.catchAll = value;
    }

    public String[] getArgumentNames() {
        return this.argumentNames;
    }

    boolean hasArgNamed(String name) {
        return this.args.containsKey(name);
    }

    public String getName() {
        return this.name;
    }

    void accept(Environment env) {
        env.visitMacroDef(this);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<#macro ");
        buf.append(this.name);
        buf.append("(");
        int size = this.argumentNames.length;
        for (int i = 0; i < size; ++i) {
            buf.append(this.argumentNames[i]);
            if (i == size - 1) continue;
            buf.append(",");
        }
        buf.append(")>");
        if (this.nestedBlock != null) {
            buf.append(this.nestedBlock.getCanonicalForm());
        }
        buf.append("</#macro>");
        return buf.toString();
    }

    public String getDescription() {
        return "macro " + this.name;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    class Context
    implements LocalContext {
        Environment.Namespace localVars;
        TemplateElement body;
        Environment.Namespace bodyNamespace;
        List bodyParameterNames;
        Context prevMacroContext;
        ArrayList prevLocalContextStack;

        Context(Environment env, TemplateElement body, List bodyParameterNames) {
            this.localVars = env.new Environment.Namespace();
            this.prevMacroContext = env.getCurrentMacroContext();
            this.bodyNamespace = env.getCurrentNamespace();
            this.prevLocalContextStack = env.getLocalContextStack();
            this.body = body;
            this.bodyParameterNames = bodyParameterNames;
        }

        Macro getMacro() {
            return Macro.this;
        }

        void runMacro(Environment env) throws TemplateException, IOException {
            this.sanityCheck(env);
            if (Macro.this.nestedBlock != null) {
                env.visit(Macro.this.nestedBlock);
            }
        }

        void sanityCheck(Environment env) throws TemplateException {
            Iterator it = Macro.this.args.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String argName = (String)entry.getKey();
                if (this.localVars.get(argName) != null) continue;
                Expression valueExp = (Expression)entry.getValue();
                if (valueExp != null) {
                    TemplateModel tm = valueExp.getAsTemplateModel(env);
                    TemplateObject.assertNonNull(tm, valueExp, env);
                    this.localVars.put(argName, tm);
                    continue;
                }
                throw new TemplateException("Error executing macro: " + Macro.this.name + "\nrequired parameter: " + argName + " is not specified.", env);
            }
        }

        public TemplateModel getLocalVariable(String name) throws TemplateModelException {
            return this.localVars.get(name);
        }

        Environment.Namespace getLocals() {
            return this.localVars;
        }

        void setLocalVar(String name, TemplateModel var) {
            this.localVars.put(name, var);
        }

        public Set getLocalVariableNames() throws TemplateModelException {
            HashSet<String> result = new HashSet<String>();
            TemplateModelIterator it = this.localVars.keys().iterator();
            while (it.hasNext()) {
                result.add(it.next().toString());
            }
            return result;
        }
    }
}

