/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.io.IOException;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.JavaElement;
import org.netbeans.modules.web.beans.navigation.Utils;
import org.netbeans.modules.web.beans.navigation.WebBeansNavigationOptions;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class InjectableTreeNode<T extends Element>
extends DefaultMutableTreeNode
implements JavaElement {
    private static final long serialVersionUID = -6398205566811265151L;
    private FileObject myFileObject;
    private ElementHandle<T> myElementHandle;
    private ElementKind myElementKind;
    private Set<Modifier> myModifiers;
    private String myName = "";
    private String myLabel = "";
    private String myFQNlabel = "";
    private String myTooltip;
    private Icon myIcon;
    private ElementJavadoc myJavaDoc;
    private final ClasspathInfo myCpInfo;
    private boolean isDisabled;

    InjectableTreeNode(FileObject fileObject, T t, DeclaredType declaredType, boolean bl, CompilationInfo compilationInfo) {
        this.myFileObject = fileObject;
        this.myElementHandle = ElementHandle.create(t);
        this.myElementKind = t.getKind();
        this.myModifiers = t.getModifiers();
        this.myCpInfo = compilationInfo.getClasspathInfo();
        this.isDisabled = bl;
        this.setName(t.getSimpleName().toString());
        this.setIcon(ElementIcons.getElementIcon((ElementKind)t.getKind(), t.getModifiers()));
        this.setLabel(Utils.format(t, declaredType, compilationInfo));
        this.setFQNLabel(Utils.format(t, declaredType, compilationInfo, false, true));
        this.setToolTip(Utils.format(t, declaredType, compilationInfo, true, WebBeansNavigationOptions.isShowFQN()));
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public FileObject getFileObject() {
        return this.myFileObject;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.myModifiers;
    }

    @Override
    public ElementKind getElementKind() {
        return this.myElementKind;
    }

    protected void setName(String string) {
        this.myName = string;
    }

    @Override
    public String getLabel() {
        return this.myLabel;
    }

    @Override
    public String getFQNLabel() {
        return this.myFQNlabel;
    }

    @Override
    public String getTooltip() {
        return this.myTooltip;
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    protected void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    protected void setLabel(String string) {
        this.myLabel = string;
    }

    protected void setFQNLabel(String string) {
        this.myFQNlabel = string;
    }

    protected void setToolTip(String string) {
        this.myTooltip = string;
    }

    @Override
    public ElementJavadoc getJavaDoc() {
        if (this.myJavaDoc == null) {
            if (this.myFileObject == null) {
                return null;
            }
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.myFileObject);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Element element = InjectableTreeNode.this.myElementHandle.resolve((CompilationInfo)compilationController);
                            InjectableTreeNode.this.setJavaDoc(ElementJavadoc.create((CompilationInfo)compilationController, (Element)element));
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.myJavaDoc;
    }

    protected void setJavaDoc(ElementJavadoc elementJavadoc) {
        this.myJavaDoc = elementJavadoc;
    }

    public ElementHandle<T> getElementHandle() {
        return this.myElementHandle;
    }

    @Override
    public void gotoElement() {
        this.openElementHandle();
    }

    @Override
    public String toString() {
        return WebBeansNavigationOptions.isShowFQN() ? this.getFQNLabel() : this.getLabel();
    }

    protected void openElementHandle() {
        if (this.myFileObject == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
            return;
        }
        if (this.myElementHandle == null) {
            return;
        }
        if (!ElementOpen.open((ClasspathInfo)this.myCpInfo, this.myElementHandle)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
        }
    }
}

