/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import java.util.ArrayList;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.ui.actions.DeleteServiceAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class DeleteGroupAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        for (Node n : nodes) {
            SaasGroup group = (SaasGroup)n.getLookup().lookup(SaasGroup.class);
            if (group != null && group.isUserDefined()) continue;
            return false;
        }
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/websvc/saas/ui/resources/ActionIcon.gif";
    }

    public String getName() {
        return NbBundle.getMessage(DeleteServiceAction.class, (String)"DELETE");
    }

    protected void performAction(Node[] nodes) {
        final ArrayList<SaasGroup> groups = new ArrayList<SaasGroup>();
        for (Node n : nodes) {
            SaasGroup group = (SaasGroup)n.getLookup().lookup(SaasGroup.class);
            if (group == null || !group.isUserDefined()) {
                throw new IllegalArgumentException("Some node has no associated SaasGroup");
            }
            groups.add(group);
        }
        String msg = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"WS_DELETE_GROUP") + " " + groups;
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, 0);
        Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        if (null != response && response.equals(NotifyDescriptor.YES_OPTION)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    for (SaasGroup group : groups) {
                        SaasServicesModel.getInstance().removeGroup(group);
                    }
                }
            });
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

