/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.properties;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.api.properties.GroupValue;

final class SaveToModelSupport {
    private SaveToModelSupport() {
    }

    public static void saveToModel(final DesignComponent component, final GroupValue values, final DesignPropertyEditor propertyEditor) {
        if (component == null || values == null) {
            throw new IllegalArgumentException("Null argument exception");
        }
        component.getDocument().getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (propertyEditor != null && propertyEditor.isExecuteInsideWriteTransactionUsed() && !propertyEditor.executeInsideWriteTransaction()) {
                    return;
                }
                for (String propertyName : values.getPropertyNames()) {
                    if (values.getValue(propertyName) instanceof PropertyValue) {
                        component.writeProperty(propertyName, (PropertyValue)values.getValue(propertyName));
                        continue;
                    }
                    if (values.getValue(propertyName) == null) {
                        component.writeProperty(propertyName, PropertyValue.createNull());
                        continue;
                    }
                    if (values.getValue(propertyName) instanceof DesignComponent) {
                        component.writeProperty(propertyName, PropertyValue.createComponentReference((DesignComponent)((DesignComponent)values.getValue(propertyName))));
                        continue;
                    }
                    component.writeProperty(propertyName, PropertyValue.createValue((String)component.getDocument().getDocumentInterface().getProjectType(), (TypeID)SaveToModelSupport.getComponentTypeID(component, propertyName), (Object)values.getValue(propertyName)));
                }
            }
        });
    }

    private static TypeID getComponentTypeID(DesignComponent component, String propertyName) {
        return component.getComponentDescriptor().getPropertyDescriptor(propertyName).getType();
    }
}

