/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.asm.model.lang.AsmOffsetable;
import org.netbeans.modules.cnd.asm.model.util.DefaultOffsetable;

public class IntervalSet<E extends AsmOffsetable>
implements Iterable<E> {
    private List<E> intervals;

    public IntervalSet() {
        this.intervals = new ArrayList();
    }

    public IntervalSet(int cap) {
        this.intervals = new ArrayList(cap);
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public int getLowerBound() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty");
        }
        return ((AsmOffsetable)this.intervals.get(0)).getStartOffset();
    }

    public int getUpperBound() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty");
        }
        return ((AsmOffsetable)this.intervals.get(this.intervals.size() - 1)).getEndOffset();
    }

    public IntervalSet<E> getFromBounds(int start, int end) {
        IntervalSet<AsmOffsetable> result = new IntervalSet<AsmOffsetable>();
        DefaultOffsetable off = new DefaultOffsetable(start, end);
        for (AsmOffsetable cur : this) {
            int res = IntersectionComparator.getInstance().compare(off, cur);
            if (res == 0) {
                result.add(cur);
                continue;
            }
            if (res >= 0) continue;
            break;
        }
        return result;
    }

    public void add(E interval) {
        int res = Collections.binarySearch(this.intervals, interval, IntersectionComparator.getInstance());
        if (res >= 0) {
            throw new IllegalArgumentException("Intersection");
        }
        this.intervals.add(-res - 1, interval);
    }

    public E getElementAtPosition(int pos) {
        int res = Collections.binarySearch(this.intervals, new DummyOffsetable(pos), IntersectionComparator.getInstance());
        return (E)(res < 0 ? null : (AsmOffsetable)this.intervals.get(res));
    }

    public void clear() {
        this.intervals.clear();
    }

    public List<E> getList() {
        return Collections.unmodifiableList(this.intervals);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getList().iterator();
    }

    private static class DummyOffsetable
    implements AsmOffsetable {
        private int pos;

        public DummyOffsetable(int pos) {
            this.pos = pos;
        }

        @Override
        public int getStartOffset() {
            return this.pos;
        }

        @Override
        public int getEndOffset() {
            return this.pos;
        }
    }

    private static class IntersectionComparator
    implements Comparator<AsmOffsetable> {
        private static final Comparator<AsmOffsetable> instance = new IntersectionComparator();

        public static Comparator<AsmOffsetable> getInstance() {
            return instance;
        }

        @Override
        public int compare(AsmOffsetable o1, AsmOffsetable o2) {
            if (o1.getEndOffset() < o2.getStartOffset()) {
                return -1;
            }
            if (o2.getEndOffset() < o1.getStartOffset()) {
                return 1;
            }
            return 0;
        }

        private IntersectionComparator() {
        }
    }
}

