/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.navigation.FacesModelUtility;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class NavigationCaseEdge
extends PageFlowSceneElement {
    private final NavigationCase navCase;
    private final String toViewID;
    private final PageFlowController pc;
    private static final String MSG_FacesConfigIllegalStateWarning = NbBundle.getMessage(NavigationCaseEdge.class, (String)"MSG_FacesConfigIllegalStateWarning");
    private static final String TLE_FacesConfigIllegalStateWarning = NbBundle.getMessage(NavigationCaseEdge.class, (String)"TLE_FacesConfigIllegalStateWarning");
    private Node navNode;

    public NavigationCaseEdge(PageFlowController pageFlowController, NavigationCase navigationCase) {
        this.navCase = navigationCase;
        this.toViewID = FacesModelUtility.getToViewIdFiltered(navigationCase);
        this.pc = pageFlowController;
    }

    public String toString() {
        return new String("NavigationCaseEdge[FromOutcome=" + this.getFromOuctome() + " ToViewId=" + this.getToViewId() + " FromViewId=" + this.getFromViewId() + "] ");
    }

    public String getToViewId() {
        return this.toViewID;
    }

    public String getFromOuctome() {
        if (this.navCase != null && this.navCase.getModel() != null) {
            return this.navCase.getFromOutcome();
        }
        return null;
    }

    public String getFromAction() {
        if (this.navCase != null && this.navCase.getModel() != null) {
            return this.navCase.getFromAction();
        }
        return null;
    }

    public boolean isRedirected() {
        return this.navCase.isRedirected();
    }

    public String getFromViewId() {
        NavigationRule navigationRule;
        if (this.navCase != null && this.navCase.getModel() != null && (navigationRule = (NavigationRule)this.navCase.getParent()) != null) {
            return FacesModelUtility.getFromViewIdFiltered(navigationRule);
        }
        return null;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    public void setName(String string) {
        Pin pin = this.pc.getView().getEdgeSourcePin(this);
        if (pin != null && !pin.isDefault()) {
            pin.setFromOutcome(string);
        }
        this.pc.setModelNavigationCaseName(this.navCase, string);
        super.setName(string);
    }

    @Override
    public String getName() {
        String string = "";
        if (this.navCase.getModel() != null) {
            try {
                string = this.navCase.getFromOutcome() != null ? this.navCase.getFromOutcome() : this.navCase.getFromAction();
            }
            catch (IllegalStateException illegalStateException) {
                JOptionPane.showMessageDialog(null, MSG_FacesConfigIllegalStateWarning, TLE_FacesConfigIllegalStateWarning, 2);
            }
        }
        return string;
    }

    @Override
    public boolean canDestroy() {
        return true;
    }

    @Override
    public void destroy() throws IOException {
        boolean bl = false;
        this.pc.removeModelNavigationCase(this.navCase);
        if (this.navNode != null) {
            this.navNode.destroy();
        }
    }

    @Override
    public HelpCtx getHelpCtx() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Image getIcon(int n) {
        return null;
    }

    @Override
    public Node getNode() {
        if (this.navNode == null) {
            this.navNode = new NavNode(this);
        }
        return this.navNode;
    }

    public class ModelProperty
    extends PropertySupport.Reflection<String> {
        public ModelProperty(Object object, Class<String> clazz, String string, String string2) throws NoSuchMethodException {
            super(object, clazz, string, string2);
        }

        public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            JSFConfigModel jSFConfigModel = NavigationCaseEdge.this.navCase.getModel();
            jSFConfigModel.startTransaction();
            super.setValue((Object)string);
            jSFConfigModel.endTransaction();
            try {
                jSFConfigModel.sync();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private class NavNode
    extends AbstractNode {
        private final NavigationCaseEdge edge;

        public NavNode(NavigationCaseEdge navigationCaseEdge2) {
            super(Children.LEAF);
            this.edge = navigationCaseEdge2;
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get("general");
            if (set == null) {
                set = new Sheet.Set();
                set.setName("general");
                set.setDisplayName(NbBundle.getMessage(NavigationCaseEdge.class, (String)"General"));
                set.setShortDescription(NbBundle.getMessage(NavigationCaseEdge.class, (String)"GeneralHint"));
                sheet.put(set);
            }
            Sheet.Set set2 = set;
            try {
                ModelProperty modelProperty = new ModelProperty(NavigationCaseEdge.this.navCase, String.class, "getFromOutcome", "setFromOutcome");
                modelProperty.setName("fromOutcome");
                modelProperty.setDisplayName(NbBundle.getMessage(NavigationCaseEdge.class, (String)"Outcome"));
                modelProperty.setShortDescription(NbBundle.getMessage(NavigationCaseEdge.class, (String)"OutcomeHint"));
                set.put((Node.Property)modelProperty);
                modelProperty = new ModelProperty(NavigationCaseEdge.this.navCase, String.class, "getFromAction", "setFromAction");
                modelProperty.setName("fromView");
                modelProperty.setDisplayName(NbBundle.getMessage(NavigationCaseEdge.class, (String)"FromAction"));
                modelProperty.setShortDescription(NbBundle.getMessage(NavigationCaseEdge.class, (String)"FromActionHint"));
                set.put((Node.Property)modelProperty);
                modelProperty = new ModelProperty(NavigationCaseEdge.this.navCase, String.class, "getToViewId", "setToViewId");
                modelProperty.setName("toViewId");
                modelProperty.setDisplayName(NbBundle.getMessage(NavigationCaseEdge.class, (String)"ToViewId"));
                modelProperty.setShortDescription(NbBundle.getMessage(NavigationCaseEdge.class, (String)"ToViewHint"));
                set.put((Node.Property)modelProperty);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
            return sheet;
        }

        public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
            if (clazz.equals(SaveCookie.class)) {
                NavigationCaseEdge.this.pc.serializeNodeLocations();
                return (T)NavigationCaseEdge.this.pc.getConfigDataObject().getCookie(clazz);
            }
            if (clazz.equals(OpenCookie.class)) {
                return (T)new OpenCookie(){

                    public void open() {
                        NavigationCaseEdge.this.pc.openNavigationCase(NavNode.this.edge);
                    }
                };
            }
            return null;
        }

        public boolean canRename() {
            return NavigationCaseEdge.this.isModifiable();
        }

        public String getName() {
            return this.edge.getName();
        }

        public void setName(String string) {
            super.setName(string);
            this.edge.setName(string);
        }
    }
}

