/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class ClassInfoStorage {
    public static final String PROP_CLASS_INFO_CHANGED = "Class2Paths.PROP_CLASS_MAPPING_CHANGED";
    public static final String PROP_CLASS_INFO_ADDED = "Class2Paths.PROP_CLASS_MAPPING_ADDED";
    public static final String PROP_CLASS_INFO_REMOVED = "Class2Paths.PROP_CLASS_MAPPING_REMOVED";
    private static Logger LOG = Logger.getLogger(ClassInfoStorage.class.getName());
    private static ClassInfoStorage instance = null;
    private Lookup.Result<Class2LayerFolder> mappers = null;
    private L mappersListener = null;
    private final String LOCK = new String("Class2Paths.LOCK");
    private Map<String, Info> mapping = new HashMap<String, Info>();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static synchronized ClassInfoStorage getInstance() {
        if (instance == null) {
            instance = new ClassInfoStorage();
        }
        return instance;
    }

    private ClassInfoStorage() {
        this.mappers = Lookup.getDefault().lookupResult(Class2LayerFolder.class);
        this.mappersListener = new L();
        this.mappers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this.mappersListener), this.mappers));
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo(String className) {
        String string = this.LOCK;
        synchronized (string) {
            if (this.mapping.containsKey(className)) {
                return this.mapping.get(className);
            }
            return new Info(this, className, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyChangeEvent> rebuild() {
        String string = this.LOCK;
        synchronized (string) {
            HashMap<String, Info> newMapping = new HashMap<String, Info>();
            for (Class2LayerFolder mapper : this.mappers.allInstances()) {
                String className = mapper.getClazz().getName();
                String path = mapper.getLayerFolderName();
                InstanceProvider ip = mapper.getInstanceProvider();
                if (path != null) {
                    path = path.trim();
                }
                if ((path == null || path.length() == 0) && ip == null) continue;
                if (!newMapping.containsKey(className)) {
                    newMapping.put(className, new Info(this, className, path, ip));
                    continue;
                }
                LOG.warning("The mapping for class '" + className + "' to folder '" + path + "' and InstanceProvider '" + ip + "' has already been " + "defined by another mapper. Ignoring mapper " + mapper);
            }
            HashSet<String> removed = new HashSet<String>(this.mapping.keySet());
            removed.removeAll(newMapping.keySet());
            HashSet added = new HashSet(newMapping.keySet());
            added.removeAll(this.mapping.keySet());
            HashSet<String> changed = new HashSet<String>();
            for (String className : newMapping.keySet()) {
                if (!this.mapping.containsKey(className) || Utilities.compareObjects(newMapping.get(className), (Object)this.mapping.get(className))) continue;
                changed.add(className);
            }
            this.mapping.clear();
            this.mapping.putAll(newMapping);
            ArrayList<PropertyChangeEvent> events = new ArrayList<PropertyChangeEvent>(3);
            if (!removed.isEmpty()) {
                events.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_REMOVED, null, removed));
            }
            if (!added.isEmpty()) {
                events.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_ADDED, null, added));
            }
            if (!changed.isEmpty()) {
                events.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_CHANGED, null, changed));
            }
            return events;
        }
    }

    public static final class Info {
        private ClassInfoStorage storage;
        private String className;
        private String extraPath;
        private String instanceProviderClass;
        private Reference<InstanceProvider<?>> ref;

        private Info(ClassInfoStorage storage, String className, String extraPath, InstanceProvider<?> instanceProvider) {
            this.storage = storage;
            this.className = className;
            String string = this.extraPath = extraPath == null ? "" : extraPath;
            if (instanceProvider != null) {
                this.instanceProviderClass = instanceProvider.getClass().getName();
                this.ref = new WeakReference(instanceProvider);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getExtraPath() {
            return this.extraPath;
        }

        public String getInstanceProviderClass() {
            return this.instanceProviderClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InstanceProvider<?> getInstanceProvider() {
            String string = this.storage.LOCK;
            synchronized (string) {
                if (this.ref == null) {
                    return null;
                }
                InstanceProvider ip = this.ref.get();
                if (ip == null) {
                    for (Class2LayerFolder mapper : this.storage.mappers.allInstances()) {
                        String className = mapper.getClazz().getName();
                        if (!this.className.equals(className)) continue;
                        ip = mapper.getInstanceProvider();
                        break;
                    }
                    if (ip != null) {
                        this.ref = new WeakReference(ip);
                    }
                }
                return ip;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Info) {
                Info info = (Info)obj;
                return this.className.equals(info.className) && Utilities.compareObjects((Object)this.extraPath, (Object)info.extraPath) && Utilities.compareObjects((Object)this.instanceProviderClass, (Object)info.instanceProviderClass);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.className.hashCode();
            if (this.extraPath != null) {
                hashCode += 7 * this.extraPath.hashCode();
            }
            if (this.instanceProviderClass != null) {
                hashCode += 13 * this.instanceProviderClass.hashCode();
            }
            return hashCode;
        }

        public String toString() {
            return "ClassInfoStorage.Info[className=" + this.className + ",extraPath=" + this.extraPath + ",instanceProviderClass=" + this.instanceProviderClass + "]";
        }
    }

    private class L
    implements LookupListener {
        private L() {
        }

        public void resultChanged(LookupEvent ev) {
            for (PropertyChangeEvent event : ClassInfoStorage.this.rebuild()) {
                ClassInfoStorage.this.pcs.firePropertyChange(event);
            }
        }
    }
}

