/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.rest.support.Utils;

public class ParameterInfo {
    private String name;
    private Class type;
    private String typeName;
    private Object defaultValue;
    private boolean isQueryParam;
    private QName qname;

    public ParameterInfo(String string, Class clazz) {
        this(string, clazz, null);
    }

    public ParameterInfo(QName qName, Class clazz, String string) {
        this(qName.getLocalPart(), clazz, string);
        this.qname = qName;
    }

    public ParameterInfo(String string, Class clazz, String string2) {
        this.name = string;
        this.type = clazz;
        this.typeName = string2;
        this.defaultValue = null;
        this.isQueryParam = ParameterInfo.isQualifiedParameterType(clazz);
    }

    private static boolean isQualifiedParameterType(Class clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || Utils.getValueOfMethod(clazz) != null || Utils.getConstructorWithStringParam(clazz) != null;
    }

    public String getName() {
        return this.name;
    }

    public QName getQName() {
        if (this.qname == null) {
            this.qname = new QName(this.name);
        }
        return this.qname;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        if (this.typeName == null) {
            return this.type.getName();
        }
        return this.typeName;
    }

    public String getSimpleTypeName() {
        return this.type.getSimpleName();
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            this.defaultValue = this.generateDefaultValue();
        }
        return this.defaultValue;
    }

    public boolean isQueryParam() {
        return this.isQueryParam;
    }

    public void setIsQueryParam(boolean bl) {
        this.isQueryParam = bl;
    }

    private Object generateDefaultValue() {
        if (this.type == Integer.class || this.type == Short.class || this.type == Long.class || this.type == Float.class || this.type == Double.class) {
            try {
                return this.type.getConstructor(String.class).newInstance("0");
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (this.type == Character.class) {
            return new Character('\u0000');
        }
        return null;
    }
}

