/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.HttpMethodNode;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class HttpMethodsChildren
extends Children.Keys {
    private Project project;
    private RestServicesModel model;
    private String serviceName;
    private RestServicesListener listener;
    private RequestProcessor.Task updateNodeTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            HttpMethodsChildren.this.updateKeys();
        }
    });

    public HttpMethodsChildren(Project project, RestServicesModel restServicesModel, String string) {
        this.project = project;
        this.model = restServicesModel;
        this.serviceName = string;
    }

    protected void addNotify() {
        super.addNotify();
        this.listener = new RestServicesListener();
        try {
            this.model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                    restServicesMetadata.getRoot().addPropertyChangeListener((PropertyChangeListener)HttpMethodsChildren.this.listener);
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.updateKeys();
    }

    protected void removeNotify() {
        try {
            this.model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                    restServicesMetadata.getRoot().removePropertyChangeListener((PropertyChangeListener)HttpMethodsChildren.this.listener);
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.setKeys(Collections.EMPTY_SET);
    }

    private void updateKeys() {
        final ArrayList<String> arrayList = new ArrayList<String>();
        try {
            this.model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                    RestServices restServices = restServicesMetadata.getRoot();
                    RestServiceDescription restServiceDescription = restServices.getRestServiceDescription(HttpMethodsChildren.this.serviceName);
                    if (restServiceDescription != null) {
                        for (RestMethodDescription restMethodDescription : restServiceDescription.getMethods()) {
                            if (!(restMethodDescription instanceof HttpMethod)) continue;
                            arrayList.add(HttpMethodNode.getKey((HttpMethod)restMethodDescription));
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.setKeys(Utils.sortKeys(arrayList));
    }

    protected Node[] createNodes(final Object object) {
        try {
            Node[] nodeArray = (Node[])this.model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Node[]>(){

                public Node[] run(RestServicesMetadata restServicesMetadata) throws IOException {
                    RestServices restServices = restServicesMetadata.getRoot();
                    RestServiceDescription restServiceDescription = restServices.getRestServiceDescription(HttpMethodsChildren.this.serviceName);
                    if (restServiceDescription != null) {
                        for (RestMethodDescription restMethodDescription : restServiceDescription.getMethods()) {
                            if (!(restMethodDescription instanceof HttpMethod) || !HttpMethodNode.getKey((HttpMethod)restMethodDescription).equals(object)) continue;
                            return new Node[]{new HttpMethodNode(HttpMethodsChildren.this.project, restServiceDescription, (HttpMethod)restMethodDescription)};
                        }
                    }
                    return new Node[0];
                }
            });
            return nodeArray;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return new Node[0];
        }
    }

    class RestServicesListener
    implements PropertyChangeListener {
        RestServicesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HttpMethodsChildren.this.updateNodeTask.schedule(0);
        }
    }
}

