/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.common;

import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

public abstract class Rule<E extends Element> {
    public final ErrorDescription[] execute(E e, ProblemContext problemContext) {
        if (this.isApplicable(e, problemContext)) {
            return this.apply(e, problemContext);
        }
        return null;
    }

    protected abstract ErrorDescription[] apply(E var1, ProblemContext var2);

    protected abstract boolean isApplicable(E var1, ProblemContext var2);

    public static ErrorDescription createProblem(Element element, ProblemContext problemContext, String string) {
        return Rule.createProblem(element, problemContext, string, Severity.ERROR, Collections.<Fix>emptyList());
    }

    public static ErrorDescription createProblem(Element element, ProblemContext problemContext, String string, Severity severity) {
        return Rule.createProblem(element, problemContext, string, severity, Collections.<Fix>emptyList());
    }

    public static ErrorDescription createProblem(Element element, ProblemContext problemContext, String string, Severity severity, Fix fix) {
        return Rule.createProblem(element, problemContext, string, severity, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element element, ProblemContext problemContext, String string, Fix fix) {
        return Rule.createProblem(element, problemContext, string, Severity.ERROR, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element element, ProblemContext problemContext, String string, Severity severity, List<Fix> list) {
        Tree tree;
        ErrorDescription errorDescription = null;
        List<Object> list2 = list == null ? Collections.emptyList() : list;
        Tree tree2 = tree = problemContext.getElementToAnnotate() == null ? problemContext.getCompilationInfo().getTrees().getTree(element) : problemContext.getElementToAnnotate();
        if (tree != null) {
            Utilities.TextSpan textSpan = Utilities.getUnderlineSpan(problemContext.getCompilationInfo(), tree);
            errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)severity, (String)string, list2, (FileObject)problemContext.getFileObject(), (int)textSpan.getStartOffset(), (int)textSpan.getEndOffset());
        }
        return errorDescription;
    }
}

