/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.cos.CopyResourcesOnSave;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModInstall
extends ModuleInstall
implements ErrorHandler,
EntityResolver {
    private static int MILIS_IN_SEC = 1000;
    private static int MILIS_IN_MIN = MILIS_IN_SEC * 60;
    private transient PropertyChangeListener projectsListener;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.maven.ModuleInstall");

    public void restored() {
        super.restored();
        try {
            Preferences prfs = NbPreferences.root().node("/org/netbeans/modules/maven/touchme");
            prfs.put("touch", "me");
            prfs.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.disableOldModules();
        this.projectsListener = new OpenProjectsListener();
        OpenProjects.getDefault().addPropertyChangeListener(this.projectsListener);
        if (this.existsDefaultIndexLocation()) {
            final int freq = RepositoryPreferences.getInstance().getIndexUpdateFrequency();
            new RequestProcessor("Maven Repo Index Transfer/Scan").post(new Runnable(){

                @Override
                public void run() {
                    List ris = RepositoryPreferences.getInstance().getRepositoryInfos();
                    for (RepositoryInfo ri : ris) {
                        if (!ri.isRemoteDownloadable() && !ri.isLocal() || freq == 3) continue;
                        boolean run = false;
                        if (freq == 2) {
                            LOGGER.finer("Index At Startup :" + ri.getId());
                            run = true;
                        } else if (freq == 1 && ModInstall.this.checkDiff(ri.getId(), 86400000L)) {
                            LOGGER.finer("Index Once a Day :" + ri.getId());
                            run = true;
                        } else if (freq == 0 && ModInstall.this.checkDiff(ri.getId(), 604800000L)) {
                            LOGGER.finer("Index once a Week :" + ri.getId());
                            run = true;
                        }
                        if (!run || !ri.isRemoteDownloadable()) continue;
                        RepositoryIndexer.indexRepo((RepositoryInfo)ri);
                    }
                }
            }, MILIS_IN_MIN * 2);
        }
    }

    private boolean existsDefaultIndexLocation() {
        String userdir = System.getProperty("netbeans.user");
        assert (userdir != null);
        File cacheDir = new File(new File(new File(userdir, "var"), "cache"), "mavenindex");
        return cacheDir.exists() && cacheDir.isDirectory();
    }

    private boolean checkDiff(String repoid, long amount) {
        Date date = RepositoryPreferences.getInstance().getLastIndexUpdate(repoid);
        Date now = new Date();
        LOGGER.finer("Check Date Diff :" + repoid);
        LOGGER.finer("Last Indexed Date :" + SimpleDateFormat.getInstance().format(date));
        LOGGER.finer("Now :" + SimpleDateFormat.getInstance().format(now));
        long diff = now.getTime() - date.getTime();
        LOGGER.finer("Diff :" + diff);
        return diff < 0L || diff > amount;
    }

    public void uninstalled() {
        super.uninstalled();
        if (this.projectsListener != null) {
            OpenProjects.getDefault().removePropertyChangeListener(this.projectsListener);
        }
    }

    private void disableOldModules() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final ArrayList<String> moduleNames = new ArrayList<String>();
                Collection all = Lookup.getDefault().lookupAll(ModuleInfo.class);
                for (ModuleInfo info : all) {
                    if (!info.getCodeNameBase().startsWith("org.codehaus.mevenide")) continue;
                    moduleNames.add(info.getCodeNameBase());
                }
                try {
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            boolean notified = false;
                            block17: for (String newModule : moduleNames) {
                                FileLock lock = null;
                                OutputStream os = null;
                                try {
                                    String newModuleXML = "Modules/" + newModule.replace('.', '-') + ".xml";
                                    FileObject fo = FileUtil.getConfigFile((String)newModuleXML);
                                    if (fo == null) continue;
                                    Document document = ModInstall.this.readModuleDocument(fo);
                                    NodeList list = document.getDocumentElement().getElementsByTagName("param");
                                    int n = list.getLength();
                                    boolean doNotify = false;
                                    for (int j = 0; j < n; ++j) {
                                        Element node = (Element)list.item(j);
                                        if (!"enabled".equals(node.getAttribute("name"))) continue;
                                        Text text = (Text)node.getChildNodes().item(0);
                                        String value = text.getNodeValue();
                                        if (!"true".equals(value)) continue block17;
                                        doNotify = true;
                                        text.setNodeValue("false");
                                        break;
                                    }
                                    if (doNotify && !notified) {
                                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModInstall.class, (String)"MSG_Install_Warning"));
                                        nd.setTitle(NbBundle.getMessage(ModInstall.class, (String)"MSG_Install_Warning_Title"));
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                                        notified = true;
                                    }
                                    lock = fo.lock();
                                    os = fo.getOutputStream(lock);
                                    XMLUtil.write((Document)document, (OutputStream)os, (String)"UTF-8");
                                }
                                catch (Exception e) {
                                    ErrorManager.getDefault().notify(1, (Throwable)e);
                                }
                                finally {
                                    if (os != null) {
                                        try {
                                            os.close();
                                        }
                                        catch (IOException ex) {}
                                    }
                                    if (lock == null) continue;
                                    lock.releaseLock();
                                }
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    private Document readModuleDocument(FileObject fo) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setEntityResolver(this);
        parser.setErrorHandler(this);
        InputStream is = fo.getInputStream();
        Document document = parser.parse(is);
        is.close();
        return document;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    @Override
    public void error(SAXParseException exception) {
        ErrorManager.getDefault().notify(1, (Throwable)exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        ErrorManager.getDefault().notify(1, (Throwable)exception);
    }

    @Override
    public void warning(SAXParseException exception) {
        ErrorManager.getDefault().notify(1, (Throwable)exception);
    }

    private static class OpenProjectsListener
    implements PropertyChangeListener {
        private OpenProjectsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Project[] prjs = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < prjs.length; ++i) {
                List repos;
                NbMavenProjectImpl mavProj = (NbMavenProjectImpl)prjs[i].getLookup().lookup(NbMavenProjectImpl.class);
                if (mavProj == null || (repos = mavProj.getOriginalMavenProject().getRemoteArtifactRepositories()) == null) continue;
                for (ArtifactRepository rep : repos) {
                    if (RepositoryPreferences.getInstance().getRepositoryInfoById(rep.getId()) != null) continue;
                    RepositoryInfo ri = new RepositoryInfo(rep.getId(), "nexus", rep.getId() + " " + NbBundle.getMessage(ModInstall.class, (String)"LBL_REPOSITORY"), null, rep.getUrl(), null);
                    RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(ri);
                }
            }
            CopyResourcesOnSave.getInstance().checkOpenProjects();
        }
    }
}

