/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.validation.adapters.DialogDescriptorAdapter;
import org.netbeans.api.validation.adapters.NotificationLineSupportAdapter;
import org.netbeans.modules.maven.dependencies.CheckNode;
import org.netbeans.modules.maven.dependencies.CheckNodeListener;
import org.netbeans.modules.maven.dependencies.CheckRenderer;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class CreateLibraryPanel
extends JPanel {
    private DependencyNode rootnode;
    private NotificationLineSupport line;
    private DialogDescriptor dd;
    private ValidationGroup vg;
    private JCheckBox cbCopy;
    private JCheckBox cbJavadocSource;
    private JComboBox comManager;
    private JScrollPane jScrollPane1;
    private JLabel lblIncludes;
    private JLabel lblManager;
    private JLabel lblName;
    private JTree trDeps;
    private JTextField txtName;

    CreateLibraryPanel(DependencyNode root) {
        this.initComponents();
        DefaultComboBoxModel<LibraryManager> mdl = new DefaultComboBoxModel<LibraryManager>();
        this.txtName.putClientProperty("_name", NbBundle.getMessage(CreateLibraryPanel.class, (String)"NAME_Library"));
        for (LibraryManager manager : LibraryManager.getOpenManagers()) {
            mdl.addElement(manager);
        }
        this.comManager.setModel(mdl);
        this.comManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateLibraryPanel.this.vg != null) {
                    CreateLibraryPanel.this.vg.validateAll();
                }
            }
        });
        this.comManager.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                LibraryManager man = (LibraryManager)value;
                return super.getListCellRendererComponent((JList<?>)list, man.getDisplayName(), index, isSelected, cellHasFocus);
            }
        });
        this.trDeps.setCellRenderer(new CheckRenderer(false));
        CheckNodeListener l = new CheckNodeListener(false);
        this.trDeps.addMouseListener(l);
        this.trDeps.addKeyListener(l);
        this.trDeps.setToggleClickCount(0);
        this.trDeps.setRootVisible(false);
        this.trDeps.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.rootnode = root;
        this.trDeps.setModel(new DefaultTreeModel(this.createDependenciesList()));
        this.setLibraryName();
    }

    void createValidations(DialogDescriptor dd) {
        this.line = dd.createNotificationLineSupport();
        this.dd = dd;
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new NotificationLineSupportAdapter(this.line), new DialogDescriptorAdapter(dd)});
        this.vg.add((JTextComponent)this.txtName, new Validator[]{Validators.merge((boolean)true, (Validator[])new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, new LibraryNameExists()})});
    }

    private TreeNode createDependenciesList() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null, true);
        Visitor vis = new Visitor(root);
        this.rootnode.accept((DependencyNodeVisitor)vis);
        return root;
    }

    private void setLibraryName() {
        LibraryManager manager = (LibraryManager)this.comManager.getSelectedItem();
        String currentName = this.getLibraryName();
        int index = 0;
        while (currentName.trim().length() == 0 || manager.getLibrary(currentName.trim()) != null) {
            currentName = this.rootnode.getArtifact().getArtifactId();
            if (index > 0) {
                currentName = currentName + index;
            }
            ++index;
        }
        if (!currentName.equals(this.getLibraryName())) {
            this.txtName.setText(currentName);
        }
    }

    private void initComponents() {
        this.lblManager = new JLabel();
        this.comManager = new JComboBox();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.cbCopy = new JCheckBox();
        this.lblIncludes = new JLabel();
        this.cbJavadocSource = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.trDeps = new JTree();
        this.lblManager.setLabelFor(this.comManager);
        Mnemonics.setLocalizedText((JLabel)this.lblManager, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.lblManager.text"));
        this.comManager.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblName.setLabelFor(this.txtName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.lblName.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCopy, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.cbCopy.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblIncludes, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.lblIncludes.text"));
        this.cbJavadocSource.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbJavadocSource, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.cbJavadocSource.text"));
        this.jScrollPane1.setViewportView(this.trDeps);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.cbCopy, -1, 397, Short.MAX_VALUE).add(1, (Component)this.jScrollPane1, -1, 397, Short.MAX_VALUE).add(1, (Component)this.cbJavadocSource).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblManager).add((Component)this.lblName)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.txtName, -1, 267, Short.MAX_VALUE).add((Component)this.comManager, 0, 267, Short.MAX_VALUE))).add(1, (Component)this.lblIncludes, -2, 177, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblManager).add((Component)this.comManager, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.txtName, -2, -1, -2)).addPreferredGap(1).add((Component)this.cbCopy).add(25, 25, 25).add((Component)this.lblIncludes).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 154, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.cbJavadocSource).add(16, 16, 16)));
    }

    LibraryManager getLibraryManager() {
        return (LibraryManager)this.comManager.getSelectedItem();
    }

    String getLibraryName() {
        String name = this.txtName.getText().trim();
        return name;
    }

    boolean isAllSourceAndJavadoc() {
        return this.cbJavadocSource.isSelected();
    }

    String getCopyDirectory() {
        if (!this.cbCopy.isSelected()) {
            return null;
        }
        String dir = this.getLibraryName();
        return dir;
    }

    List<Artifact> getIncludeArtifacts() {
        Object root = this.trDeps.getModel().getRoot();
        int count = this.trDeps.getModel().getChildCount(root);
        ArrayList<Artifact> toRet = new ArrayList<Artifact>();
        for (int i = 0; i < count; ++i) {
            CheckNode chn = (CheckNode)this.trDeps.getModel().getChild(root, i);
            if (!chn.isSelected()) continue;
            Artifact art = (Artifact)chn.getUserObject();
            toRet.add(art);
        }
        return toRet;
    }

    private static int getScopeOrder(String scope) {
        if (scope == null) {
            return 10;
        }
        if (scope.equals(Artifact.SCOPE_COMPILE)) {
            return 5;
        }
        if (scope.equals(Artifact.SCOPE_RUNTIME)) {
            return 4;
        }
        if (scope.equals(Artifact.SCOPE_TEST)) {
            return 3;
        }
        return 0;
    }

    private class Visitor
    implements DependencyNodeVisitor {
        private DefaultMutableTreeNode rootNode;
        private DependencyNode root;
        private Stack<DependencyNode> path;
        private Icon icn = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/TransitiveDependencyIcon.png", (boolean)true));
        private Icon icn2 = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/DependencyIcon.png", (boolean)true));

        Visitor(DefaultMutableTreeNode root) {
            this.rootNode = root;
        }

        public boolean visit(DependencyNode node) {
            if (this.root == null) {
                this.root = node;
                this.path = new Stack();
                Artifact rootA = node.getArtifact();
                String label = rootA.getGroupId() + ":" + rootA.getArtifactId();
                CheckNode nd = new CheckNode(rootA, label, this.icn2);
                nd.setSelected(true);
                this.rootNode.add(nd);
                return true;
            }
            if (node.getState() == 0) {
                Artifact a = node.getArtifact();
                String label = a.getGroupId() + ":" + a.getArtifactId() + " [" + a.getScope() + "]";
                CheckNode nd = new CheckNode(a, label, this.path.size() > 0 ? this.icn : this.icn2);
                nd.setSelected(CreateLibraryPanel.getScopeOrder(a.getScope()) > 3);
                this.rootNode.add(nd);
            }
            this.path.push(node);
            return true;
        }

        public boolean endVisit(DependencyNode node) {
            if (this.root == node) {
                this.root = null;
                this.path = null;
                return true;
            }
            this.path.pop();
            return true;
        }
    }

    private class LibraryNameExists
    implements Validator<String> {
        private LibraryNameExists() {
        }

        public boolean validate(Problems problems, String compName, String model) {
            String currentName;
            LibraryManager manager = (LibraryManager)CreateLibraryPanel.this.comManager.getSelectedItem();
            if (manager.getLibrary(currentName = model.trim()) != null) {
                problems.add(NbBundle.getMessage(CreateLibraryPanel.class, (String)"ERR_NameExists"));
                return false;
            }
            return true;
        }
    }

    private static class Comp
    implements Comparator<Artifact> {
        private Comp() {
        }

        @Override
        public int compare(Artifact a1, Artifact a2) {
            int trail2;
            int order2;
            String scope1 = a1.getScope();
            String scope2 = a2.getScope();
            int order1 = CreateLibraryPanel.getScopeOrder(scope1);
            if (order1 > (order2 = CreateLibraryPanel.getScopeOrder(scope2))) {
                return -1;
            }
            if (order2 > order1) {
                return 1;
            }
            int trail1 = a1.getDependencyTrail().size();
            if (trail1 > (trail2 = a2.getDependencyTrail().size())) {
                return -1;
            }
            if (trail2 > trail1) {
                return 1;
            }
            return a1.getId().compareTo(a2.getId());
        }
    }
}

