/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.newproject.ArchetypeWizardUtils;
import org.netbeans.modules.maven.newproject.BasicWizardPanel;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class BasicEEWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;
    private Archetype[] archs;
    private String[] eeLevels;

    private BasicEEWizardIterator(String[] eeLevels, Archetype[] archs) {
        this.archs = archs;
        this.eeLevels = eeLevels;
    }

    public static BasicEEWizardIterator createWebAppIterator() {
        return new BasicEEWizardIterator(ArchetypeWizardUtils.EE_LEVELS, ArchetypeWizardUtils.WEB_APP_ARCHS);
    }

    public static BasicEEWizardIterator createEJBIterator() {
        return new BasicEEWizardIterator(ArchetypeWizardUtils.EE_LEVELS, ArchetypeWizardUtils.EJB_ARCHS);
    }

    private WizardDescriptor.Panel[] createPanels(ValidationGroup vg) {
        return new WizardDescriptor.Panel[]{new BasicWizardPanel(vg, this.eeLevels, this.archs, true, false)};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_CreateProjectStep2")};
    }

    public Set instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        return ArchetypeWizardUtils.instantiate(handle, this.wiz);
    }

    public void initialize(WizardDescriptor wiz) {
        this.index = 0;
        ValidationGroup vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new WizardDescriptorAdapter(wiz)});
        this.panels = this.createPanels(vg);
        this.wiz = wiz;
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(BasicEEWizardIterator.class, (String)"NameFormat"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
    }

    public void previousPanel() {
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

