/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.sun;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.netbeans.modules.j2me.cdc.platform.spi.StreamReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SunPlatformDetector
extends CDCPlatformDetector {
    public String getPlatformName() {
        return "SavaJe";
    }

    public String getPlatformType() {
        return "savaje";
    }

    public boolean accept(FileObject dir) {
        FileObject tool = CDCPlatformUtil.findTool((String)"bin", (String)"emulator", Collections.singleton(dir));
        FileObject tool2 = CDCPlatformUtil.findTool((String)"lib", (String)"emulator.properties", Collections.singleton(dir));
        return tool != null && tool2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDCPlatform detectPlatform(FileObject dir) throws IOException {
        assert (dir != null);
        FileObject java = CDCPlatformUtil.findTool((String)"bin", (String)"emulator", Collections.singleton(dir));
        if (java == null) {
            throw new IOException("emulator.exe can not be found in desired location!");
        }
        File javaFile = FileUtil.toFile((FileObject)java);
        if (javaFile == null) {
            throw new IOException("emulator.exe can not be found in desired location!");
        }
        String javapath = javaFile.getAbsolutePath();
        FileObject bin = dir.getFileObject("bin");
        StringBuffer sb = new StringBuffer();
        try {
            String[] command = new String[]{javapath, "-version"};
            Process process = Runtime.getRuntime().exec(command, null, FileUtil.toFile((FileObject)bin));
            StreamReader ior = new StreamReader(process.getInputStream(), sb);
            StringBuffer err = new StringBuffer();
            StreamReader irr = new StreamReader(process.getErrorStream(), err);
            ior.join();
            irr.join();
            process.waitFor();
            process.getOutputStream().close();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                throw new IOException();
            }
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
        FileObject libBin = dir.getFileObject("lib");
        FileObject foProps = libBin.getFileObject("emulator", "properties");
        String name = sb.toString();
        Properties props = new Properties();
        InputStream is = foProps.getInputStream();
        try {
            props.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        name = props.get("emulator.name") != null ? (String)props.get("emulator.name") : name;
        ArrayList<CDCDevice> devices = new ArrayList<CDCDevice>();
        String dvcs = (String)props.get("device.list");
        assert (dvcs != null);
        StringTokenizer st = new StringTokenizer(dvcs, ",");
        HashMap<String, Object> modes = new HashMap<String, Object>();
        modes.put(CDCPlatform.PROP_EXEC_MAIN, null);
        modes.put(CDCPlatform.PROP_EXEC_XLET, null);
        while (st.hasMoreTokens()) {
            String deviceName = st.nextToken().trim();
            String apis = (String)props.get("api.list");
            assert (apis != null);
            StringTokenizer stapis = new StringTokenizer(apis, ",");
            ArrayList<CDCDevice.CDCProfile> profiles = new ArrayList<CDCDevice.CDCProfile>();
            while (stapis.hasMoreTokens()) {
                String api = stapis.nextToken().trim();
                CDCDevice.CDCProfile profile = new CDCDevice.CDCProfile(api, api, api.substring(api.indexOf(45) + 1), modes, this.getClassPathForConfiguration(libBin, (String)props.get(api + ".classpath.build")), this.getClassPathForConfiguration(libBin, (String)props.get(api + ".classpath.run")), api.startsWith("AGUI"));
                profiles.add(profile);
            }
            devices.add(new CDCDevice(deviceName, deviceName, profiles.toArray(new CDCDevice.CDCProfile[profiles.size()]), null));
        }
        ArrayList jdocs = new ArrayList();
        FileObject base = dir.getFileObject("docs");
        if (base != null) {
            SunPlatformDetector.findJavaDoc(base, jdocs);
        }
        return new CDCPlatform(name, name, this.getPlatformType(), "1.4", Collections.singletonList(dir.getURL()), Collections.EMPTY_LIST, jdocs, devices.toArray(new CDCDevice[devices.size()]), true);
    }

    private static void findJavaDoc(FileObject folder, List folders) {
        int i;
        if (folder == null) {
            return;
        }
        FileObject[] fo = folder.getChildren();
        for (i = 0; i < fo.length; ++i) {
            if (!fo[i].isData() || !"index".equals(fo[i].getName())) continue;
            folders.add(fo[i].getParent());
        }
        for (i = 0; i < fo.length; ++i) {
            if (!fo[i].isFolder() || folders.contains(fo[i].getParent())) continue;
            SunPlatformDetector.findJavaDoc(fo[i], folders);
        }
    }

    private String getClassPathForConfiguration(FileObject libBin, String items) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(items, ";");
        while (st.hasMoreTokens()) {
            set.add(st.nextToken());
        }
        StringBuffer bcp = new StringBuffer();
        Enumeration children = libBin.getChildren(true);
        while (children.hasMoreElements()) {
            FileObject elem = (FileObject)children.nextElement();
            if (!set.contains(elem.getNameExt())) continue;
            bcp.append(FileUtil.toFile((FileObject)elem).getAbsolutePath());
            if (!children.hasMoreElements()) continue;
            bcp.append(';');
        }
        return bcp.toString();
    }

    public int getVersion() {
        return 1;
    }
}

