/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RefactoringPluginFactoryImpl
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        if (abstractRefactoring instanceof RenameRefactoring || abstractRefactoring instanceof MoveRefactoring || abstractRefactoring instanceof SingleCopyRefactoring) {
            Lookup lookup = abstractRefactoring.getRefactoringSource();
            FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
            NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
            if (fileObject != null && RefactoringPluginFactoryImpl.isJavaFile(fileObject) || nonRecursiveFolder != null) {
                return new RefactoringPluginImpl(abstractRefactoring);
            }
        }
        return null;
    }

    private static boolean isJavaFile(FileObject fileObject) {
        return "text/x-java".equals(fileObject.getMIMEType());
    }

    static boolean isJavaFileOfForm(FileObject fileObject) {
        return RefactoringPluginFactoryImpl.isJavaFile(fileObject) && fileObject.existsExt("form");
    }

    private static class ResourcePackageUpdate
    implements Transaction {
        private RenameRefactoring refactoring;
        private RefactoringElementImplementation refElement;
        private String oldPkgName;
        private DataFolder resFolder;

        ResourcePackageUpdate(RenameRefactoring renameRefactoring, RefactoringElementImplementation refactoringElementImplementation, FileObject fileObject) {
            this.refactoring = renameRefactoring;
            this.refElement = refactoringElementImplementation;
            this.resFolder = DataFolder.findFolder((FileObject)fileObject);
            this.oldPkgName = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject.getParent(), '.', false);
        }

        public void commit() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.resFolder.getPrimaryFile(), (String)"classpath/source");
            FileObject fileObject = classPath.findOwnerRoot(this.resFolder.getPrimaryFile());
            String string = this.refactoring.getNewName().replace('.', '/');
            try {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.createFolder((FileObject)fileObject, (String)string));
                this.resFolder.move(dataFolder);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void rollback() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.resFolder.getPrimaryFile(), (String)"classpath/source");
            FileObject fileObject = classPath.findOwnerRoot(this.resFolder.getPrimaryFile());
            FileObject fileObject2 = this.resFolder.getPrimaryFile().getParent();
            try {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.createFolder((FileObject)fileObject, (String)this.oldPkgName.replace('.', '/')));
                this.resFolder.move(dataFolder);
                if (fileObject2 != null && fileObject2.isValid() && fileObject2.getChildren().length == 0) {
                    fileObject2.delete();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    private static class ResourceMapUpdate
    extends SimpleRefactoringElementImplementation
    implements Transaction {
        private AbstractRefactoring refactoring;
        private RefactoringElementImplementation refElement;
        private DataObject propertiesDO;
        private DataObject newPropertiesDO;
        private String oldName;
        private FileObject oldFolder;
        private FileObject srcFileBefore;
        private FileObject srcFileAfter;

        ResourceMapUpdate(AbstractRefactoring abstractRefactoring, RefactoringElementImplementation refactoringElementImplementation, FileObject fileObject, DataObject dataObject) {
            this.refactoring = abstractRefactoring;
            this.refElement = refactoringElementImplementation;
            this.propertiesDO = dataObject;
            this.oldName = dataObject.getName();
            this.oldFolder = dataObject.getFolder().getPrimaryFile();
            this.srcFileBefore = fileObject;
        }

        public void commit() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            if (this.refactoring instanceof RenameRefactoring) {
                this.srcFileAfter = this.srcFileBefore;
                String string = ((RenameRefactoring)this.refactoring).getNewName();
                try {
                    this.propertiesDO.rename(string);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else if (this.refactoring instanceof MoveRefactoring) {
                URL uRL = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
                FileObject fileObject = null;
                try {
                    File file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
                    fileObject = FileUtil.toFileObject((File)file);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
                if (fileObject != null && fileObject.isFolder()) {
                    try {
                        fileObject = FileUtil.createFolder((FileObject)fileObject, (String)"resources");
                        this.propertiesDO.move(DataFolder.findFolder((FileObject)fileObject));
                        this.newPropertiesDO = this.propertiesDO;
                        if (this.srcFileBefore != null) {
                            ResourceUtils.unregisterDesignResourceMap(this.srcFileBefore);
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            } else if (this.refactoring instanceof SingleCopyRefactoring) {
                Object object;
                SingleCopyRefactoring singleCopyRefactoring = (SingleCopyRefactoring)this.refactoring;
                URL uRL = (URL)singleCopyRefactoring.getTarget().lookup(URL.class);
                FileObject fileObject = null;
                try {
                    object = FileUtil.normalizeFile((File)new File(uRL.toURI()));
                    fileObject = FileUtil.toFileObject((File)object);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
                if (fileObject != null && fileObject.isFolder()) {
                    object = singleCopyRefactoring.getNewName();
                    try {
                        fileObject = FileUtil.createFolder((FileObject)fileObject, (String)"resources");
                        if (fileObject.getFileObject((String)object, "properties") == null) {
                            this.newPropertiesDO = this.propertiesDO.copy(DataFolder.findFolder((FileObject)fileObject));
                            this.newPropertiesDO.rename((String)object);
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }

        public void rollback() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            if (this.refactoring instanceof RenameRefactoring) {
                try {
                    this.propertiesDO.rename(this.oldName);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else if (this.refactoring instanceof MoveRefactoring) {
                try {
                    this.propertiesDO.move(DataFolder.findFolder((FileObject)this.oldFolder));
                    this.newPropertiesDO = null;
                    if (this.srcFileAfter != null) {
                        ResourceUtils.unregisterDesignResourceMap(this.srcFileAfter);
                        this.srcFileAfter = null;
                    }
                    this.srcFileBefore = this.oldFolder.getParent().getFileObject(this.oldName, "java");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else if (this.refactoring instanceof SingleCopyRefactoring && this.newPropertiesDO != null) {
                try {
                    this.newPropertiesDO.delete();
                    this.newPropertiesDO = null;
                    if (this.srcFileAfter != null) {
                        ResourceUtils.unregisterDesignResourceMap(this.srcFileAfter);
                        this.srcFileAfter = null;
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        public void performChange() {
        }

        public void undoChange() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            if ((this.refactoring instanceof MoveRefactoring || this.refactoring instanceof SingleCopyRefactoring) && this.newPropertiesDO != null) {
                FileObject fileObject = this.newPropertiesDO.getPrimaryFile().getParent().getParent();
                this.srcFileAfter = fileObject.getFileObject(this.newPropertiesDO.getName(), "java");
            }
        }

        public String getText() {
            return "Resources update";
        }

        public String getDisplayText() {
            return NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"CTL_ResourceMapRef", (Object)this.propertiesDO.getPrimaryFile().getNameExt());
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.propertiesDO.getPrimaryFile();
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static class PreviewElement
    extends SimpleRefactoringElementImplementation {
        private FileObject file;
        private String displayText;

        PreviewElement(FileObject fileObject, String string) {
            this.file = fileObject;
            this.displayText = string;
        }

        public String getText() {
            return "Resources update";
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static class RefactoringPluginImpl
    implements RefactoringPlugin {
        private AbstractRefactoring refactoring;

        RefactoringPluginImpl(AbstractRefactoring abstractRefactoring) {
            this.refactoring = abstractRefactoring;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
            FileObject fileObject;
            FileObject fileObject2;
            Lookup lookup = this.refactoring.getRefactoringSource();
            NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
            if (nonRecursiveFolder == null) {
                for (FileObject fileObject3 : lookup.lookupAll(FileObject.class)) {
                    String string;
                    File file;
                    Object object;
                    PropertiesDataObject propertiesDataObject;
                    if (fileObject3.isFolder() || !AppFrameworkSupport.isFrameworkLibAvailable(fileObject3) || (propertiesDataObject = ResourceUtils.getPropertiesDataObject(fileObject3)) == null) continue;
                    PreviewElement previewElement = null;
                    if (this.refactoring instanceof RenameRefactoring) {
                        object = NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"FMT_RenameFileRef", (Object)propertiesDataObject.getPrimaryFile().getNameExt());
                        previewElement = new PreviewElement(fileObject3, (String)object);
                    } else if (this.refactoring instanceof MoveRefactoring) {
                        object = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
                        try {
                            file = FileUtil.normalizeFile((File)new File(((URL)object).toURI()));
                            if (file.isDirectory()) {
                                string = NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"FMT_MoveFileRef", (Object)propertiesDataObject.getPrimaryFile().getNameExt());
                                previewElement = new PreviewElement(fileObject3, string);
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Exceptions.printStackTrace((Throwable)uRISyntaxException);
                        }
                    } else if (this.refactoring instanceof SingleCopyRefactoring) {
                        object = (URL)((SingleCopyRefactoring)this.refactoring).getTarget().lookup(URL.class);
                        try {
                            file = FileUtil.normalizeFile((File)new File(((URL)object).toURI()));
                            if (file.isDirectory()) {
                                string = NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"FMT_CopyFileRef", (Object)propertiesDataObject.getPrimaryFile().getNameExt());
                                previewElement = new PreviewElement(fileObject3, string);
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Exceptions.printStackTrace((Throwable)uRISyntaxException);
                        }
                    }
                    if (previewElement == null) continue;
                    refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)previewElement);
                    object = new ResourceMapUpdate(this.refactoring, (RefactoringElementImplementation)previewElement, fileObject3, (DataObject)propertiesDataObject);
                    refactoringElementsBag.registerTransaction((Transaction)object);
                    refactoringElementsBag.addFileChange(this.refactoring, (RefactoringElementImplementation)object);
                }
            } else if (this.refactoring instanceof RenameRefactoring && AppFrameworkSupport.isFrameworkLibAvailable(fileObject2 = nonRecursiveFolder.getFolder()) && (fileObject = fileObject2.getFileObject("resources")) != null) {
                PreviewElement previewElement = new PreviewElement(fileObject, NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"CTL_ResourcesPackageRef1"));
                refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)previewElement);
                ResourcePackageUpdate resourcePackageUpdate = new ResourcePackageUpdate((RenameRefactoring)this.refactoring, (RefactoringElementImplementation)previewElement, fileObject);
                refactoringElementsBag.registerTransaction((Transaction)resourcePackageUpdate);
            }
            return null;
        }
    }
}

