/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

class FileStateCache {
    private static final boolean TRACE = false;
    private static final boolean cacheStates = TraceFlags.CACHE_FILE_STATE;
    private static final int CACHE_SIZE = 10;
    private static final int MAX_KEY_SIZE = 1000;
    private static int stateCacheAttempt = 0;
    private static int stateCacheSuccessAttempt = 0;
    private final Map<APTHandlersSupport.StateKey, Value> stateCache = new LinkedHashMap<APTHandlersSupport.StateKey, Value>();
    private final ReadWriteLock stateCacheLock = new ReentrantReadWriteLock();
    private final FileImpl file;

    FileStateCache(FileImpl fileImpl) {
        this.file = fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheVisitedState(APTPreprocHandler.State state, APTPreprocHandler aPTPreprocHandler, FilePreprocessorConditionState filePreprocessorConditionState) {
        if (cacheStates && state.isCompileContext()) {
            this.stateCacheLock.writeLock().lock();
            try {
                if ((this.stateCache.isEmpty() || APTHandlersSupport.getIncludeStackDepth((APTPreprocHandler.State)state) == 1) && this.isCacheableState(state)) {
                    if (this.stateCache.size() == 10) {
                        int n = Integer.MAX_VALUE;
                        APTHandlersSupport.StateKey stateKey = null;
                        for (Map.Entry<APTHandlersSupport.StateKey, Value> entry : this.stateCache.entrySet()) {
                            if (entry.getValue().value.get() == null) {
                                stateKey = entry.getKey();
                                break;
                            }
                            if (entry.getValue().count >= n) continue;
                            stateKey = entry.getKey();
                            n = entry.getValue().count;
                        }
                        this.stateCache.remove(stateKey);
                    }
                    this.stateCache.put(FileStateCache.createKey(state), new Value(new PreprocessorStatePair(aPTPreprocHandler.getState(), filePreprocessorConditionState)));
                }
            }
            finally {
                this.stateCacheLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreprocessorStatePair getCachedVisitedState(APTPreprocHandler.State state) {
        PreprocessorStatePair preprocessorStatePair = null;
        if (cacheStates && state.isCompileContext()) {
            this.stateCacheLock.readLock().lock();
            APTHandlersSupport.StateKey stateKey = null;
            try {
                Value value;
                if (this.isCacheableState(state) && (value = this.stateCache.get(stateKey = FileStateCache.createKey(state))) != null) {
                    preprocessorStatePair = (PreprocessorStatePair)value.value.get();
                    value.count++;
                }
            }
            finally {
                this.stateCacheLock.readLock().unlock();
            }
        }
        return preprocessorStatePair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStateCache() {
        if (cacheStates) {
            try {
                this.stateCacheLock.writeLock().lock();
                this.stateCache.clear();
            }
            finally {
                this.stateCacheLock.writeLock().unlock();
            }
        }
    }

    private static APTHandlersSupport.StateKey createKey(APTPreprocHandler.State state) {
        return APTHandlersSupport.getMacroMapID((APTPreprocHandler.State)state);
    }

    private boolean isCacheableState(APTPreprocHandler.State state) {
        return true;
    }

    private static class Value {
        private final SoftReference<PreprocessorStatePair> value;
        private int count;

        private Value(PreprocessorStatePair preprocessorStatePair) {
            this.value = new SoftReference<PreprocessorStatePair>(preprocessorStatePair);
        }
    }
}

