/*
 * Decompiled with CFR 0.152.
 */
package jdbc_adapter;

import java.io.IOException;
import java.sql.SQLException;
import jdbc_adapter.RubyJdbcConnection;
import org.jruby.Ruby;
import org.jruby.RubyBigDecimal;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class JdbcDerbySpec {
    private static RubyObjectAdapter rubyApi;
    private static final ByteList NULL;
    private static final ByteList TWO_SINGLE;
    private static final byte[] HEX;

    public static void load(RubyModule rubyModule, RubyObjectAdapter rubyObjectAdapter) {
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("Derby");
        rubyModule2.defineAnnotatedMethods(JdbcDerbySpec.class);
        RubyModule rubyModule3 = rubyModule2.defineModuleUnder("Column");
        rubyModule3.defineAnnotatedMethods(Column.class);
        rubyApi = rubyObjectAdapter;
    }

    @JRubyMethod(name={"quote"}, required=1, optional=1)
    public static IRubyObject quote(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        if (iRubyObjectArray.length > 1) {
            IRubyObject iRubyObject3 = iRubyObjectArray[1];
            String string = rubyApi.callMethod(iRubyObject3, "type").toString();
            if (iRubyObject2 instanceof RubyString) {
                if (string.equals("string")) {
                    return JdbcDerbySpec.quote_string_with_surround(ruby, "'", (RubyString)iRubyObject2, "'");
                }
                if (string.equals("text")) {
                    return JdbcDerbySpec.quote_string_with_surround(ruby, "CAST('", (RubyString)iRubyObject2, "' AS CLOB)");
                }
                if (string.equals("binary")) {
                    return JdbcDerbySpec.hexquote_string_with_surround(ruby, "CAST(X'", (RubyString)iRubyObject2, "' AS BLOB)");
                }
                if (JdbcDerbySpec.only_digits((RubyString)iRubyObject2)) {
                    return iRubyObject2;
                }
                return JdbcDerbySpec.super_quote(threadContext, iRubyObject, ruby, iRubyObject2, iRubyObject3);
            }
            if ((iRubyObject2 instanceof RubyFloat || iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubyBignum) && string.equals("string")) {
                return JdbcDerbySpec.quote_string_with_surround(ruby, "'", RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject2), "'");
            }
        }
        return JdbcDerbySpec.super_quote(threadContext, iRubyObject, ruby, iRubyObject2, ruby.getNil());
    }

    private static IRubyObject super_quote(ThreadContext threadContext, IRubyObject iRubyObject, Ruby ruby, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (iRubyObject2.respondsTo("quoted_id")) {
            return rubyApi.callMethod(iRubyObject2, "quoted_id");
        }
        IRubyObject iRubyObject4 = iRubyObject3.isNil() ? iRubyObject3 : rubyApi.callMethod(iRubyObject3, "type");
        RubyModule rubyModule = (RubyModule)((RubyModule)ruby.getModule("ActiveSupport").getConstant("Multibyte")).getConstantAt("Chars");
        if (iRubyObject2 instanceof RubyString || rubyApi.isKindOf(iRubyObject2, rubyModule)) {
            RubyString rubyString = RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject2);
            if (iRubyObject4 == ruby.newSymbol("binary") && iRubyObject3.getType().respondsTo("string_to_binary")) {
                return JdbcDerbySpec.quote_string_with_surround(ruby, "'", (RubyString)rubyApi.callMethod((IRubyObject)iRubyObject3.getType(), "string_to_binary", (IRubyObject)rubyString), "'");
            }
            if (iRubyObject4 == ruby.newSymbol("integer") || iRubyObject4 == ruby.newSymbol("float")) {
                return RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)(iRubyObject4 == ruby.newSymbol("integer") ? rubyApi.callMethod((IRubyObject)rubyString, "to_i") : rubyApi.callMethod((IRubyObject)rubyString, "to_f")));
            }
            return JdbcDerbySpec.quote_string_with_surround(ruby, "'", rubyString, "'");
        }
        if (iRubyObject2.isNil()) {
            return ruby.newString(NULL);
        }
        if (iRubyObject2 instanceof RubyBoolean) {
            return iRubyObject2.isTrue() ? (iRubyObject4 == ruby.newSymbol(":integer") ? ruby.newString("1") : rubyApi.callMethod(iRubyObject, "quoted_true")) : (iRubyObject4 == ruby.newSymbol(":integer") ? ruby.newString("0") : rubyApi.callMethod(iRubyObject, "quoted_false"));
        }
        if (iRubyObject2 instanceof RubyFloat || iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubyBignum) {
            return RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject2);
        }
        if (iRubyObject2 instanceof RubyBigDecimal) {
            return rubyApi.callMethod(iRubyObject2, "to_s", (IRubyObject)ruby.newString("F"));
        }
        if (rubyApi.callMethod(iRubyObject2, "acts_like?", (IRubyObject)ruby.newString("date")).isTrue() || rubyApi.callMethod(iRubyObject2, "acts_like?", (IRubyObject)ruby.newString("time")).isTrue()) {
            return JdbcDerbySpec.quote_string_with_surround(ruby, "'", (RubyString)rubyApi.callMethod(iRubyObject, "quoted_date", iRubyObject2), "'");
        }
        return JdbcDerbySpec.quote_string_with_surround(ruby, "'", (RubyString)rubyApi.callMethod(iRubyObject2, "to_yaml"), "'");
    }

    private static IRubyObject quote_string_with_surround(Ruby ruby, String string, RubyString rubyString, String string2) {
        ByteList byteList = rubyString.getByteList();
        ByteList byteList2 = new ByteList(string.getBytes());
        for (int i = byteList.begin; i < byteList.begin + byteList.realSize; ++i) {
            switch (byteList.bytes[i]) {
                case 39: {
                    byteList2.append(byteList.bytes[i]);
                }
            }
            byteList2.append(byteList.bytes[i]);
        }
        byteList2.append(string2.getBytes());
        return ruby.newString(byteList2);
    }

    private static IRubyObject hexquote_string_with_surround(Ruby ruby, String string, RubyString rubyString, String string2) {
        ByteList byteList = rubyString.getByteList();
        ByteList byteList2 = new ByteList(string.getBytes());
        int n = 0;
        for (int i = byteList.begin; i < byteList.begin + byteList.realSize; ++i) {
            byte by = byteList.bytes[i];
            byte by2 = HEX[((char)by >> 4) % 16];
            byte by3 = HEX[(char)by % 16];
            byteList2.append(by2);
            byteList2.append(by3);
            if ((n += 2) < 16334) continue;
            byteList2.append("'||X'".getBytes());
            n = 0;
        }
        byteList2.append(string2.getBytes());
        return ruby.newStringShared(byteList2);
    }

    private static boolean only_digits(RubyString rubyString) {
        ByteList byteList = rubyString.getByteList();
        for (int i = byteList.begin; i < byteList.begin + byteList.realSize; ++i) {
            if (byteList.bytes[i] >= 48 && byteList.bytes[i] <= 57) continue;
            return false;
        }
        return true;
    }

    @JRubyMethod(name={"quote_string"}, required=1)
    public static IRubyObject quote_string(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        boolean bl = false;
        ByteList byteList = ((RubyString)iRubyObject2).getByteList();
        block3: for (int i = byteList.begin; i < byteList.begin + byteList.realSize; ++i) {
            switch (byteList.bytes[i]) {
                case 39: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            if (!bl) {
                i -= byteList.begin;
                byteList = new ByteList(byteList);
                bl = true;
            }
            byteList.replace(i, 1, TWO_SINGLE);
            ++i;
        }
        if (bl) {
            return iRubyObject.getRuntime().newStringShared(byteList);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"select_all"}, rest=true)
    public static IRubyObject select_all(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return rubyApi.callMethod(iRubyObject, "execute", iRubyObjectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"select_one"}, rest=true)
    public static IRubyObject select_one(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject2 = rubyApi.getInstanceVariable(iRubyObject, "@limit");
        if (iRubyObject2 == null || iRubyObject2.isNil()) {
            rubyApi.setInstanceVariable(iRubyObject, "@limit", (IRubyObject)iRubyObject.getRuntime().newFixnum(1));
        }
        try {
            IRubyObject iRubyObject3 = rubyApi.callMethod(iRubyObject, "execute", iRubyObjectArray);
            IRubyObject iRubyObject4 = rubyApi.callMethod(iRubyObject3, "first");
            return iRubyObject4;
        }
        finally {
            rubyApi.setInstanceVariable(iRubyObject, "@limit", iRubyObject.getRuntime().getNil());
        }
    }

    @JRubyMethod(name={"_execute"}, required=1, optional=1)
    public static IRubyObject _execute(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws SQLException, IOException {
        Ruby ruby = iRubyObject.getRuntime();
        RubyJdbcConnection rubyJdbcConnection = (RubyJdbcConnection)rubyApi.getInstanceVariable(iRubyObject, "@connection");
        String string = iRubyObjectArray[0].toString().trim().toLowerCase();
        if (string.charAt(0) == '(') {
            string = string.substring(1).trim();
        }
        if (string.startsWith("insert")) {
            return rubyJdbcConnection.execute_insert(threadContext, iRubyObjectArray[0]);
        }
        if (string.startsWith("select") || string.startsWith("show") || string.startsWith("values")) {
            return rubyJdbcConnection.execute_query(threadContext, iRubyObjectArray[0]);
        }
        return rubyJdbcConnection.execute_update(threadContext, iRubyObjectArray[0]);
    }

    static {
        NULL = new ByteList("NULL".getBytes());
        TWO_SINGLE = new ByteList(new byte[]{39, 39});
        HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    }

    public static class Column {
        @JRubyMethod(name={"type_cast"}, required=1)
        public static IRubyObject type_cast(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Ruby ruby = iRubyObject.getRuntime();
            if (iRubyObject2.isNil() || iRubyObject2 instanceof RubyString && iRubyObject2.toString().trim().equalsIgnoreCase("null")) {
                return ruby.getNil();
            }
            String string = rubyApi.getInstanceVariable(iRubyObject, "@type").toString();
            switch (string.charAt(0)) {
                case 's': {
                    return iRubyObject2;
                }
                case 't': {
                    if (string.equals("text")) {
                        return iRubyObject2;
                    }
                    if (string.equals("timestamp")) {
                        return rubyApi.callMethod((IRubyObject)iRubyObject.getMetaClass(), "string_to_time", iRubyObject2);
                    }
                    return rubyApi.callMethod((IRubyObject)iRubyObject.getMetaClass(), "string_to_dummy_time", iRubyObject2);
                }
                case 'i': 
                case 'p': {
                    if (iRubyObject2.respondsTo("to_i")) {
                        return rubyApi.callMethod(iRubyObject2, "to_i");
                    }
                    return ruby.newFixnum(iRubyObject2.isTrue() ? 1 : 0);
                }
                case 'd': {
                    if (string.equals("datetime")) {
                        return rubyApi.callMethod((IRubyObject)iRubyObject.getMetaClass(), "string_to_time", iRubyObject2);
                    }
                    if (string.equals("date")) {
                        return rubyApi.callMethod((IRubyObject)iRubyObject.getMetaClass(), "string_to_date", iRubyObject2);
                    }
                    return rubyApi.callMethod((IRubyObject)iRubyObject.getMetaClass(), "value_to_decimal", iRubyObject2);
                }
                case 'f': {
                    return rubyApi.callMethod(iRubyObject2, "to_f");
                }
                case 'b': {
                    if (string.equals("binary")) {
                        return rubyApi.callMethod((IRubyObject)iRubyObject.getMetaClass(), "binary_to_string", iRubyObject2);
                    }
                    return rubyApi.callMethod((IRubyObject)iRubyObject.getMetaClass(), "value_to_boolean", iRubyObject2);
                }
            }
            return iRubyObject2;
        }
    }
}

