/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import org.codeviation.commons.utils.StreamUtil;

public final class UrlUriUtil {
    private UrlUriUtil() {
    }

    public static InputStream getInputStream(URL url) throws IOException {
        URLConnection uc = url.openConnection();
        InputStream in = uc.getInputStream();
        return in;
    }

    public static InputStream getInputStream(URI uri) throws IOException {
        URLConnection uc = uri.toURL().openConnection();
        InputStream in = uc.getInputStream();
        return in;
    }

    public static String asString(URI uri) throws IOException {
        return UrlUriUtil.asString(uri.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asString(URL url) throws IOException {
        InputStream is = UrlUriUtil.getInputStream(url);
        try {
            String string = StreamUtil.asString(is);
            return string;
        }
        finally {
            is.close();
        }
    }

    public static Iterator<String> asLines(URL url) throws IOException {
        return StreamUtil.asLines(UrlUriUtil.getInputStream(url));
    }

    public static Iterator<String> asLines(URI uri) throws IOException {
        return StreamUtil.asLines(UrlUriUtil.getInputStream(uri));
    }
}

