/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codeviation.pojson.PojsonLoad;

public class KenaiException
extends IOException {
    private String errorResponse = "";
    private String status;
    private HashMap<String, String> errors;

    public KenaiException(String msg) {
        super(msg);
    }

    public KenaiException(Throwable cause) {
        this.initCause(cause);
    }

    public KenaiException(String message, Throwable cause, String errorResponse) {
        super(message);
        this.initCause(cause);
        this.errorResponse = errorResponse;
    }

    public KenaiException(String message, String errorResponse) {
        this(message);
        this.errorResponse = errorResponse;
    }

    public <T> T getKenaiError(Class<T> clazz) {
        PojsonLoad load = PojsonLoad.create();
        return load.load(this.errorResponse == null ? "" : this.errorResponse, clazz);
    }

    private void fillErrorData() {
        PojsonLoad load = PojsonLoad.create();
        try {
            if (this.errorResponse == null) {
                this.status = "unknown";
                this.errors = new HashMap();
            } else {
                HashMap toCollections = (HashMap)load.toCollections(this.errorResponse);
                if (toCollections == null) {
                    this.status = "unknown";
                    this.errors = new HashMap();
                    this.errors.put("generic", this.errorResponse);
                } else {
                    this.status = (String)toCollections.get("status");
                    this.errors = (HashMap)toCollections.get("errors");
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(KenaiException.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException e) {
            this.status = "unknown";
            this.errors = new HashMap();
            this.errors.put("generic", this.errorResponse);
        }
    }

    public String getAsString() {
        return this.errorResponse;
    }

    public Map<String, String> getAsMap() {
        if (this.errorResponse != null) {
            PojsonLoad load = PojsonLoad.create();
            try {
                return (HashMap)load.toCollections(this.errorResponse);
            }
            catch (IOException ex) {
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    public String getStatus() {
        if (this.errorResponse == null) {
            return null;
        }
        if (this.status == null) {
            this.fillErrorData();
        }
        return this.status;
    }

    public Map<String, String> getErrors() {
        if (this.errorResponse == null) {
            return Collections.emptyMap();
        }
        if (this.errors == null) {
            this.fillErrorData();
        }
        return this.errors;
    }

    @Override
    public String toString() {
        return this.errorResponse == null ? super.toString() : super.toString() + ". Server response=" + this.errorResponse;
    }
}

