/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.threadmap.storage;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.api.support.ThreadStateMapper;

public final class ThreadStateImpl
implements ThreadState {
    private final byte[] stateIDs;
    private final byte[] statePercentage;
    private final int size;
    private final long timestamp;
    private final long samplePeriod;
    static ThreadState.MSAState[] collectedStates = new ThreadState.MSAState[]{null, null, null, ThreadState.MSAState.RunningUser, ThreadState.MSAState.RunningSystemCall, ThreadState.MSAState.RunningOther, ThreadState.MSAState.SleepingUserTextPageFault, ThreadState.MSAState.SleepingUserDataPageFault, ThreadState.MSAState.SleepingKernelPageFault, ThreadState.MSAState.WaitingCPU, ThreadState.MSAState.ThreadStopped, ThreadState.MSAState.SleepingUserLock, ThreadState.MSAState.SleepingOther, null, null, null, null, null};

    public ThreadStateImpl(long timestamp, long samplePeriod, long[] stat) {
        int i;
        int count = 0;
        this.samplePeriod = samplePeriod;
        byte[] states = new byte[stat.length];
        long statesSum = 0L;
        for (i = 3; i < stat.length; ++i) {
            if (stat[i] <= 0L) continue;
            statesSum += stat[i];
            states[count++] = (byte)i;
        }
        this.size = count;
        this.stateIDs = new byte[this.size];
        this.statePercentage = new byte[this.size];
        for (i = 0; i < this.size; ++i) {
            this.stateIDs[i] = states[i];
            this.statePercentage[i] = (byte)(100.0 * (double)stat[this.stateIDs[i]] / (double)statesSum);
        }
        this.timestamp = timestamp;
    }

    public int size() {
        return this.size;
    }

    public ThreadState.MSAState getMSAState(int index, boolean full) {
        if (index >= this.stateIDs.length) {
            return ThreadState.MSAState.ThreadFinished;
        }
        byte stateIdx = this.stateIDs[index];
        assert (stateIdx > 2);
        ThreadState.MSAState fullState = collectedStates[stateIdx];
        return full ? fullState : ThreadStateMapper.toSimpleState((ThreadState.MSAState)fullState);
    }

    public byte getState(int index) {
        return this.statePercentage[index];
    }

    public long getTimeStamp(int index) {
        return -1L;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("MSA " + this.timestamp);
        buf.append(" has " + this.size);
        buf.append(" states\n\tMSA:");
        for (int i = 0; i < this.size(); ++i) {
            buf.append(" ");
            buf.append(this.getMSAState(i, true));
            buf.append("=" + this.getState(i));
        }
        return buf.toString();
    }

    public int getSamplingStateIndex(boolean full) {
        EnumMap<ThreadState.MSAState, AtomicInteger> map = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
        for (int i = 0; i < this.size; ++i) {
            ThreadState.MSAState msa2 = this.getMSAState(i, full);
            if (msa2 == null) continue;
            AtomicInteger value = (AtomicInteger)map.get(msa2);
            if (value == null) {
                value = new AtomicInteger(this.getState(i));
                map.put(msa2, value);
                continue;
            }
            value.addAndGet(this.getState(i));
        }
        ThreadState.MSAState res = null;
        int max = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= max) continue;
            max = ((AtomicInteger)entry.getValue()).get();
            res = entry.getKey();
        }
        if (res != null) {
            for (int i = 0; i < this.size; ++i) {
                ThreadState.MSAState msa3 = this.getMSAState(i, full);
                if (!res.equals((Object)msa3)) continue;
                return i;
            }
        }
        return 0;
    }

    public long getMSASamplePeriod() {
        return this.samplePeriod;
    }
}

