/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.Annotations;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BlameCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final BlameType type;
    private SVNUrl url;
    private File file;
    private SVNRevision revStart;
    private SVNRevision revEnd;
    private byte[] output;

    public BlameCommand(SVNUrl url, SVNRevision revStart, SVNRevision revEnd) {
        this.url = url;
        this.revStart = revStart;
        this.revEnd = revEnd;
        this.file = null;
        this.type = BlameType.url;
    }

    public BlameCommand(File file, SVNRevision revStart, SVNRevision revEnd) {
        this.file = file;
        this.revStart = revStart;
        this.revEnd = revEnd;
        this.url = null;
        this.type = BlameType.file;
    }

    @Override
    protected boolean hasBinaryOutput() {
        return true;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected int getCommand() {
        return 25;
    }

    @Override
    public void output(byte[] bytes) {
        this.output = bytes;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("blame");
        arguments.add("--xml");
        if (this.revStart != null) {
            arguments.add(this.revStart, this.revEnd);
        } else {
            arguments.add(this.revEnd);
        }
        switch (this.type) {
            case url: {
                arguments.add(this.url);
                break;
            }
            case file: {
                arguments.add(this.file);
                this.setCommandWorkingDirectory(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal blametype: " + (Object)((Object)this.type));
            }
        }
    }

    public Annotations.Annotation[] getAnnotation() throws SVNClientException {
        if (this.output == null || this.output.length == 0) {
            return new Annotations.Annotation[0];
        }
        try {
            XMLReader saxReader = XMLUtil.createXMLReader();
            XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
            saxReader.setContentHandler(xmlEntriesHandler);
            saxReader.setErrorHandler(xmlEntriesHandler);
            InputSource source = new InputSource(new ByteArrayInputStream(this.output));
            saxReader.parse(source);
            return xmlEntriesHandler.getAnnotations();
        }
        catch (SAXException ex) {
            throw new SVNClientException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new SVNClientException((Throwable)ex);
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String BLAME_ELEMENT_NAME = "blame";
        private static final String TARGET_ELEMENT_NAME = "target";
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String COMMIT_ELEMENT_NAME = "commit";
        private static final String AUTHOR_ELEMENT_NAME = "author";
        private static final String DATE_ELEMENT_NAME = "date";
        private static final String PATH_ATTRIBUTE = "path";
        private static final String LINE_NUMBER_ATTRIBUTE = "line-number";
        private static final String REVISION_ATTRIBUTE = "revision";
        private String REVISION_ATTR = "revision_attr";
        private List<Annotations.Annotation> annotations = new ArrayList<Annotations.Annotation>();
        private Map<String, String> values;
        private String tag;

        private XmlEntriesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes elementAttributes) throws SAXException {
            this.tag = qName.trim();
            if (TARGET_ELEMENT_NAME.equals(qName)) {
                this.values = new HashMap<String, String>();
            } else if (COMMIT_ELEMENT_NAME.equals(qName)) {
                this.values.put(this.REVISION_ATTR, elementAttributes.getValue(REVISION_ATTRIBUTE));
            } else if (ENTRY_ELEMENT_NAME.equals(qName)) {
                this.values.put(LINE_NUMBER_ATTRIBUTE, elementAttributes.getValue(LINE_NUMBER_ATTRIBUTE));
            }
            if (this.values != null) {
                this.values.put(this.tag, "");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.values == null || this.tag == null) {
                return;
            }
            String s = this.toString(length, ch, start);
            String v = this.values.get(this.tag);
            if (v == null) {
                this.values.put(this.tag, s);
            } else {
                this.values.put(this.tag, v + s);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.tag = null;
            if (ENTRY_ELEMENT_NAME.equals(name)) {
                if (this.values != null) {
                    String commit = this.values.get(COMMIT_ELEMENT_NAME);
                    if (commit != null) {
                        String author = this.values.get(AUTHOR_ELEMENT_NAME);
                        Date date = null;
                        String dateValue = this.values.get(DATE_ELEMENT_NAME);
                        if (dateValue != null) {
                            try {
                                date = dateFormat.parse(dateValue);
                            }
                            catch (ParseException ex) {
                                // empty catch block
                            }
                        }
                        SVNRevision.Number rev = null;
                        String revisionValue = this.values.get(this.REVISION_ATTR);
                        if (revisionValue != null && !revisionValue.trim().equals("")) {
                            try {
                                rev = new SVNRevision.Number(Long.parseLong(revisionValue));
                            }
                            catch (NumberFormatException e) {
                                rev = new SVNRevision.Number(-1L);
                            }
                        }
                        this.annotations.add(new Annotations.Annotation(rev.getNumber(), author, date, null));
                    } else {
                        this.annotations.add(null);
                    }
                }
            } else if (TARGET_ELEMENT_NAME.equals(name)) {
                this.values = null;
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public Annotations.Annotation[] getAnnotations() {
            return this.annotations.toArray(new Annotations.Annotation[this.annotations.size()]);
        }

        private String toString(int length, char[] ch, int start) {
            char[] c = new char[length];
            System.arraycopy(ch, start, c, 0, length);
            return new String(c);
        }
    }

    private static enum BlameType {
        url,
        file;

    }
}

