/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.repositorystep;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.WizardStepProgressSupport;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStepPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryStep
extends AbstractStep
implements WizardDescriptor.AsynchronousValidatingPanel,
PropertyChangeListener {
    public static final String IMPORT_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.import";
    public static final String CHECKOUT_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.checkout";
    public static final String URL_PATTERN_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.urlPattern";
    private Repository repository;
    private RepositoryStepPanel panel;
    private RepositoryFile repositoryFile;
    private int repositoryModeMask;
    private WizardStepProgressSupport support;
    private final String helpID;

    public RepositoryStep(String helpID) {
        this.repositoryModeMask = 0;
        this.helpID = helpID;
    }

    public RepositoryStep(int repositoryModeMask, String helpID) {
        this.repositoryModeMask = repositoryModeMask;
        this.helpID = helpID;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(this.helpID);
    }

    @Override
    protected JComponent createComponent() {
        if (this.repository == null) {
            this.repositoryModeMask = this.repositoryModeMask | 2 | 4 | 0x20 | 0x40;
            String title = NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(this.repositoryModeMask, title);
            this.repository.addPropertyChangeListener(this);
            this.panel = new RepositoryStepPanel();
            this.panel.repositoryPanel.add(this.repository.getPanel());
            this.valid();
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateBeforeNext() {
        try {
            this.support = new RepositoryStepProgressSupport(this.panel.progressPanel);
            SVNUrl url = this.getUrl();
            this.support.setRepositoryRoot(url);
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(url);
            RequestProcessor.Task task = this.support.start(rp, url, NbBundle.getMessage(RepositoryStep.class, (String)"BK2012"));
            task.waitFinished();
        }
        finally {
            this.support = null;
        }
    }

    public void prepareValidation() {
    }

    private SVNUrl getUrl() {
        try {
            return this.getSelectedRepositoryConnection().getSvnUrl();
        }
        catch (MalformedURLException mue) {
            Subversion.LOG.log(Level.INFO, null, mue);
            return null;
        }
    }

    private void storeHistory() {
        RepositoryConnection rc = this.getSelectedRepositoryConnection();
        if (rc != null) {
            SvnModuleConfig.getDefault().insertRecentUrl(rc);
        }
    }

    public RepositoryFile getRepositoryFile() {
        return this.repositoryFile;
    }

    private RepositoryConnection getSelectedRepositoryConnection() {
        try {
            return this.repository.getSelectedRC();
        }
        catch (Exception ex) {
            this.invalid(new AbstractStep.WizardMessage(ex.getLocalizedMessage(), false));
            return null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid")) {
            if (this.repository.isValid()) {
                this.valid(new AbstractStep.WizardMessage(this.repository.getMessage(), false));
            } else {
                this.invalid(new AbstractStep.WizardMessage(this.repository.getMessage(), false));
            }
        }
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        public RepositoryStepProgressSupport(JPanel panel) {
            super(panel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void perform() {
            AbstractStep.WizardMessage invalidMsg;
            block26: {
                block27: {
                    block28: {
                        block29: {
                            block24: {
                                block25: {
                                    RepositoryConnection rc = RepositoryStep.this.getSelectedRepositoryConnection();
                                    if (rc == null) {
                                        return;
                                    }
                                    RepositoryStep.this.storeHistory();
                                    invalidMsg = null;
                                    try {
                                        SvnClient client;
                                        RepositoryStep.this.invalid(null);
                                        SVNUrl url = rc.getSvnUrl();
                                        try {
                                            int handledExceptions = 8;
                                            client = Subversion.getInstance().getClient(url, rc.getUsername(), rc.getPassword(), handledExceptions);
                                        }
                                        catch (SVNClientException ex) {
                                            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                                            invalidMsg = new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)rc.getUrl()), false);
                                            if (this.isCanceled()) {
                                                RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                                                return;
                                            }
                                            if (invalidMsg == null) {
                                                RepositoryStep.this.valid();
                                                return;
                                            }
                                            RepositoryStep.this.valid(invalidMsg);
                                            return;
                                        }
                                        RepositoryStep.this.repositoryFile = null;
                                        ISVNInfo info = null;
                                        try {
                                            RepositoryStep.this.repository.storeConfigValues();
                                            this.setCancellableDelegate(client);
                                            info = client.getInfo(url);
                                        }
                                        catch (SVNClientException ex) {
                                            this.annotate(ex);
                                            invalidMsg = new AbstractStep.WizardMessage(SvnClientExceptionHandler.parseExceptionMessage(ex), false);
                                        }
                                        if (this.isCanceled()) {
                                            if (!this.isCanceled()) break block24;
                                            break block25;
                                        }
                                        if (info != null) {
                                            SVNUrl repositoryUrl = SvnUtils.decode(info.getRepository());
                                            if (repositoryUrl == null) {
                                                repositoryUrl = rc.getSvnUrl();
                                            }
                                            SVNRevision revision = rc.getSvnRevision();
                                            String[] repositorySegments = repositoryUrl.getPathSegments();
                                            String[] selectedSegments = rc.getSvnUrl().getPathSegments();
                                            String[] repositoryFolder = new String[selectedSegments.length - repositorySegments.length];
                                            System.arraycopy(selectedSegments, repositorySegments.length, repositoryFolder, 0, repositoryFolder.length);
                                            RepositoryStep.this.repositoryFile = new RepositoryFile(repositoryUrl, repositoryFolder, revision);
                                            if (!this.isCanceled()) break block26;
                                            break block27;
                                        }
                                        invalidMsg = new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)rc.getUrl()), false);
                                        if (!this.isCanceled()) break block28;
                                        break block29;
                                    }
                                    catch (MalformedURLException ex) {
                                        Subversion.LOG.log(Level.INFO, null, ex);
                                        return;
                                    }
                                }
                                RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                                return;
                            }
                            if (invalidMsg == null) {
                                RepositoryStep.this.valid();
                                return;
                            }
                            RepositoryStep.this.valid(invalidMsg);
                            return;
                        }
                        RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                        return;
                    }
                    if (invalidMsg == null) {
                        RepositoryStep.this.valid();
                        return;
                    }
                    RepositoryStep.this.valid(invalidMsg);
                    return;
                }
                RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                return;
            }
            if (invalidMsg == null) {
                RepositoryStep.this.valid();
                return;
            }
            RepositoryStep.this.valid(invalidMsg);
            return;
            finally {
                if (this.isCanceled()) {
                    RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                } else if (invalidMsg == null) {
                    RepositoryStep.this.valid();
                } else {
                    RepositoryStep.this.valid(invalidMsg);
                }
            }
        }

        @Override
        public void setEditable(boolean editable) {
            RepositoryStep.this.repository.setEditable(editable);
        }
    }
}

